/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Vector3;
import codechicken.lib.world.IChunkLoadTile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mrtjp.projectred.core.CoreNetwork;
import mrtjp.projectred.core.tile.IPacketReceiverTile;
import mrtjp.projectred.core.tile.ProjectRedTile;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.block.ICWorkbenchBlock;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.IICWorkbenchEditorNetwork;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchScreen;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import mrtjp.projectred.fabrication.init.FabricationItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;

public class ICWorkbenchTile
extends ProjectRedTile
implements IPacketReceiverTile,
IICWorkbenchEditorNetwork,
IChunkLoadTile {
    private static final int KEY_CLIENT_OPENED_SCREEN = 0;
    private static final int KEY_CLIENT_CLOSED_SCREEN = 1;
    private static final int KEY_EDITOR_DESCRIPTION_UPDATE = 50;
    private static final int KEY_EDITOR_PACKET = 100;
    private final ICWorkbenchEditor editor = new ICWorkbenchEditor(this);
    private final Map<Integer, PacketCustom> editorBufferedStreams = new HashMap<Integer, PacketCustom>();
    private final Set<ServerPlayer> playersWatchingScreen = new HashSet<ServerPlayer>();

    public ICWorkbenchTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)FabricationBlocks.IC_WORKBENCH_TILE.get(), pos, state);
    }

    public ICWorkbenchEditor getEditor() {
        return this.editor;
    }

    public void writeDesc(MCDataOutput out) {
        this.editor.writeDesc(out);
    }

    public void readDesc(MCDataInput in) {
        this.editor.readDesc(in);
    }

    public void saveToNBT(CompoundTag tag) {
        this.editor.save(tag);
    }

    public void loadFromNBT(CompoundTag tag) {
        this.editor.load(tag);
    }

    private Set<ServerPlayer> filterAndGetWatchers() {
        Set toRemove = this.playersWatchingScreen.stream().filter(ServerPlayer::m_9232_).collect(Collectors.toSet());
        this.playersWatchingScreen.removeAll(toRemove);
        return this.playersWatchingScreen;
    }

    public void tick() {
        this.editor.tick();
        this.flushEditorStreams();
    }

    public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.m_58904_().m_5776_()) {
            boolean blueprintInHand;
            ItemStack stackInHand = player.m_21120_(hand);
            boolean blueprintOnTable = (Boolean)this.m_58900_().m_61143_((Property)ICWorkbenchBlock.BLUEPRINT_PROPERTY);
            boolean bl = blueprintInHand = !stackInHand.m_41619_() && stackInHand.m_41720_() == FabricationItems.IC_BLUEPRINT_ITEM.get();
            if (!blueprintOnTable && blueprintInHand) {
                this.editor.readBlueprintTagAndActivate(stackInHand.m_41783_());
                stackInHand.m_41774_(1);
                this.setBlueprintBlockState(true);
                this.sendEditorDescription();
            } else if (blueprintOnTable && player.m_6047_()) {
                ItemStack blueprintToDrop = this.createBlueprintStack();
                this.dropBlueprintStack(blueprintToDrop);
                this.setBlueprintBlockState(false);
                this.sendEditorDescription();
            } else {
                this.openGuiFromServer(player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void onBlockRemoved() {
        if (this.getEditor().isActive()) {
            ItemStack blueprintToDrop = this.createBlueprintStack();
            ProjectRedTile.dropItem((ItemStack)blueprintToDrop, (Level)this.m_58904_(), (Vector3)Vector3.fromBlockPos((BlockPos)this.m_58899_()));
        }
    }

    private ItemStack createBlueprintStack() {
        ItemStack stack = new ItemStack((ItemLike)FabricationItems.IC_BLUEPRINT_ITEM.get());
        this.editor.writeBlueprintTagAndDeactivate(stack.m_41784_());
        return stack;
    }

    private void dropBlueprintStack(ItemStack blueprintToDrop) {
        BlockPos pos = this.m_58899_().m_7918_(0, 1, 0);
        ItemEntity itemEntity = new ItemEntity(this.m_58904_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, blueprintToDrop);
        itemEntity.m_32010_(10);
        itemEntity.m_20334_(0.0, 0.15, 0.0);
        this.m_58904_().m_7967_((Entity)itemEntity);
    }

    private void setBlueprintBlockState(boolean blueprintOnTable) {
        BlockState newState = (BlockState)this.m_58900_().m_61124_((Property)ICWorkbenchBlock.BLUEPRINT_PROPERTY, (Comparable)Boolean.valueOf(blueprintOnTable));
        this.m_58904_().m_46597_(this.m_58899_(), newState);
    }

    private void openGuiFromServer(Player player) {
        if (this.m_58904_().f_46443_ || !(player instanceof ServerPlayer)) {
            throw new RuntimeException("Server only");
        }
        this.filterAndGetWatchers().add((ServerPlayer)player);
        this.sendUpdateToPlayer(0, this.editor::writeDesc, (ServerPlayer)player);
    }

    private void sendEditorDescription() {
        this.sendUpdateToPlayerList(50, this.editor::writeDesc, this.playersWatchingScreen);
    }

    public void closeGuiFromClient() {
        this.sendUpdateToServer(1, n -> {});
    }

    public void receiveUpdateFromServer(int key, MCDataInput input) {
        switch (key) {
            case 0: {
                this.editor.readDesc(input);
                ICWorkbenchScreen.openGuiOnClient(this);
                break;
            }
            case 50: {
                this.editor.readDesc(input);
                break;
            }
            case 100: {
                this.receiveBufferedStream(input);
                break;
            }
            default: {
                ProjectRedFabrication.LOGGER.error("Unknown packet key from server: " + key);
            }
        }
    }

    public void receiveUpdateFromClient(int key, MCDataInput input, ServerPlayer player) {
        switch (key) {
            case 1: {
                this.filterAndGetWatchers().remove(player);
                break;
            }
            case 100: {
                this.receiveBufferedStream(input);
                break;
            }
            default: {
                ProjectRedFabrication.LOGGER.error("Unknown packet key from client: " + key);
            }
        }
    }

    private void receiveBufferedStream(MCDataInput in) {
        short streamKey = in.readUByte();
        short frameKey = in.readUByte();
        while (frameKey != 255) {
            this.editor.readBufferedStream(in, streamKey, frameKey);
            frameKey = in.readUByte();
        }
    }

    public void onChunkLoad(LevelChunk chunk) {
        this.editor.onChunkLoad();
    }

    @Override
    public MCDataOutput getBufferedStream(int streamKey, int frameKey) {
        MCDataOutput out = (MCDataOutput)this.editorBufferedStreams.computeIfAbsent(streamKey, k -> {
            PacketCustom packet = this.m_58904_().f_46443_ ? CoreNetwork.createTileServerPacket((IPacketReceiverTile)this, (byte)100) : CoreNetwork.createTileClientPacket((IPacketReceiverTile)this, (byte)100);
            packet.writeByte(k.intValue());
            return packet;
        });
        return out.writeByte(frameKey);
    }

    private void flushEditorStreams() {
        for (PacketCustom packet : this.editorBufferedStreams.values()) {
            packet.writeByte(255);
            if (this.m_58904_().f_46443_) {
                packet.sendToServer();
                continue;
            }
            for (ServerPlayer player : this.filterAndGetWatchers()) {
                packet.sendToPlayer(player);
            }
        }
        this.editorBufferedStreams.clear();
    }

    @Override
    public boolean isClientSide() {
        return this.m_58904_().m_5776_();
    }

    @Override
    public void markSave() {
        this.m_6596_();
    }

    @Override
    public long getGameTime() {
        return this.m_58904_().m_46467_();
    }
}

