/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrtjp.projectred.core.inventory.BaseInventory;
import mrtjp.projectred.fabrication.editor.EditorDataUtils;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import mrtjp.projectred.fabrication.init.FabricationItems;
import mrtjp.projectred.fabrication.inventory.container.LithographyTableContainer;
import mrtjp.projectred.fabrication.item.BaseSiliconWaferItem;
import mrtjp.projectred.fabrication.item.PhotomaskSetItem;
import mrtjp.projectred.fabrication.lithography.ProcessNode;
import mrtjp.projectred.fabrication.lithography.WaferType;
import mrtjp.projectred.fabrication.tile.FabricationMachineTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class LithographyTableTile
extends FabricationMachineTile {
    private final BaseInventory inventory = new BaseInventory(4){

        public boolean m_7013_(int slot, ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.m_41720_() instanceof PhotomaskSetItem;
                case 1 -> stack.m_41720_() instanceof BaseSiliconWaferItem;
                default -> false;
            };
        }

        public void m_6596_() {
            super.m_6596_();
            LithographyTableTile.this.cancelWorkIfNeeded();
        }
    };

    public LithographyTableTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)FabricationBlocks.LITHOGRAPHY_TABLE_TILE.get(), pos, state);
        this.inventory.m_19164_(c -> this.m_6596_());
    }

    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        super.saveToNBT(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.m_7927_());
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        this.inventory.loadFrom(tag, "inventory");
    }

    public void writeDesc(MCDataOutput out) {
    }

    public void readDesc(MCDataInput in) {
    }

    public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.m_58904_().f_46443_) {
            ServerUtils.openContainer((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new LithographyTableContainer(inv, this, id), (Component)this.m_58900_().m_60734_().m_49954_()), p -> p.writePos(this.m_58899_()));
        }
        return InteractionResult.SUCCESS;
    }

    public void onBlockRemoved() {
        super.onBlockRemoved();
        LithographyTableTile.dropInventory((Container)this.inventory, (Level)this.m_58904_(), (Vector3)Vector3.fromBlockPos((BlockPos)this.m_58899_()));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return super.getCapability(cap, side);
    }

    @Override
    protected boolean canStartWork() {
        ItemStack slot0 = this.inventory.m_8020_(0);
        ItemStack slot1 = this.inventory.m_8020_(1);
        if (slot0.m_41619_() || slot1.m_41619_()) {
            return false;
        }
        if (!(slot0.m_41720_() instanceof PhotomaskSetItem)) {
            return false;
        }
        if (!(slot1.m_41720_() instanceof BaseSiliconWaferItem)) {
            return false;
        }
        if (!EditorDataUtils.canFabricate(slot0.m_41783_())) {
            return false;
        }
        return this.inventory.m_8020_(2).m_41619_() && this.inventory.m_8020_(3).m_41619_();
    }

    @Override
    protected int startWork() {
        return 1200;
    }

    @Override
    protected int tickWork(int remainingWork) {
        if (this.canConductorWork()) {
            this.conductor.applyPower(-100.0);
            return 1;
        }
        return 0;
    }

    @Override
    protected void finishWork() {
        BaseSiliconWaferItem wafer = (BaseSiliconWaferItem)this.inventory.m_8020_(1).m_41720_();
        WaferType waferType = wafer.getWaferType();
        ProcessNode processNode = ProcessNode.PROCESS_64NM;
        int dieWidth = processNode.getTileWidth() * 16;
        int dieHeight = processNode.getTileHeight() * 16;
        int gridWidth = waferType.getWaferWidth() / dieWidth;
        int gridHeight = waferType.getWaferHeight() / dieHeight;
        double defectChancePerDie = (double)(dieWidth * dieHeight) * waferType.getDefectRatePerUnitArea();
        int totalDesigns = gridWidth * gridHeight;
        int totalDefectiveDies = 0;
        for (int i = 0; i < totalDesigns; ++i) {
            if (!(Math.random() < defectChancePerDie)) continue;
            ++totalDefectiveDies;
        }
        int totalValidDies = totalDesigns - totalDefectiveDies;
        if (totalValidDies > 0) {
            ItemStack validDieStack = PhotomaskSetItem.createDieStack(this.inventory.m_8020_(0), totalValidDies);
            this.inventory.m_6836_(2, validDieStack);
        }
        if (totalDefectiveDies > 0) {
            ItemStack defectiveDieStack = new ItemStack((ItemLike)FabricationItems.INVALID_DIE_ITEM.get(), totalDefectiveDies);
            this.inventory.m_6836_(3, defectiveDieStack);
        }
        this.inventory.m_7407_(1, 1);
    }
}

