/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrtjp.projectred.core.init.CoreItems;
import mrtjp.projectred.core.inventory.BaseInventory;
import mrtjp.projectred.core.tile.IPacketReceiverTile;
import mrtjp.projectred.fabrication.editor.EditorDataUtils;
import mrtjp.projectred.fabrication.engine.ICInterfaceType;
import mrtjp.projectred.fabrication.engine.InterfaceSpec;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import mrtjp.projectred.fabrication.inventory.container.PackagingTableContainer;
import mrtjp.projectred.fabrication.item.ValidDieItem;
import mrtjp.projectred.fabrication.tile.FabricationMachineTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class PackagingTableTile
extends FabricationMachineTile
implements IPacketReceiverTile {
    private static final int DIE_SLOT = 4;
    private static final int OUTPUT_SLOT = 9;
    private final BaseInventory inventory = new BaseInventory(10){

        public boolean m_7013_(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 4 -> stack.m_41720_() instanceof ValidDieItem;
                case 9 -> false;
                default -> true;
            };
        }

        public void m_6596_() {
            super.m_6596_();
            PackagingTableTile.this.cancelWorkIfNeeded();
        }
    };
    private int problematicSlotMask = 0;

    public PackagingTableTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)FabricationBlocks.PACKAGING_TABLE_TILE.get(), pos, state);
        this.inventory.m_19164_(c -> this.m_6596_());
    }

    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        super.saveToNBT(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.m_7927_());
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        this.inventory.loadFrom(tag, "inventory");
    }

    public void writeDesc(MCDataOutput out) {
    }

    public void readDesc(MCDataInput in) {
    }

    public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.m_58904_().f_46443_) {
            ServerUtils.openContainer((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new PackagingTableContainer(inv, this, id), (Component)this.m_58900_().m_60734_().m_49954_()), p -> p.writePos(this.m_58899_()));
        }
        return InteractionResult.SUCCESS;
    }

    public void onBlockRemoved() {
        super.onBlockRemoved();
        PackagingTableTile.dropInventory((Container)this.inventory, (Level)this.m_58904_(), (Vector3)Vector3.fromBlockPos((BlockPos)this.m_58899_()));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return super.getCapability(cap, side);
    }

    @Override
    protected boolean canStartWork() {
        int[] cornerSlots;
        this.problematicSlotMask = 0;
        ItemStack dieItem = this.inventory.m_8020_(4);
        CompoundTag dieTag = dieItem.m_41783_();
        if (dieItem.m_41619_() || !(dieItem.m_41720_() instanceof ValidDieItem) || !EditorDataUtils.hasFabricationTarget(dieTag)) {
            this.problematicSlotMask |= 0x10;
            return false;
        }
        if (!this.inventory.m_8020_(9).m_41619_()) {
            this.problematicSlotMask |= 0x200;
        }
        InterfaceSpec iospec = EditorDataUtils.getInterfaceSpec(dieTag);
        int[] slotMap = new int[]{1, 5, 7, 3};
        for (int r = 0; r < 4; ++r) {
            ICInterfaceType type = iospec.getInterfaceType(r);
            ItemStack itemStack = this.inventory.m_8020_(slotMap[r]);
            boolean match = itemStack.m_150930_(switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case ICInterfaceType.NC -> (Item)CoreItems.PLATE_ITEM.get();
                case ICInterfaceType.REDSTONE -> (Item)CoreItems.CONDUCTIVE_PLATE_ITEM.get();
                case ICInterfaceType.BUNDLED -> (Item)CoreItems.BUNDLED_PLATE_ITEM.get();
            });
            if (match) continue;
            this.problematicSlotMask |= 1 << slotMap[r];
        }
        for (int slot : cornerSlots = new int[]{0, 2, 6, 8}) {
            if (this.inventory.m_8020_(slot).m_150930_((Item)CoreItems.PLATE_ITEM.get())) continue;
            this.problematicSlotMask |= 1 << slot;
        }
        return this.problematicSlotMask == 0;
    }

    @Override
    protected int startWork() {
        return 400;
    }

    @Override
    protected int tickWork(int remainingWork) {
        if (this.canConductorWork()) {
            this.conductor.applyPower(-100.0);
            return 1;
        }
        return 0;
    }

    @Override
    protected void finishWork() {
        ItemStack gatePart = ValidDieItem.createGatePart(this.inventory.m_8020_(4));
        this.inventory.m_6836_(9, gatePart);
        for (int i = 0; i < 9; ++i) {
            this.inventory.m_7407_(i, 1);
        }
    }

    public int getProblematicSlotMask() {
        return this.problematicSlotMask;
    }
}

