/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.colour.EnumColour;
import java.util.ArrayList;
import java.util.function.BiFunction;
import mrtjp.projectred.illumination.ProjectRedIllumination;
import mrtjp.projectred.illumination.block.IllumarLampBlock;
import mrtjp.projectred.illumination.tile.IllumarLampTile;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public enum BlockLightType {
    ILLUMAR_LAMP("illumar_lamp", "Illumar Lamp", IllumarLampBlock::new, IllumarLampTile::new);

    private final String unlocalName;
    private final String localName;
    private final BiFunction<Integer, Boolean, Block> blockFactory;
    private final BlockLightBlockEntityFactory tileFactory;
    private final ArrayList<RegistryObject<Block>> blockSupplier = new ArrayList();
    private final ArrayList<RegistryObject<Block>> invertedBlockSupplier = new ArrayList();
    private final ArrayList<RegistryObject<Item>> itemBlockSupplier = new ArrayList();
    private final ArrayList<RegistryObject<Item>> invertedItemBlockSupplier = new ArrayList();
    private final ArrayList<RegistryObject<BlockEntityType<?>>> tileEntityTypeSupplier = new ArrayList();
    private final ArrayList<RegistryObject<BlockEntityType<?>>> invertedTileEntityTypeSupplier = new ArrayList();

    private BlockLightType(String unlocalName, String localName, BiFunction<Integer, Boolean, Block> blockFactory, BlockLightBlockEntityFactory tileFactory) {
        this.unlocalName = unlocalName;
        this.localName = localName;
        this.blockFactory = blockFactory;
        this.tileFactory = tileFactory;
    }

    public void registerBlocks(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry, DeferredRegister<BlockEntityType<?>> tileRegistry) {
        int colorFinal;
        int color;
        for (color = 0; color < 16; ++color) {
            colorFinal = color;
            String registryID = this.getRegistryID(color, false);
            this.blockSupplier.add(color, (RegistryObject<Block>)blockRegistry.register(registryID, () -> this.blockFactory.apply(colorFinal, false)));
            this.itemBlockSupplier.add(color, (RegistryObject<Item>)itemRegistry.register(registryID, () -> new BlockItem(this.getBlock(colorFinal, false), new Item.Properties().m_41491_((CreativeModeTab)ProjectRedIllumination.ILLUMINATION_GROUP))));
            this.tileEntityTypeSupplier.add(color, tileRegistry.register(registryID, () -> BlockEntityType.Builder.m_155273_((pos, state) -> this.tileFactory.create(colorFinal, false, pos, state), (Block[])new Block[]{this.getBlock(colorFinal, false)}).m_58966_(null)));
        }
        for (color = 0; color < 16; ++color) {
            colorFinal = color;
            String invertedRegistryID = this.getRegistryID(color, true);
            this.invertedBlockSupplier.add(color, (RegistryObject<Block>)blockRegistry.register(invertedRegistryID, () -> this.blockFactory.apply(colorFinal, true)));
            this.invertedItemBlockSupplier.add(color, (RegistryObject<Item>)itemRegistry.register(invertedRegistryID, () -> new BlockItem(this.getBlock(colorFinal, true), new Item.Properties().m_41491_((CreativeModeTab)ProjectRedIllumination.ILLUMINATION_GROUP))));
            this.invertedTileEntityTypeSupplier.add(color, tileRegistry.register(invertedRegistryID, () -> BlockEntityType.Builder.m_155273_((pos, state) -> this.tileFactory.create(colorFinal, true, pos, state), (Block[])new Block[]{this.getBlock(colorFinal, true)}).m_58966_(null)));
        }
    }

    public Block getBlock(int color, boolean inverted) {
        return inverted ? (Block)this.invertedBlockSupplier.get(color).get() : (Block)this.blockSupplier.get(color).get();
    }

    public BlockEntityType<?> getTileEntityType(int color, boolean inverted) {
        return inverted ? (BlockEntityType)this.invertedTileEntityTypeSupplier.get(color).get() : (BlockEntityType)this.tileEntityTypeSupplier.get(color).get();
    }

    public String getLocalBaseName() {
        return this.localName;
    }

    public String getRegistryID(int color, boolean inverted) {
        return EnumColour.values()[color].m_7912_().toLowerCase() + (inverted ? "_inverted" : "") + "_" + this.unlocalName;
    }

    @FunctionalInterface
    private static interface BlockLightBlockEntityFactory {
        public BlockEntity create(int var1, boolean var2, BlockPos var3, BlockState var4);
    }
}

