/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.gui.SimpleCreativeTab;
import codechicken.multipart.api.MultipartType;
import mrtjp.projectred.illumination.BlockLightType;
import mrtjp.projectred.illumination.data.IlluminationBlockLootProvider;
import mrtjp.projectred.illumination.data.IlluminationBlockStateModelProvider;
import mrtjp.projectred.illumination.data.IlluminationItemModelProvider;
import mrtjp.projectred.illumination.data.IlluminationLanguageProvider;
import mrtjp.projectred.illumination.data.IlluminationRecipeProvider;
import mrtjp.projectred.illumination.init.IlluminationBlocks;
import mrtjp.projectred.illumination.init.IlluminationClientInit;
import mrtjp.projectred.illumination.init.IlluminationMicroMaterials;
import mrtjp.projectred.illumination.init.IlluminationParts;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="projectred_illumination")
public class ProjectRedIllumination {
    public static final String MOD_ID = "projectred_illumination";
    public static final Logger LOGGER = LogManager.getLogger((String)"projectred_illumination");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"projectred_illumination");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"projectred_illumination");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"projectred_illumination");
    public static final DeferredRegister<MultipartType<?>> PART_TYPES = DeferredRegister.create((ResourceLocation)MultipartType.MULTIPART_TYPES, (String)"projectred_illumination");
    public static final SimpleCreativeTab ILLUMINATION_GROUP = new SimpleCreativeTab("projectred_illumination", () -> new ItemStack((ItemLike)BlockLightType.ILLUMAR_LAMP.getBlock(EnumColour.RED.ordinal(), true)));

    public ProjectRedIllumination() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> IlluminationClientInit::init);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        PART_TYPES.register(modEventBus);
        modEventBus.register((Object)new IlluminationMicroMaterials());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.m_236039_(event.includeClient(), (DataProvider)new IlluminationBlockStateModelProvider(generator, fileHelper));
        generator.m_236039_(event.includeClient(), (DataProvider)new IlluminationItemModelProvider(generator, fileHelper));
        generator.m_236039_(event.includeClient(), (DataProvider)new IlluminationLanguageProvider(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new IlluminationBlockLootProvider(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new IlluminationRecipeProvider(generator));
    }

    static {
        IlluminationBlocks.register();
        IlluminationParts.register();
        IlluminationMicroMaterials.register();
    }
}

