/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.data;

import javax.annotation.Nonnull;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.illumination.BlockLightType;
import mrtjp.projectred.illumination.block.IllumarLampBlock;
import mrtjp.projectred.illumination.block.IllumarSmartLampBlock;
import mrtjp.projectred.illumination.init.IlluminationBlocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class IlluminationBlockStateModelProvider
extends BlockStateProvider {
    private static final int[][] DEVICE_SIDED_ROTATIONS = new int[][]{{0, 0}, {2, 2}, {1, 2}, {1, 0}, {1, 1}, {1, 3}};

    public IlluminationBlockStateModelProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "projectred_illumination", exFileHelper);
    }

    @Nonnull
    public String m_6055_() {
        return "ProjectRed-Illumination Block Models";
    }

    protected void registerStatesAndModels() {
        for (BlockLightType lampType : BlockLightType.values()) {
            for (int color = 0; color < 16; ++color) {
                this.addIllumarLampVariants(lampType.getBlock(color, true));
                this.addIllumarLampVariants(lampType.getBlock(color, false));
            }
        }
        this.addSidedBlockVariants((Block)IlluminationBlocks.ILLUMAR_SMART_LAMP.get(), (ModelFile)this.createSmartLampModel((Block)IlluminationBlocks.ILLUMAR_SMART_LAMP.get(), false), (ModelFile)this.createSmartLampModel((Block)IlluminationBlocks.ILLUMAR_SMART_LAMP.get(), true));
    }

    private void addIllumarLampVariants(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.createLampModel(block, (Boolean)state.m_61143_((Property)IllumarLampBlock.LIT))).build());
    }

    private BlockModelBuilder createLampModel(Block block, boolean lit) {
        String textureName = BlockLightType.ILLUMAR_LAMP.getRegistryID(((IllumarLampBlock)block).getColor(), false) + (lit ? "_on" : "");
        return (BlockModelBuilder)this.models().cubeAll(textureName, this.modLoc("block/" + textureName));
    }

    private void addSidedBlockVariants(Block block, ModelFile offModel, ModelFile onModel) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int s = (Integer)state.m_61143_((Property)ProjectRedBlock.SIDE);
            boolean lit = (Integer)state.m_61143_((Property)IllumarSmartLampBlock.LEVEL) > 0;
            return ConfiguredModel.builder().modelFile(lit ? onModel : offModel).rotationX(DEVICE_SIDED_ROTATIONS[s][0] * 90).rotationY(DEVICE_SIDED_ROTATIONS[s][1] * 90).build();
        });
    }

    private BlockModelBuilder createSmartLampModel(Block block, boolean lit) {
        String texture = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        String litKey = lit ? "_on" : "";
        String modelName = texture + litKey;
        return (BlockModelBuilder)this.models().cubeBottomTop(modelName, this.modLoc("block/" + texture + "_side" + litKey), this.modLoc("block/" + texture + "_bottom"), this.modLoc("block/" + texture + "_top" + litKey));
    }
}

