/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.part;

import codechicken.lib.render.CCModel;
import codechicken.lib.texture.AtlasRegistrar;
import codechicken.lib.vec.Cuboid6;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import mrtjp.projectred.illumination.MultipartLightProperties;
import mrtjp.projectred.illumination.MultipartLightType;
import mrtjp.projectred.illumination.part.MultipartLightFacePart;
import mrtjp.projectred.illumination.part.MultipartLightPart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CageLightProperties
extends MultipartLightProperties {
    private static final Cuboid6[] BOUNDS = CageLightProperties.sidedBoxes(new Cuboid6(0.21875, 0.0, 0.21875, 0.78125, 0.75, 0.78125));
    private static final Cuboid6[] GLOW_BOUNDS = CageLightProperties.sidedBoxes(new Cuboid6(0.28125, 0.09375, 0.28125, 0.71875, 0.71875, 0.71875));
    private static final VoxelShape[] SHAPES = CageLightProperties.boxesToShapes(BOUNDS);
    @Nullable
    private TextureAtlasSprite icon;

    @Override
    public VoxelShape getShape(int side) {
        return SHAPES[side];
    }

    @Override
    public ItemStack makeStack(int color, boolean inverted) {
        return MultipartLightType.CAGE.makeStack(color, inverted);
    }

    @Override
    public MultipartLightPart partFactory(int color, boolean inverted) {
        return new MultipartLightFacePart(MultipartLightType.CAGE.getPartType(color, inverted), this, color, inverted);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerIcons(AtlasRegistrar registrar) {
        registrar.registerSprite(new ResourceLocation("projectred_illumination", "block/cage_lamp"), i -> {
            this.icon = i;
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getIcon(int color) {
        return Objects.requireNonNull(this.icon);
    }

    @Override
    public Cuboid6 getGlowBounds(int side) {
        return GLOW_BOUNDS[side];
    }

    @Override
    public CCModel getBulbModel(int side) {
        return CageLightModels.BULB_MODELS[side];
    }

    @Override
    public CCModel getChasisModel(int side) {
        return CageLightModels.CHASSIS_MODELS[side];
    }

    private static class CageLightModels {
        private static final CCModel[] BULB_MODELS = new CCModel[6];
        private static final CCModel[] CHASSIS_MODELS = new CCModel[6];

        private CageLightModels() {
        }

        static {
            Map<String, CCModel> models = MultipartLightProperties.parseCorrectedModel("cagelamp");
            CCModel chassis = models.get("chassi");
            CCModel bulb = models.get("bulb");
            for (int s = 0; s < 6; ++s) {
                CageLightModels.BULB_MODELS[s] = MultipartLightProperties.bakeCopy(s, bulb);
                CageLightModels.CHASSIS_MODELS[s] = MultipartLightProperties.bakeCopy(s, chassis);
            }
        }
    }
}

