/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.part;

import codechicken.lib.render.CCModel;
import codechicken.lib.texture.AtlasRegistrar;
import codechicken.lib.vec.Cuboid6;
import java.util.Map;
import javax.annotation.Nullable;
import mrtjp.projectred.illumination.MultipartLightProperties;
import mrtjp.projectred.illumination.MultipartLightType;
import mrtjp.projectred.illumination.part.MultipartLightFacePart;
import mrtjp.projectred.illumination.part.MultipartLightPart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FalloutLightProperties
extends MultipartLightProperties {
    private static final Cuboid6[] BOUNDS = FalloutLightProperties.sidedBoxes(new Cuboid6(0.125, 0.0, 0.125, 0.875, 0.6875, 0.875));
    private static final Cuboid6[] GLOW_BOUNDS = FalloutLightProperties.sidedBoxes(new Cuboid6(0.25, 0.09375, 0.25, 0.75, 0.625, 0.75).expand(-0.002));
    private static final VoxelShape[] SHAPES = FalloutLightProperties.boxesToShapes(BOUNDS);
    @Nullable
    private TextureAtlasSprite icon;

    @Override
    public VoxelShape getShape(int side) {
        return SHAPES[side];
    }

    @Override
    public ItemStack makeStack(int color, boolean inverted) {
        return MultipartLightType.FALLOUT.makeStack(color, inverted);
    }

    @Override
    public MultipartLightPart partFactory(int color, boolean inverted) {
        return new MultipartLightFacePart(MultipartLightType.FALLOUT.getPartType(color, inverted), this, color, inverted);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerIcons(AtlasRegistrar registrar) {
        registrar.registerSprite(new ResourceLocation("projectred_illumination", "block/fallout"), i -> {
            this.icon = i;
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getIcon(int color) {
        assert (this.icon != null);
        return this.icon;
    }

    @Override
    public Cuboid6 getGlowBounds(int side) {
        return GLOW_BOUNDS[side];
    }

    @Override
    public CCModel getBulbModel(int side) {
        return FalloutLightModels.BULB_MODELS[side];
    }

    @Override
    public CCModel getChasisModel(int side) {
        return FalloutLightModels.CHASSIS_MODELS[side];
    }

    private static class FalloutLightModels {
        private static final CCModel[] BULB_MODELS = new CCModel[6];
        private static final CCModel[] CHASSIS_MODELS = new CCModel[6];

        private FalloutLightModels() {
        }

        static {
            Map<String, CCModel> models = MultipartLightProperties.parseCorrectedModel("fallout");
            CCModel chassis = models.get("chassi");
            CCModel bulb = models.get("bulb");
            for (int s = 0; s < 6; ++s) {
                FalloutLightModels.BULB_MODELS[s] = MultipartLightProperties.bakeCopy(s, bulb);
                FalloutLightModels.CHASSIS_MODELS[s] = MultipartLightProperties.bakeCopy(s, chassis);
            }
        }
    }
}

