/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.tag;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.supermartijn642.core.data.tag.CustomTagEntry;
import com.supermartijn642.core.data.tag.CustomTagEntrySerializer;
import com.supermartijn642.core.data.tag.TagEntryAdapter;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;

public class CustomTagEntries {
    public static void init() {
        TagEntry.f_215911_ = Codec.either((Codec)Codec.of((Encoder)new Encoder<TagEntry>(){

            public <T> DataResult<T> encode(TagEntry input, DynamicOps<T> ops, T prefix) {
                if (!(input instanceof TagEntryAdapter)) {
                    return DataResult.error((String)"Tag entry is not a custom entry!");
                }
                JsonObject json = new JsonObject();
                CustomTagEntrySerializer<?> serializer = ((TagEntryAdapter)input).customEntry.getSerializer();
                json.addProperty("type", Registries.CUSTOM_TAG_ENTRY_SERIALIZERS.getIdentifier(serializer).toString());
                try {
                    serializer.serialize(json, ((TagEntryAdapter)input).customEntry);
                }
                catch (Exception e) {
                    throw new RuntimeException("Encountered an exception whilst serializing custom tag entry for type '" + Registries.CUSTOM_TAG_ENTRY_SERIALIZERS.getIdentifier(serializer).toString() + "'!");
                }
                return DataResult.success((Object)json);
            }
        }, (Decoder)new Decoder<TagEntry>(){

            public <T> DataResult<Pair<TagEntry, T>> decode(DynamicOps<T> ops, T input) {
                Object customEntry;
                if (!(input instanceof JsonObject)) {
                    return DataResult.error((String)"Entry must be an object!");
                }
                JsonObject json = (JsonObject)input;
                if (!(json.has("type") && json.get("type").isJsonPrimitive() && json.getAsJsonPrimitive("type").isString())) {
                    return DataResult.error((String)"Missing string key 'type'!");
                }
                String typeString = json.get("type").getAsString();
                if (!RegistryUtil.isValidIdentifier(typeString)) {
                    return DataResult.error((String)("Invalid identifier '" + typeString + "'!"));
                }
                ResourceLocation type = new ResourceLocation(typeString);
                if (!Registries.CUSTOM_TAG_ENTRY_SERIALIZERS.hasIdentifier(type)) {
                    return DataResult.error((String)("Unknown custom tag entry serializer '" + typeString + "'!"));
                }
                CustomTagEntrySerializer<?> serializer = Registries.CUSTOM_TAG_ENTRY_SERIALIZERS.getValue(type);
                try {
                    customEntry = serializer.deserialize(json);
                }
                catch (JsonParseException e) {
                    return DataResult.error((String)e.getMessage());
                }
                catch (Exception e) {
                    throw new RuntimeException("Encountered an exception whilst deserializing custom tag entry for type '" + type + "'!", e);
                }
                return DataResult.success((Object)Pair.of((Object)((Object)new TagEntryAdapter(type, (CustomTagEntry)customEntry)), input));
            }
        }), (Codec)TagEntry.f_215911_).xmap(either -> (TagEntry)either.map(Function.identity(), Function.identity()), tagEntry -> tagEntry instanceof TagEntryAdapter ? Either.left((Object)tagEntry) : Either.right((Object)tagEntry));
    }

    static TagEntry wrap(CustomTagEntry customEntry) {
        return new TagEntryAdapter(Registries.CUSTOM_TAG_ENTRY_SERIALIZERS.getIdentifier(customEntry.getSerializer()), customEntry);
    }
}

