/*
 * Decompiled with CFR 0.152.
 */
package pyre.tinkerslevellingaddon.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import pyre.tinkerslevellingaddon.ImprovableModifier;
import pyre.tinkerslevellingaddon.command.ModCommands;
import pyre.tinkerslevellingaddon.config.Config;
import pyre.tinkerslevellingaddon.setup.Registration;
import pyre.tinkerslevellingaddon.util.ModUtil;
import pyre.tinkerslevellingaddon.util.ToolLevellingUtil;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.command.HeldModifiableItemIterator;

public class LevelsCommand {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").executes(context -> LevelsCommand.run((CommandContext<CommandSourceStack>)context, ModCommands.Operation.ADD, 1))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> LevelsCommand.run((CommandContext<CommandSourceStack>)context, ModCommands.Operation.ADD))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LevelsCommand.run((CommandContext<CommandSourceStack>)context, ModCommands.Operation.SET)))));
    }

    private static int run(CommandContext<CommandSourceStack> context, ModCommands.Operation op) throws CommandSyntaxException {
        return LevelsCommand.run(context, op, IntegerArgumentType.getInteger(context, (String)"count"));
    }

    private static int run(CommandContext<CommandSourceStack> context, ModCommands.Operation op, int count) throws CommandSyntaxException {
        if (count > (Integer)Config.maxLevel.get() && op == ModCommands.Operation.SET) {
            throw new SimpleCommandExceptionType((Message)ModUtil.makeTranslation("command", "levels.failure.set.invalid_count", Config.maxLevel.get())).create();
        }
        List successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            Component error;
            if (ModifierUtil.getModifierLevel((ItemStack)stack, (ModifierId)((ImprovableModifier)Registration.IMPROVABLE.get()).getId()) <= 0) {
                return false;
            }
            ToolStack tool = ToolStack.copyFrom((ItemStack)stack);
            if (op == ModCommands.Operation.ADD) {
                int levelsAdded = LevelsCommand.addLevel(tool, count, living);
                if (levelsAdded == 0) {
                    throw new SimpleCommandExceptionType((Message)ModUtil.makeTranslation("command", "levels.failure.add.already_max_level", stack.m_41611_())).create();
                }
            } else if (!LevelsCommand.setLevel(tool, count)) {
                throw new SimpleCommandExceptionType((Message)ModUtil.makeTranslation("command", "levels.failure.set.current_level", stack.m_41611_(), count)).create();
            }
            if ((error = tool.tryValidate()) != null) {
                throw ModCommands.TOOL_VALIDATION_ERROR.create((Object)error);
            }
            living.m_21008_(InteractionHand.MAIN_HAND, tool.createStack(stack.m_41613_()));
            return true;
        });
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int size = successes.size();
        if (op == ModCommands.Operation.ADD) {
            if (size == 1) {
                source.m_81354_((Component)ModUtil.makeTranslation("command", "levels.success.add.single", count, ((LivingEntity)successes.get(0)).m_5446_()), true);
            } else {
                source.m_81354_((Component)ModUtil.makeTranslation("command", "levels.success.add.multiple", count, size), true);
            }
        } else if (size == 1) {
            source.m_81354_((Component)ModUtil.makeTranslation("command", "levels.success.set.single", count, ((LivingEntity)successes.get(0)).m_5446_()), true);
        } else {
            source.m_81354_((Component)ModUtil.makeTranslation("command", "levels.success.set.multiple", count, size), true);
        }
        return size;
    }

    private static int addLevel(ToolStack tool, int count, LivingEntity living) {
        int levelsAdded;
        ServerPlayer p;
        int currentLevel = tool.getPersistentData().getInt(ImprovableModifier.LEVEL_KEY);
        boolean isBroad = ToolLevellingUtil.isBroadTool((IToolStackView)tool);
        ServerPlayer player = living instanceof ServerPlayer ? (p = (ServerPlayer)living) : null;
        for (levelsAdded = 0; levelsAdded < count && ToolLevellingUtil.canLevelUp(currentLevel); ++levelsAdded) {
            int xp = ToolLevellingUtil.getXpNeededForLevel(currentLevel + 1, isBroad);
            ToolLevellingUtil.addExperience(tool, xp, player);
            ++currentLevel;
        }
        return levelsAdded;
    }

    private static boolean setLevel(ToolStack tool, int count) {
        ModDataNBT data = tool.getPersistentData();
        int currentLevel = data.getInt(ImprovableModifier.LEVEL_KEY);
        int levelDiff = count - currentLevel;
        if (levelDiff == 0) {
            return false;
        }
        if (levelDiff > 0) {
            LevelsCommand.addLevel(tool, levelDiff, null);
        } else {
            data.putInt(ImprovableModifier.LEVEL_KEY, count);
            LevelsCommand.trimHistory(ImprovableModifier.SLOT_HISTORY_KEY, data, count);
            LevelsCommand.trimHistory(ImprovableModifier.STAT_HISTORY_KEY, data, count);
        }
        tool.rebuildStats();
        return true;
    }

    private static void trimHistory(ResourceLocation historyKey, ModDataNBT data, int size) {
        Object newHistory = Arrays.stream(data.getString(historyKey).split(";")).limit(size).collect(Collectors.joining(";"));
        if (!((String)newHistory).isBlank()) {
            newHistory = (String)newHistory + ";";
        }
        data.putString(historyKey, (String)newHistory);
    }
}

