/*
 * Decompiled with CFR 0.152.
 */
package pyre.tinkerslevellingaddon.setup;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import pyre.tinkerslevellingaddon.ImprovableModifier;
import pyre.tinkerslevellingaddon.config.Config;
import pyre.tinkerslevellingaddon.setup.Registration;
import pyre.tinkerslevellingaddon.util.ModUtil;
import pyre.tinkerslevellingaddon.util.ToolLevellingUtil;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

@Mod.EventBusSubscriber(modid="tinkerslevellingaddon", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TooltipEventHandler {
    private static final Component TOOLTIP_HOLD_ALT = ModUtil.makeTranslation("tooltip", "hold_alt", ModUtil.makeTranslation("key", "alt", ImprovableModifier.IMPROVABLE_MODIFIER_COLOR).m_130938_(s -> s.m_131155_(Boolean.valueOf(true))));
    private static final Component TOOLTIP_MODIFIERS_GAINED = ModUtil.makeTranslation("tooltip", "info.slots", ImprovableModifier.IMPROVABLE_MODIFIER_COLOR).m_130938_(s -> s.m_131162_(Boolean.valueOf(true)));
    private static final Component TOOLTIP_STATS_GAINED = ModUtil.makeTranslation("tooltip", "info.stats", ImprovableModifier.IMPROVABLE_MODIFIER_COLOR).m_130938_(s -> s.m_131162_(Boolean.valueOf(true)));
    private static final Component TOOLTIP_NEXT_LEVEL = ModUtil.makeTranslation("tooltip", "info.next_level", ImprovableModifier.IMPROVABLE_MODIFIER_COLOR).m_130938_(s -> s.m_131162_(Boolean.valueOf(true)));

    @SubscribeEvent
    static void onTooltipEvent(ItemTooltipEvent event) {
        KeyModifier activeModifierKey = KeyModifier.getActiveModifier();
        if (event.getEntity() == null || activeModifierKey == KeyModifier.CONTROL || activeModifierKey == KeyModifier.SHIFT) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (ModifierUtil.getModifierLevel((ItemStack)stack, (ModifierId)((ImprovableModifier)Registration.IMPROVABLE.get()).getId()) <= 0) {
            return;
        }
        for (int i = event.getToolTip().size() - 1; i >= 0; --i) {
            if (event.getToolTip().get(i) != TooltipUtil.TOOLTIP_HOLD_SHIFT && event.getToolTip().get(i) != TooltipUtil.TOOLTIP_HOLD_CTRL) continue;
            event.getToolTip().add(i + 1, TOOLTIP_HOLD_ALT);
            break;
        }
        List<Object> infoEntries = new ArrayList<Component>();
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (activeModifierKey == KeyModifier.ALT) {
            infoEntries.add((Component)event.getToolTip().get(0));
            infoEntries.addAll(TooltipEventHandler.prepareLevelInfo(tool));
            event.getToolTip().clear();
            event.getToolTip().addAll(infoEntries);
        } else {
            infoEntries = TooltipEventHandler.prepareGeneralInfo(tool);
            for (int i = 2; i < infoEntries.size() + 2; ++i) {
                event.getToolTip().add(i, (Component)infoEntries.get(i - 2));
            }
        }
    }

    private static List<Component> prepareGeneralInfo(ToolStack tool) {
        ArrayList<Component> infoEntries = new ArrayList<Component>();
        int level = tool.getPersistentData().getInt(ImprovableModifier.LEVEL_KEY);
        MutableComponent fullLevelName = ModUtil.makeTranslation("tooltip", "level.name", ChatFormatting.GRAY, new Object[]{TooltipEventHandler.getLevelName(level), ModUtil.makeText((Number)level, ChatFormatting.GRAY)});
        infoEntries.add((Component)ModUtil.makeTranslation("tooltip", "level", fullLevelName));
        if (ToolLevellingUtil.canLevelUp(level)) {
            MutableComponent xp = ModUtil.makeText((Number)tool.getPersistentData().getInt(ImprovableModifier.EXPERIENCE_KEY), ChatFormatting.GOLD);
            MutableComponent xpNeeded = ModUtil.makeText((Number)ToolLevellingUtil.getXpNeededForLevel(level + 1, ToolLevellingUtil.isBroadTool((IToolStackView)tool)), ChatFormatting.GOLD);
            MutableComponent xpValue = ModUtil.makeTranslation("tooltip", "xp.value", ChatFormatting.GRAY, new Object[]{xp, xpNeeded});
            infoEntries.add((Component)ModUtil.makeTranslation("tooltip", "xp", xpValue));
        }
        return infoEntries;
    }

    private static List<Component> prepareLevelInfo(ToolStack tool) {
        String statHistory;
        ArrayList<Component> infoEntries = new ArrayList<Component>();
        String modifierHistory = tool.getPersistentData().getString(ImprovableModifier.SLOT_HISTORY_KEY);
        if (!modifierHistory.isBlank()) {
            Map gainedModifiers = Arrays.stream(modifierHistory.split(";")).sorted(Comparator.reverseOrder()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            infoEntries.add(TOOLTIP_MODIFIERS_GAINED);
            for (Map.Entry entry : gainedModifiers.entrySet()) {
                MutableComponent value = ModUtil.makeText((Number)entry.getValue(), ToolLevellingUtil.getSlotColor((String)entry.getKey()));
                infoEntries.add((Component)ModUtil.makeTranslation("tooltip", "info.slots." + (String)entry.getKey(), value));
            }
        }
        if (!(statHistory = tool.getPersistentData().getString(ImprovableModifier.STAT_HISTORY_KEY)).isBlank()) {
            if (!infoEntries.isEmpty()) {
                infoEntries.add((Component)Component.m_237119_());
            }
            LinkedHashMap<String, Double> gainedStats = new LinkedHashMap<String, Double>();
            Arrays.stream(statHistory.split(";")).sorted().forEach(s -> gainedStats.merge((String)s, ToolLevellingUtil.getStatValue((IToolContext)tool, s), Double::sum));
            gainedStats.computeIfPresent("knockbackResistance", (k, v) -> v * 10.0);
            infoEntries.add(TOOLTIP_STATS_GAINED);
            for (Map.Entry entry : gainedStats.entrySet()) {
                MutableComponent value = ModUtil.makeText(ItemStack.f_41584_.format(entry.getValue()), ToolLevellingUtil.getStatColor((String)entry.getKey()));
                infoEntries.add((Component)ModUtil.makeTranslation("tooltip", "info.stats." + (String)entry.getKey(), value));
            }
        }
        List<Component> nextLevelInfo = TooltipEventHandler.prepareNextLevelInfo(tool);
        if (!infoEntries.isEmpty() && !nextLevelInfo.isEmpty()) {
            infoEntries.add((Component)Component.m_237119_());
        }
        infoEntries.addAll(nextLevelInfo);
        return infoEntries;
    }

    private static List<Component> prepareNextLevelInfo(ToolStack tool) {
        ArrayList<Component> infoEntries = new ArrayList<Component>();
        int level = tool.getPersistentData().getInt(ImprovableModifier.LEVEL_KEY);
        boolean canLevelUp = ToolLevellingUtil.canLevelUp(level);
        boolean knowNextSlot = ToolLevellingUtil.canPredictNextSlot(tool);
        boolean knowNextStat = ToolLevellingUtil.canPredictNextStat(tool);
        if (canLevelUp && (knowNextSlot || knowNextStat)) {
            infoEntries.add(TOOLTIP_NEXT_LEVEL);
            if (knowNextSlot) {
                String nextSlot = ToolLevellingUtil.getSlot(tool, level + 1);
                MutableComponent slot = ModUtil.makeTranslation("tooltip", "slot." + nextSlot, ToolLevellingUtil.getSlotColor(nextSlot));
                infoEntries.add((Component)ModUtil.makeTranslation("tooltip", "info.next_level.slot", slot));
            }
            if (knowNextStat) {
                String nextStat = ToolLevellingUtil.getStat(tool, level + 1);
                double statValue = ToolLevellingUtil.getStatValue((IToolContext)tool, nextStat);
                if (nextStat.equals("knockbackResistance")) {
                    statValue *= 10.0;
                }
                MutableComponent value = ModUtil.makeText(ItemStack.f_41584_.format(statValue), ToolLevellingUtil.getStatColor(nextStat));
                MutableComponent name = ModUtil.makeTranslation("tooltip", "stat." + nextStat);
                infoEntries.add((Component)ModUtil.makeTranslation("tooltip", "info.next_level.stat", value, name));
            }
        }
        return infoEntries;
    }

    private static MutableComponent getLevelName(int level) {
        TextColor levelColor = TooltipEventHandler.getLevelColor(level);
        if (ModUtil.canTranslate("tooltip", "level." + level)) {
            return ModUtil.makeTranslation("tooltip", "level." + level, levelColor);
        }
        int i = 1;
        while (ModUtil.canTranslate("tooltip", "level." + i)) {
            ++i;
        }
        int tier = level / i;
        Object suffix = (Boolean)Config.squashLevelPluses.get() != false && level > 0 ? "+" + tier : "+".repeat(tier);
        return ModUtil.makeTranslation("tooltip", "level." + level % i, levelColor).m_7220_((Component)ModUtil.makeText((String)suffix, levelColor));
    }

    private static TextColor getLevelColor(int level) {
        float hue = 0.277777f * (float)level;
        hue -= (float)((int)hue);
        return TextColor.m_131266_((int)Color.HSBtoRGB(hue, 0.75f, 0.8f));
    }
}

