/*
 * Decompiled with CFR 0.152.
 */
package pyre.tinkerslevellingaddon.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import pyre.tinkerslevellingaddon.ImprovableModifier;
import pyre.tinkerslevellingaddon.config.Config;
import pyre.tinkerslevellingaddon.network.LevelUpPacket;
import pyre.tinkerslevellingaddon.network.Messages;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ToolLevellingUtil {
    public static final String UPGRADE = "upgrade";
    public static final String ABILITY = "ability";
    public static final String SOUL = "soul";
    public static final String DEFENSE = "defense";
    public static final String DURABILITY = "durability";
    public static final String ATTACK_DAMAGE = "attackDamage";
    public static final String ATTACK_SPEED = "attackSpeed";
    public static final String MINING_SPEED = "miningSpeed";
    public static final String ARMOR = "armor";
    public static final String ARMOR_TOUGHNESS = "armorToughness";
    public static final String KNOCKBACK_RESISTANCE = "knockbackResistance";
    public static final String DRAW_SPEED = "drawSpeed";
    public static final String VELOCITY = "velocity";
    public static final String ACCURACY = "accuracy";
    public static final String PROJECTILE_DAMAGE = "projectileDamage";
    private static final Map<String, SlotType> TOOL_SLOT_TYPES;
    private static final Map<String, SlotType> ARMOR_SLOT_TYPES;
    private static final Map<String, SlotType> ALL_SLOT_TYPES;
    private static final Map<String, FloatToolStat> TOOL_STAT_TYPES;
    private static final Map<String, FloatToolStat> RANGED_STAT_TYPES;
    private static final Map<String, FloatToolStat> ARMOR_STAT_TYPES;
    private static final Map<String, FloatToolStat> STAFF_STAT_TYPES;
    private static final Map<String, FloatToolStat> ALL_STAT_TYPES;
    private static final Random RANDOM;

    public static Set<String> getToolSlotTypes() {
        return TOOL_SLOT_TYPES.keySet();
    }

    public static Set<String> getRangedSlotTypes() {
        return TOOL_SLOT_TYPES.keySet();
    }

    public static Set<String> getArmorSlotTypes() {
        return ARMOR_SLOT_TYPES.keySet();
    }

    public static Set<String> getStaffSlotTypes() {
        return TOOL_SLOT_TYPES.keySet();
    }

    public static Set<String> getToolStatTypes() {
        return TOOL_STAT_TYPES.keySet();
    }

    public static Set<String> getRangedStatTypes() {
        return RANGED_STAT_TYPES.keySet();
    }

    public static Set<String> getArmorStatTypes() {
        return ARMOR_STAT_TYPES.keySet();
    }

    public static Set<String> getStaffStatTypes() {
        return STAFF_STAT_TYPES.keySet();
    }

    public static boolean isSlotsLevellingEnabled(IToolContext context) {
        if (ToolLevellingUtil.isStaff(context)) {
            return Config.staffSlotGainingMethod.get() != Config.GainingMethod.NONE;
        }
        if (ToolLevellingUtil.isArmor(context)) {
            return Config.armorSlotGainingMethod.get() != Config.GainingMethod.NONE;
        }
        if (ToolLevellingUtil.isRanged(context)) {
            return Config.rangedSlotGainingMethod.get() != Config.GainingMethod.NONE;
        }
        return Config.toolsSlotGainingMethod.get() != Config.GainingMethod.NONE;
    }

    public static boolean isStatsLevellingEnabled(IToolContext context) {
        if (ToolLevellingUtil.isStaff(context)) {
            return Config.staffStatGainingMethod.get() != Config.GainingMethod.NONE;
        }
        if (ToolLevellingUtil.isArmor(context)) {
            return Config.armorStatGainingMethod.get() != Config.GainingMethod.NONE;
        }
        if (ToolLevellingUtil.isRanged(context)) {
            return Config.rangedStatGainingMethod.get() != Config.GainingMethod.NONE;
        }
        return Config.toolsStatGainingMethod.get() != Config.GainingMethod.NONE;
    }

    public static boolean canPredictNextSlot(ToolStack tool) {
        if (ToolLevellingUtil.isStaff((IToolContext)tool)) {
            return Config.staffSlotGainingMethod.get() == Config.GainingMethod.PREDEFINED_ORDER;
        }
        if (ToolLevellingUtil.isArmor((IToolContext)tool)) {
            return Config.armorSlotGainingMethod.get() == Config.GainingMethod.PREDEFINED_ORDER;
        }
        if (ToolLevellingUtil.isRanged((IToolContext)tool)) {
            return Config.rangedSlotGainingMethod.get() == Config.GainingMethod.PREDEFINED_ORDER;
        }
        return Config.toolsSlotGainingMethod.get() == Config.GainingMethod.PREDEFINED_ORDER;
    }

    public static boolean canPredictNextStat(ToolStack tool) {
        if (ToolLevellingUtil.isStaff((IToolContext)tool)) {
            return Config.staffStatGainingMethod.get() == Config.GainingMethod.PREDEFINED_ORDER;
        }
        if (ToolLevellingUtil.isArmor((IToolContext)tool)) {
            return Config.armorStatGainingMethod.get() == Config.GainingMethod.PREDEFINED_ORDER;
        }
        if (ToolLevellingUtil.isRanged((IToolContext)tool)) {
            return Config.rangedStatGainingMethod.get() == Config.GainingMethod.PREDEFINED_ORDER;
        }
        return Config.toolsStatGainingMethod.get() == Config.GainingMethod.PREDEFINED_ORDER;
    }

    public static String getSlot(ToolStack tool, int level) {
        if (ToolLevellingUtil.isStaff((IToolContext)tool)) {
            return switch ((Config.GainingMethod)((Object)Config.staffSlotGainingMethod.get())) {
                default -> throw new IncompatibleClassChangeError();
                case Config.GainingMethod.NONE -> null;
                case Config.GainingMethod.PREDEFINED_ORDER -> ToolLevellingUtil.getStaffSlotForLevel(level);
                case Config.GainingMethod.RANDOM -> ToolLevellingUtil.getRandomStaffSlot();
            };
        }
        if (ToolLevellingUtil.isArmor((IToolContext)tool)) {
            return switch ((Config.GainingMethod)((Object)Config.armorSlotGainingMethod.get())) {
                default -> throw new IncompatibleClassChangeError();
                case Config.GainingMethod.NONE -> null;
                case Config.GainingMethod.PREDEFINED_ORDER -> ToolLevellingUtil.getArmorSlotForLevel(level);
                case Config.GainingMethod.RANDOM -> ToolLevellingUtil.getRandomArmorSlot();
            };
        }
        if (ToolLevellingUtil.isRanged((IToolContext)tool)) {
            return switch ((Config.GainingMethod)((Object)Config.rangedSlotGainingMethod.get())) {
                default -> throw new IncompatibleClassChangeError();
                case Config.GainingMethod.NONE -> null;
                case Config.GainingMethod.PREDEFINED_ORDER -> ToolLevellingUtil.getRangedSlotForLevel(level);
                case Config.GainingMethod.RANDOM -> ToolLevellingUtil.getRandomRangedSlot();
            };
        }
        return switch ((Config.GainingMethod)((Object)Config.toolsSlotGainingMethod.get())) {
            default -> throw new IncompatibleClassChangeError();
            case Config.GainingMethod.NONE -> null;
            case Config.GainingMethod.PREDEFINED_ORDER -> ToolLevellingUtil.getToolSlotForLevel(level);
            case Config.GainingMethod.RANDOM -> ToolLevellingUtil.getRandomToolSlot();
        };
    }

    public static String getStat(ToolStack tool, int level) {
        if (ToolLevellingUtil.isStaff((IToolContext)tool)) {
            return switch ((Config.GainingMethod)((Object)Config.staffStatGainingMethod.get())) {
                default -> throw new IncompatibleClassChangeError();
                case Config.GainingMethod.NONE -> null;
                case Config.GainingMethod.PREDEFINED_ORDER -> ToolLevellingUtil.getStaffStatForLevel(level);
                case Config.GainingMethod.RANDOM -> ToolLevellingUtil.getRandomStaffStat();
            };
        }
        if (ToolLevellingUtil.isArmor((IToolContext)tool)) {
            return switch ((Config.GainingMethod)((Object)Config.armorStatGainingMethod.get())) {
                default -> throw new IncompatibleClassChangeError();
                case Config.GainingMethod.NONE -> null;
                case Config.GainingMethod.PREDEFINED_ORDER -> ToolLevellingUtil.getArmorStatForLevel(level);
                case Config.GainingMethod.RANDOM -> ToolLevellingUtil.getRandomArmorStat();
            };
        }
        if (ToolLevellingUtil.isRanged((IToolContext)tool)) {
            return switch ((Config.GainingMethod)((Object)Config.rangedStatGainingMethod.get())) {
                default -> throw new IncompatibleClassChangeError();
                case Config.GainingMethod.NONE -> null;
                case Config.GainingMethod.PREDEFINED_ORDER -> ToolLevellingUtil.getRangedStatForLevel(level);
                case Config.GainingMethod.RANDOM -> ToolLevellingUtil.getRandomRangedStat();
            };
        }
        return switch ((Config.GainingMethod)((Object)Config.toolsStatGainingMethod.get())) {
            default -> throw new IncompatibleClassChangeError();
            case Config.GainingMethod.NONE -> null;
            case Config.GainingMethod.PREDEFINED_ORDER -> ToolLevellingUtil.getToolStatForLevel(level);
            case Config.GainingMethod.RANDOM -> ToolLevellingUtil.getRandomToolStat();
        };
    }

    public static double getStatValue(IToolContext tool, String stat) {
        return ToolLevellingUtil.getStatValue(tool, ALL_STAT_TYPES.get(stat));
    }

    public static double getStatValue(IToolContext tool, FloatToolStat stat) {
        if (ToolLevellingUtil.isStaff(tool)) {
            return Config.getStaffStatValue(stat);
        }
        if (ToolLevellingUtil.isArmor(tool)) {
            return Config.getArmorStatValue(stat);
        }
        if (ToolLevellingUtil.isRanged(tool)) {
            return Config.getRangedStatValue(stat);
        }
        return Config.getToolStatValue(stat);
    }

    public static List<SlotType> parseSlotsHistory(String historyString) {
        ArrayList<SlotType> result = new ArrayList<SlotType>();
        if (!historyString.isBlank()) {
            for (String statString : historyString.split(";")) {
                SlotType stat = ALL_SLOT_TYPES.get(statString);
                if (stat == null) {
                    throw new UnsupportedOperationException("Unsupported slot type " + statString);
                }
                result.add(stat);
            }
        }
        return result;
    }

    public static List<FloatToolStat> parseStatsHistory(String historyString) {
        ArrayList<FloatToolStat> result = new ArrayList<FloatToolStat>();
        if (!historyString.isBlank()) {
            for (String statString : historyString.split(";")) {
                FloatToolStat stat = ALL_STAT_TYPES.get(statString);
                if (stat == null) {
                    throw new UnsupportedOperationException("Unsupported stat type " + statString);
                }
                result.add(stat);
            }
        }
        return result;
    }

    public static boolean canLevelUp(int level) {
        return (Integer)Config.maxLevel.get() == 0 || (Integer)Config.maxLevel.get() > level;
    }

    public static int getXpNeededForLevel(int level, boolean isBroadTool) {
        int experienceNeeded = (Integer)Config.baseExperience.get();
        if (level > 1) {
            experienceNeeded = (int)((double)ToolLevellingUtil.getXpNeededForLevel(level - 1, false) * (Double)Config.requiredXpMultiplier.get());
        }
        if (isBroadTool) {
            experienceNeeded = (int)((double)experienceNeeded * (Double)Config.broadToolRequiredXpMultiplier.get());
        }
        return experienceNeeded;
    }

    public static void addExperience(ToolStack tool, int amount, ServerPlayer player) {
        if (tool == null) {
            return;
        }
        ModDataNBT data = tool.getPersistentData();
        int currentLevel = data.getInt(ImprovableModifier.LEVEL_KEY);
        int currentExperience = data.getInt(ImprovableModifier.EXPERIENCE_KEY) + amount;
        boolean isBroadTool = ToolLevellingUtil.isBroadTool((IToolStackView)tool);
        int experienceNeeded = ToolLevellingUtil.getXpNeededForLevel(currentLevel + 1, isBroadTool);
        while (currentExperience >= experienceNeeded) {
            String statName;
            if (!ToolLevellingUtil.canLevelUp(currentLevel)) {
                return;
            }
            data.putInt(ImprovableModifier.LEVEL_KEY, ++currentLevel);
            currentExperience -= experienceNeeded;
            experienceNeeded = ToolLevellingUtil.getXpNeededForLevel(currentLevel + 1, isBroadTool);
            String slotName = ToolLevellingUtil.getSlot(tool, currentLevel);
            if (slotName != null) {
                ToolLevellingUtil.appendHistory(ImprovableModifier.SLOT_HISTORY_KEY, slotName, data);
            }
            if ((statName = ToolLevellingUtil.getStat(tool, currentLevel)) != null) {
                ToolLevellingUtil.appendHistory(ImprovableModifier.STAT_HISTORY_KEY, statName, data);
            }
            data.putInt(ImprovableModifier.EXPERIENCE_KEY, 0);
            tool.rebuildStats();
            if (player == null) continue;
            Component toolName = tool.createStack().m_41611_();
            Messages.sendToPlayer(new LevelUpPacket(currentLevel, toolName), player);
        }
        data.putInt(ImprovableModifier.EXPERIENCE_KEY, currentExperience);
    }

    public static boolean isStaff(IToolContext tool) {
        return tool.hasTag(TinkerTags.Items.STAFFS);
    }

    public static boolean isArmor(IToolContext tool) {
        return tool.hasTag(TinkerTags.Items.ARMOR);
    }

    public static boolean isRanged(IToolContext tool) {
        return tool.hasTag(TinkerTags.Items.RANGED);
    }

    public static boolean isBroadTool(IToolStackView tool) {
        return tool.getMaterials().size() > 3 || ToolLevellingUtil.isStaff((IToolContext)tool);
    }

    public static TextColor getSlotColor(String slotName) {
        return ALL_SLOT_TYPES.get(slotName).getColor();
    }

    public static TextColor getStatColor(String statName) {
        return ALL_STAT_TYPES.get(statName).getColor();
    }

    private static String getToolSlotForLevel(int level) {
        List<String> toolsSlotsOrder = Config.getToolsSlotsOrder();
        return toolsSlotsOrder.get((level - 1) % toolsSlotsOrder.size());
    }

    private static String getRandomToolSlot() {
        List<String> toolsSlotsRandomPool = Config.getToolsSlotsRandomPool();
        return toolsSlotsRandomPool.get(RANDOM.nextInt(toolsSlotsRandomPool.size()));
    }

    private static String getRangedSlotForLevel(int level) {
        List<String> rangedSlotsOrder = Config.getRangedSlotsOrder();
        return rangedSlotsOrder.get((level - 1) % rangedSlotsOrder.size());
    }

    private static String getRandomRangedSlot() {
        List<String> rangedSlotsRandomPool = Config.getRangedSlotsRandomPool();
        return rangedSlotsRandomPool.get(RANDOM.nextInt(rangedSlotsRandomPool.size()));
    }

    private static String getArmorSlotForLevel(int level) {
        List<String> armorSlotsOrder = Config.getArmorSlotsOrder();
        return armorSlotsOrder.get((level - 1) % armorSlotsOrder.size());
    }

    private static String getRandomArmorSlot() {
        List<String> armorSlotsRandomPool = Config.getArmorSlotsRandomPool();
        return armorSlotsRandomPool.get(RANDOM.nextInt(armorSlotsRandomPool.size()));
    }

    private static String getStaffSlotForLevel(int level) {
        List<String> staffSlotsOrder = Config.getStaffSlotsOrder();
        return staffSlotsOrder.get((level - 1) % staffSlotsOrder.size());
    }

    private static String getRandomStaffSlot() {
        List<String> staffSlotsRandomPool = Config.getStaffSlotsRandomPool();
        return staffSlotsRandomPool.get(RANDOM.nextInt(staffSlotsRandomPool.size()));
    }

    private static String getToolStatForLevel(int level) {
        List<String> toolsStatsOrder = Config.getToolsStatsOrder();
        return toolsStatsOrder.get((level - 1) % toolsStatsOrder.size());
    }

    private static String getRandomToolStat() {
        List<String> toolsStatsRandomPool = Config.getToolsStatsRandomPool();
        return toolsStatsRandomPool.get(RANDOM.nextInt(toolsStatsRandomPool.size()));
    }

    private static String getRangedStatForLevel(int level) {
        List<String> rangedStatsRotation = Config.getRangedStatsOrder();
        return rangedStatsRotation.get((level - 1) % rangedStatsRotation.size());
    }

    private static String getRandomRangedStat() {
        List<String> rangedStatsRandomPool = Config.getRangedStatsRandomPool();
        return rangedStatsRandomPool.get(RANDOM.nextInt(rangedStatsRandomPool.size()));
    }

    private static String getArmorStatForLevel(int level) {
        List<String> armorStatsOrder = Config.getArmorStatsOrder();
        return armorStatsOrder.get((level - 1) % armorStatsOrder.size());
    }

    private static String getRandomArmorStat() {
        List<String> armorStatsRandomPool = Config.getArmorStatsRandomPool();
        return armorStatsRandomPool.get(RANDOM.nextInt(armorStatsRandomPool.size()));
    }

    private static String getStaffStatForLevel(int level) {
        List<String> staffStatsOrder = Config.getStaffStatsOrder();
        return staffStatsOrder.get((level - 1) % staffStatsOrder.size());
    }

    private static String getRandomStaffStat() {
        List<String> staffStatsRandomPool = Config.getStaffStatsRandomPool();
        return staffStatsRandomPool.get(RANDOM.nextInt(staffStatsRandomPool.size()));
    }

    private static void appendHistory(ResourceLocation historyKey, String value, ModDataNBT data) {
        Object modifierHistory = data.getString(historyKey);
        modifierHistory = (String)modifierHistory + value + ";";
        data.putString(historyKey, (String)modifierHistory);
    }

    private ToolLevellingUtil() {
    }

    static {
        RANDOM = new Random();
        TOOL_SLOT_TYPES = new LinkedHashMap<String, SlotType>();
        TOOL_SLOT_TYPES.put(UPGRADE, SlotType.UPGRADE);
        TOOL_SLOT_TYPES.put(ABILITY, SlotType.ABILITY);
        TOOL_SLOT_TYPES.put(SOUL, SlotType.SOUL);
        TOOL_SLOT_TYPES.put(DEFENSE, SlotType.DEFENSE);
        ARMOR_SLOT_TYPES = new LinkedHashMap<String, SlotType>();
        ARMOR_SLOT_TYPES.put(UPGRADE, SlotType.UPGRADE);
        ARMOR_SLOT_TYPES.put(ABILITY, SlotType.ABILITY);
        ARMOR_SLOT_TYPES.put(SOUL, SlotType.SOUL);
        ARMOR_SLOT_TYPES.put(DEFENSE, SlotType.DEFENSE);
        ALL_SLOT_TYPES = new HashMap<String, SlotType>(TOOL_SLOT_TYPES);
        ALL_SLOT_TYPES.putAll(ARMOR_SLOT_TYPES);
        TOOL_STAT_TYPES = new LinkedHashMap<String, FloatToolStat>();
        TOOL_STAT_TYPES.put(DURABILITY, ToolStats.DURABILITY);
        TOOL_STAT_TYPES.put(ATTACK_DAMAGE, ToolStats.ATTACK_DAMAGE);
        TOOL_STAT_TYPES.put(ATTACK_SPEED, ToolStats.ATTACK_SPEED);
        TOOL_STAT_TYPES.put(MINING_SPEED, ToolStats.MINING_SPEED);
        RANGED_STAT_TYPES = new LinkedHashMap<String, FloatToolStat>();
        RANGED_STAT_TYPES.put(DRAW_SPEED, ToolStats.DRAW_SPEED);
        RANGED_STAT_TYPES.put(VELOCITY, ToolStats.VELOCITY);
        RANGED_STAT_TYPES.put(ACCURACY, ToolStats.ACCURACY);
        RANGED_STAT_TYPES.put(PROJECTILE_DAMAGE, ToolStats.PROJECTILE_DAMAGE);
        RANGED_STAT_TYPES.put(DURABILITY, ToolStats.DURABILITY);
        RANGED_STAT_TYPES.put(ATTACK_DAMAGE, ToolStats.ATTACK_DAMAGE);
        RANGED_STAT_TYPES.put(ATTACK_SPEED, ToolStats.ATTACK_SPEED);
        ARMOR_STAT_TYPES = new LinkedHashMap<String, FloatToolStat>();
        ARMOR_STAT_TYPES.put(DURABILITY, ToolStats.DURABILITY);
        ARMOR_STAT_TYPES.put(ARMOR, ToolStats.ARMOR);
        ARMOR_STAT_TYPES.put(ARMOR_TOUGHNESS, ToolStats.ARMOR_TOUGHNESS);
        ARMOR_STAT_TYPES.put(KNOCKBACK_RESISTANCE, ToolStats.KNOCKBACK_RESISTANCE);
        STAFF_STAT_TYPES = new LinkedHashMap<String, FloatToolStat>();
        STAFF_STAT_TYPES.put(DRAW_SPEED, ToolStats.DRAW_SPEED);
        STAFF_STAT_TYPES.put(VELOCITY, ToolStats.VELOCITY);
        STAFF_STAT_TYPES.put(ACCURACY, ToolStats.ACCURACY);
        STAFF_STAT_TYPES.put(PROJECTILE_DAMAGE, ToolStats.PROJECTILE_DAMAGE);
        STAFF_STAT_TYPES.put(DURABILITY, ToolStats.DURABILITY);
        STAFF_STAT_TYPES.put(ARMOR, ToolStats.ARMOR);
        ALL_STAT_TYPES = new HashMap<String, FloatToolStat>(TOOL_STAT_TYPES);
        ALL_STAT_TYPES.putAll(RANGED_STAT_TYPES);
        ALL_STAT_TYPES.putAll(ARMOR_STAT_TYPES);
        ALL_STAT_TYPES.putAll(STAFF_STAT_TYPES);
    }
}

