/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.particle.fast_render;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.particle.ParticleVertexSink;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SingleQuadParticle.class})
public abstract class MixinBillboardParticle
extends Particle {
    @Shadow
    public abstract float m_5902_(float var1);

    @Shadow
    protected abstract float m_5970_();

    @Shadow
    protected abstract float m_5952_();

    @Shadow
    protected abstract float m_5951_();

    @Shadow
    protected abstract float m_5950_();

    protected MixinBillboardParticle(ClientLevel world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Overwrite
    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Quaternion quaternion;
        Vec3 vec3d = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float y = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float z = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = camera.m_90591_();
        } else {
            float angle = Mth.m_14179_((float)tickDelta, (float)this.f_107204_, (float)this.f_107231_);
            quaternion = new Quaternion(camera.m_90591_());
            quaternion.m_80148_(Vector3f.f_122227_.m_122270_(angle));
        }
        float size = this.m_5902_(tickDelta);
        int light = this.m_6355_(tickDelta);
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        int color = ColorABGR.pack(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_);
        ParticleVertexSink drain = VertexDrain.of(vertexConsumer).createSink(VanillaVertexTypes.PARTICLES);
        drain.ensureCapacity(4);
        MixinBillboardParticle.addVertex(drain, quaternion, -1.0f, -1.0f, x, y, z, maxU, maxV, color, light, size);
        MixinBillboardParticle.addVertex(drain, quaternion, -1.0f, 1.0f, x, y, z, maxU, minV, color, light, size);
        MixinBillboardParticle.addVertex(drain, quaternion, 1.0f, 1.0f, x, y, z, minU, minV, color, light, size);
        MixinBillboardParticle.addVertex(drain, quaternion, 1.0f, -1.0f, x, y, z, minU, maxV, color, light, size);
        drain.flush();
    }

    private static void addVertex(ParticleVertexSink drain, Quaternion rotation, float x, float y, float posX, float posY, float posZ, float u, float v, int color, int light, float size) {
        float q0x = rotation.m_80140_();
        float q0y = rotation.m_80150_();
        float q0z = rotation.m_80153_();
        float q0w = rotation.m_80156_();
        float q1x = q0w * x - q0z * y;
        float q1y = q0w * y + q0z * x;
        float q1w = q0x * y - q0y * x;
        float q1z = -(q0x * x) - q0y * y;
        float q2x = -q0x;
        float q2y = -q0y;
        float q2z = -q0z;
        float q2w = q0w;
        float q3x = q1z * q2x + q1x * q2w + q1y * q2z - q1w * q2y;
        float q3y = q1z * q2y - q1x * q2z + q1y * q2w + q1w * q2x;
        float q3z = q1z * q2z + q1x * q2y - q1y * q2x + q1w * q2w;
        float fx = q3x * size + posX;
        float fy = q3y * size + posY;
        float fz = q3z * size + posZ;
        drain.writeParticle(fx, fy, fz, u, v, color, light);
    }
}

