/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.SimpleMultipartType;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import mrtjp.projectred.integration.item.GatePartItem;
import mrtjp.projectred.integration.part.ArrayGatePart;
import mrtjp.projectred.integration.part.BundledGatePart;
import mrtjp.projectred.integration.part.ComplexGatePart;
import mrtjp.projectred.integration.part.GatePart;
import mrtjp.projectred.integration.part.SimpleGatePart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public final class GateType
extends Enum<GateType> {
    public static final /* enum */ GateType OR = new GateType("or_gate", SimpleGatePart.OR::new);
    public static final /* enum */ GateType NOR = new GateType("nor_gate", SimpleGatePart.NOR::new);
    public static final /* enum */ GateType NOT = new GateType("not_gate", SimpleGatePart.NOT::new);
    public static final /* enum */ GateType AND = new GateType("and_gate", SimpleGatePart.AND::new);
    public static final /* enum */ GateType NAND = new GateType("nand_gate", SimpleGatePart.NAND::new);
    public static final /* enum */ GateType XOR = new GateType("xor_gate", SimpleGatePart.XOR::new);
    public static final /* enum */ GateType XNOR = new GateType("xnor_gate", SimpleGatePart.XNOR::new);
    public static final /* enum */ GateType BUFFER = new GateType("buffer_gate", SimpleGatePart.Buffer::new);
    public static final /* enum */ GateType MULTIPLEXER = new GateType("multiplexer_gate", SimpleGatePart.Multiplexer::new);
    public static final /* enum */ GateType PULSE = new GateType("pulse_gate", SimpleGatePart.Pulse::new);
    public static final /* enum */ GateType REPEATER = new GateType("repeater_gate", SimpleGatePart.Repeater::new);
    public static final /* enum */ GateType RANDOMIZER = new GateType("randomizer_gate", SimpleGatePart.Randomizer::new);
    public static final /* enum */ GateType SR_LATCH = new GateType("sr_latch_gate", ComplexGatePart.SRLatch::new);
    public static final /* enum */ GateType TOGGLE_LATCH = new GateType("toggle_latch_gate", ComplexGatePart.ToggleLatch::new);
    public static final /* enum */ GateType TRANSPARENT_LATCH = new GateType("transparent_latch_gate", SimpleGatePart.TransparentLatch::new);
    public static final /* enum */ GateType LIGHT_SENSOR = new GateType("light_sensor_gate", SimpleGatePart.LightSensor::new);
    public static final /* enum */ GateType RAIN_SENSOR = new GateType("rain_sensor_gate", SimpleGatePart.RainSensor::new);
    public static final /* enum */ GateType TIMER = new GateType("timer_gate", ComplexGatePart.Timer::new);
    public static final /* enum */ GateType SEQUENCER = new GateType("sequencer_gate", ComplexGatePart.Sequencer::new);
    public static final /* enum */ GateType COUNTER = new GateType("counter_gate", ComplexGatePart.Counter::new);
    public static final /* enum */ GateType STATE_CELL = new GateType("state_cell_gate", ComplexGatePart.StateCell::new);
    public static final /* enum */ GateType SYNCHRONIZER = new GateType("synchronizer_gate", ComplexGatePart.Synchronizer::new);
    public static final /* enum */ GateType BUS_TRANSCEIVER = new GateType("bus_transceiver_gate", BundledGatePart.BusTransceiver::new);
    public static final /* enum */ GateType NULL_CELL = new GateType("null_cell_gate", ArrayGatePart.NullCell::new);
    public static final /* enum */ GateType INVERT_CELL = new GateType("invert_cell_gate", ArrayGatePart.InvertCell::new);
    public static final /* enum */ GateType BUFFER_CELL = new GateType("buffer_cell_gate", ArrayGatePart.BufferCell::new);
    public static final /* enum */ GateType COMPARATOR = new GateType("comparator_gate", ComplexGatePart.Comparator::new);
    public static final /* enum */ GateType AND_CELL = new GateType("and_cell_gate", ArrayGatePart.ANDCell::new);
    public static final /* enum */ GateType BUS_RANDOMIZER = new GateType("bus_randomizer_gate", BundledGatePart.BusRandomizer::new);
    public static final /* enum */ GateType BUS_CONVERTER = new GateType("bus_converter_gate", BundledGatePart.BusConverter::new);
    public static final /* enum */ GateType BUS_INPUT_PANEL = new GateType("bus_input_panel_gate", BundledGatePart.BusInputPanel::new);
    public static final /* enum */ GateType TRANSPARENT_LATCH_CELL = new GateType("stacking_latch_gate", ArrayGatePart.TransparentLatchCell::new);
    public static final /* enum */ GateType SEGMENT_DISPLAY = new GateType("segment_display_gate", BundledGatePart.SegmentDisplay::new);
    public static final /* enum */ GateType DEC_RANDOMIZER = new GateType("dec_randomizer_gate", SimpleGatePart.DecodingRandomizer::new);
    public static final /* enum */ GateType FABRICATED_GATE = new GateType(null, null);
    @Nullable
    private String unlocalName;
    @Nullable
    private Function<GateType, GatePart> partFactory;
    @Nullable
    private RegistryObject<? extends Item> itemSupplier;
    @Nullable
    private RegistryObject<MultipartType<GatePart>> partSupplier;
    private boolean isExternalGate;
    private static final /* synthetic */ GateType[] $VALUES;

    public static GateType[] values() {
        return (GateType[])$VALUES.clone();
    }

    public static GateType valueOf(String name) {
        return Enum.valueOf(GateType.class, name);
    }

    private GateType(String unlocalName, Function<GateType, GatePart> partFactory) {
        this.unlocalName = unlocalName;
        this.partFactory = partFactory;
        this.isExternalGate = partFactory == null;
    }

    public boolean isExternalGate() {
        return this.isExternalGate;
    }

    public String getUnlocalizedName() {
        assert (this.unlocalName != null);
        return this.unlocalName;
    }

    public RegistryObject<? extends Item> getItemRegistryObject() {
        assert (this.itemSupplier != null);
        return this.itemSupplier;
    }

    public Item getItem() {
        assert (this.itemSupplier != null);
        return (Item)this.itemSupplier.get();
    }

    public ItemStack makeStack() {
        return new ItemStack((ItemLike)this.getItem());
    }

    public MultipartType<GatePart> getPartType() {
        assert (this.partSupplier != null);
        return (MultipartType)this.partSupplier.get();
    }

    public GatePart newPart() {
        assert (this.partFactory != null);
        return this.partFactory.apply(this);
    }

    public void registerParts(DeferredRegister<MultipartType<?>> partRegistry, DeferredRegister<Item> itemRegistry) {
        this.itemSupplier = itemRegistry.register(this.unlocalName, () -> new GatePartItem(this));
        this.partSupplier = partRegistry.register(this.unlocalName, () -> new SimpleMultipartType(isClient -> Objects.requireNonNull(this.partFactory).apply(this)));
    }

    public void inject(String unlocalName, Function<GateType, GatePart> partFactory, RegistryObject<? extends Item> itemSupplier, RegistryObject<MultipartType<GatePart>> partSupplier) {
        if (this.itemSupplier != null || this.partSupplier != null) {
            throw new RuntimeException("GateType " + this.name() + " already registered!");
        }
        this.unlocalName = unlocalName;
        this.partFactory = partFactory;
        this.itemSupplier = itemSupplier;
        this.partSupplier = partSupplier;
    }

    private static /* synthetic */ GateType[] $values() {
        return new GateType[]{OR, NOR, NOT, AND, NAND, XOR, XNOR, BUFFER, MULTIPLEXER, PULSE, REPEATER, RANDOMIZER, SR_LATCH, TOGGLE_LATCH, TRANSPARENT_LATCH, LIGHT_SENSOR, RAIN_SENSOR, TIMER, SEQUENCER, COUNTER, STATE_CELL, SYNCHRONIZER, BUS_TRANSCEIVER, NULL_CELL, INVERT_CELL, BUFFER_CELL, COMPARATOR, AND_CELL, BUS_RANDOMIZER, BUS_CONVERTER, BUS_INPUT_PANEL, TRANSPARENT_LATCH_CELL, SEGMENT_DISPLAY, DEC_RANDOMIZER, FABRICATED_GATE};
    }

    static {
        $VALUES = GateType.$values();
    }
}

