/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration.client;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.texture.AtlasRegistrar;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.core.part.IOrientableFacePart;
import mrtjp.projectred.integration.GateType;
import mrtjp.projectred.integration.client.GateComponentModels;
import mrtjp.projectred.integration.part.GatePart;
import mrtjp.projectred.integration.part.IGateRenderData;
import mrtjp.projectred.lib.VecLib;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GateModelRenderer {
    private static final ThreadLocal<GateModelRenderer> INSTANCES = ThreadLocal.withInitial(GateModelRenderer::new);
    private final GateRenderer[] renderers = new GateRenderer[]{new RenderOR(), new RenderNOR(), new RenderNOT(), new RenderAND(), new RenderNAND(), new RenderXOR(), new RenderXNOR(), new RenderBuffer(), new RenderMultiplexer(), new RenderPulse(), new RenderRepeater(), new RenderRandomizer(), new RenderSRLatch(), new RenderToggleLatch(), new RenderTransparentLatch(), new RenderLightSensor(), new RenderRainSensor(), new RenderTimer(), new RenderSequencer(), new RenderCounter(), new RenderStateCell(), new RenderSynchronizer(), new RenderBusXcvr(), new RenderNullCell(), new RenderInvertCell(), new RenderBufferCell(), new RenderComparator(), new RenderANDCell(), new RenderBusRandomizer(), new RenderBusConverter(), new RenderBusInputPanel(), new RenderTransparentLatchCell(), new RenderSegmentDisplay(), new RenderDecodingRandomizer(), new RenderFabricatedGate()};
    private final GateRenderer[] nonPartRenderers = new GateRenderer[]{new RenderIOGate()};

    public static GateModelRenderer instance() {
        return INSTANCES.get();
    }

    public void renderStatic(CCRenderState ccrs, IGateRenderData key, Transformation t) {
        GateRenderer r = this.getRenderer(key.getRenderIndex());
        r.prepare(key);
        r.renderStatic(ccrs, key.getOrientation(), t);
    }

    public void renderDynamic(CCRenderState ccrs, IGateRenderData key, Transformation t, float partialFrame) {
        this.renderDynamic(ccrs, key, t, null, null, 0, 0, partialFrame);
    }

    public void renderDynamic(CCRenderState ccrs, IGateRenderData key, Transformation t, @Nullable PoseStack mStack, @Nullable MultiBufferSource buffers, int packedLight, int packedOverlay, float partialTicks) {
        GateRenderer r = this.getRenderer(key.getRenderIndex());
        if (r.hasSpecials()) {
            TransformationList t2 = VecLib.orientT((int)key.getOrientation()).with(t);
            r.prepareDynamic(key, partialTicks);
            r.renderDynamic(ccrs, (Transformation)t2);
            if (mStack != null && buffers != null) {
                r.renderCustomDynamic(ccrs, (Transformation)t2, mStack, buffers, packedLight, packedOverlay, partialTicks);
            }
        }
    }

    public void renderInventory(CCRenderState ccrs, @Nullable ItemStack stack, int renderIndex, int orient, Transformation t) {
        this.renderInventory(ccrs, stack, renderIndex, orient, t, null, null, 0, 0);
    }

    public void renderInventory(CCRenderState ccrs, @Nullable ItemStack stack, int renderIndex, int orient, Transformation t, @Nullable PoseStack mStack, @Nullable MultiBufferSource buffers, int packedLight, int packedOverlay) {
        GateRenderer r = this.getRenderer(renderIndex);
        r.prepareInventory(stack);
        r.renderStatic(ccrs, orient, t);
        if (r.hasSpecials()) {
            r.renderDynamic(ccrs, t);
            if (mStack != null && buffers != null) {
                r.renderCustomDynamic(ccrs, t, mStack, buffers, packedLight, packedOverlay, 0.0f);
            }
        }
    }

    public void spawnParticles(GatePart part, RandomSource random) {
        GateRenderer r = this.getRenderer(part.getGateType().ordinal());
        r.prepare(part);
        r.spawnParticles(part, random);
    }

    public static int getRenderIndex(GateType type) {
        return type.ordinal();
    }

    public static int getNonPartRenderIndex(int i) {
        return 0x100 | i;
    }

    private GateRenderer getRenderer(int renderIndex) {
        if ((renderIndex & 0x100) != 0) {
            return this.nonPartRenderers[renderIndex & 0xFF];
        }
        return this.renderers[renderIndex];
    }

    public static void registerIcons(AtlasRegistrar registrar) {
        GateComponentModels.registerIcons(registrar);
    }

    public static void onResourceManagerReload(ResourceManager resourceManager) {
        GateComponentModels.WireModel3D.regenerateModels();
    }

    public static abstract class GateRenderer {
        public boolean reflect = false;

        protected abstract List<GateComponentModels.ComponentModel> getModels();

        protected abstract void prepareInventory(@Nullable ItemStack var1);

        protected abstract void prepare(IGateRenderData var1);

        protected void prepareDynamic(IGateRenderData gate, float partialFrame) {
        }

        protected void renderModels(CCRenderState ccrs, int orient, Transformation t) {
            for (GateComponentModels.ComponentModel m : this.getModels()) {
                m.renderModel(t, orient, ccrs);
            }
        }

        public void renderStatic(CCRenderState ccrs, int orient, Transformation t) {
            this.renderModels(ccrs, this.reflect ? orient + 24 : orient, t);
        }

        public void spawnParticles(GatePart gate, RandomSource random) {
            LinkedList<GateComponentModels.IRedstoneTorchComponentModel> torches = new LinkedList<GateComponentModels.IRedstoneTorchComponentModel>();
            for (GateComponentModels.ComponentModel m : this.getModels()) {
                if (!(m instanceof GateComponentModels.IRedstoneTorchComponentModel) || !((GateComponentModels.IRedstoneTorchComponentModel)((Object)m)).isLit()) continue;
                torches.add((GateComponentModels.IRedstoneTorchComponentModel)((Object)m));
            }
            for (GateComponentModels.IRedstoneTorchComponentModel torch : torches) {
                if (random.m_188503_(torches.size()) != 0) continue;
                Vector3 pos = torch.getLightPos().copy().add((random.m_188500_() - 0.5) * 0.2, 0.0, (random.m_188500_() - 0.5) * 0.2);
                pos.apply(gate.rotationT()).add(gate.pos());
                float f = 1.0f;
                float f1 = f * 0.6f + 0.4f;
                float f2 = Math.max(0.0f, f * f * 0.7f - 0.5f);
                float f3 = Math.max(0.0f, f * f * 0.6f - 0.7f);
                gate.level().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(f1, f2, f3), 1.0f), pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
            }
        }

        public boolean hasSpecials() {
            return false;
        }

        public void renderDynamic(CCRenderState ccrs, Transformation t) {
        }

        public void renderCustomDynamic(CCRenderState ccrs, Transformation t, PoseStack mStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float partialTicks) {
        }
    }

    public static class RenderOR
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("or", 4);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(8.0, 9.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 2.5, 8)};

        public RenderOR() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[2].disabled = false;
            this.wires[3].disabled = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 0x10) == 0;
            this.wires[1].on = (gate.state() & 2) != 0;
            this.wires[2].on = (gate.state() & 4) != 0;
            this.wires[3].on = (gate.state() & 8) != 0;
            this.wires[1].disabled = (gate.shape() & 1) != 0;
            this.wires[2].disabled = (gate.shape() & 2) != 0;
            this.wires[3].disabled = (gate.shape() & 4) != 0;
            this.torches[0].on = (gate.state() & 0xE) == 0;
            this.torches[1].on = !this.wires[0].on;
        }
    }

    public static class RenderNOR
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("nor", 4);
        private final GateComponentModels.RedstoneTorchModel torch = new GateComponentModels.RedstoneTorchModel(8.0, 9.0, 6);

        public RenderNOR() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[2].disabled = false;
            this.wires[3].disabled = false;
            this.torch.on = true;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 0x11) != 0;
            this.wires[1].on = (gate.state() & 2) != 0;
            this.wires[2].on = (gate.state() & 4) != 0;
            this.wires[3].on = (gate.state() & 8) != 0;
            this.wires[1].disabled = (gate.shape() & 1) != 0;
            this.wires[2].disabled = (gate.shape() & 2) != 0;
            this.wires[3].disabled = (gate.shape() & 4) != 0;
            this.torch.on = (gate.state() & 0xE) == 0;
        }
    }

    public static class RenderNOT
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("not", 4);
        private final GateComponentModels.RedstoneTorchModel torch = new GateComponentModels.RedstoneTorchModel(8.0, 8.0, 6);

        public RenderNOT() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = true;
            this.wires[1].on = true;
            this.wires[2].on = false;
            this.wires[3].on = true;
            this.wires[0].disabled = false;
            this.wires[1].disabled = false;
            this.wires[3].disabled = false;
            this.torch.on = true;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 0x11) != 0;
            this.wires[1].on = (gate.state() & 0x22) != 0;
            this.wires[2].on = (gate.state() & 4) != 0;
            this.wires[3].on = (gate.state() & 0x88) != 0;
            this.wires[0].disabled = (gate.shape() & 2) != 0;
            this.wires[1].disabled = (gate.shape() & 1) != 0;
            this.wires[3].disabled = (gate.shape() & 4) != 0;
            this.torch.on = (gate.state() & 0xF0) != 0;
        }
    }

    public static class RenderAND
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("and", 4);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(4.0, 8.0, 6), new GateComponentModels.RedstoneTorchModel(12.0, 8.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 8.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 2.0, 8)};

        public RenderAND() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[2].disabled = false;
            this.wires[3].disabled = false;
            this.torches[0].on = true;
            this.torches[1].on = true;
            this.torches[2].on = true;
            this.torches[3].on = false;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 0x11) == 0;
            this.wires[3].on = (gate.state() & 2) != 0;
            this.wires[1].on = (gate.state() & 4) != 0;
            this.wires[2].on = (gate.state() & 8) != 0;
            this.wires[3].disabled = (gate.shape() & 1) != 0;
            this.wires[1].disabled = (gate.shape() & 2) != 0;
            this.wires[2].disabled = (gate.shape() & 4) != 0;
            this.torches[2].on = !this.wires[1].on && !this.wires[1].disabled;
            this.torches[0].on = !this.wires[2].on && !this.wires[2].disabled;
            this.torches[1].on = !this.wires[3].on && !this.wires[3].disabled;
            this.torches[3].on = !this.wires[0].on;
        }
    }

    public static class RenderNAND
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("nand", 4);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(4.0, 8.0, 6), new GateComponentModels.RedstoneTorchModel(12.0, 8.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 8.0, 6)};

        public RenderNAND() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[2].disabled = false;
            this.wires[3].disabled = false;
            this.torches[0].on = true;
            this.torches[1].on = true;
            this.torches[2].on = true;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 0x11) != 0;
            this.wires[3].on = (gate.state() & 2) != 0;
            this.wires[1].on = (gate.state() & 4) != 0;
            this.wires[2].on = (gate.state() & 8) != 0;
            this.wires[3].disabled = (gate.shape() & 1) != 0;
            this.wires[1].disabled = (gate.shape() & 2) != 0;
            this.wires[2].disabled = (gate.shape() & 4) != 0;
            this.torches[0].on = !this.wires[2].on && !this.wires[2].disabled;
            this.torches[1].on = !this.wires[3].on && !this.wires[3].disabled;
            this.torches[2].on = !this.wires[1].on && !this.wires[1].disabled;
        }
    }

    public static class RenderXOR
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("xor", 4);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(4.5, 8.0, 6), new GateComponentModels.RedstoneTorchModel(11.5, 8.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 12.0, 6)};

        public RenderXOR() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = false;
            this.wires[3].on = false;
            this.wires[2].on = false;
            this.wires[1].on = true;
            this.torches[0].on = false;
            this.torches[1].on = false;
            this.torches[2].on = true;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 0x11) != 0;
            this.wires[3].on = (gate.state() & 2) != 0;
            this.wires[2].on = (gate.state() & 8) != 0;
            this.wires[1].on = !this.wires[3].on && !this.wires[2].on;
            this.torches[0].on = !this.wires[2].on && !this.wires[1].on;
            this.torches[1].on = !this.wires[3].on && !this.wires[1].on;
            this.torches[2].on = this.wires[1].on;
        }
    }

    public static class RenderXNOR
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("xnor", 5);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(8.0, 2.0, 8), new GateComponentModels.RedstoneTorchModel(4.5, 8.0, 6), new GateComponentModels.RedstoneTorchModel(11.5, 8.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 12.0, 6)};

        public RenderXNOR() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = false;
            this.wires[3].on = false;
            this.wires[2].on = false;
            this.wires[1].on = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = false;
            this.torches[3].on = true;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 2) != 0 && (gate.state() & 8) == 0;
            this.wires[1].on = (gate.state() & 8) != 0 && (gate.state() & 2) == 0;
            this.wires[2].on = (gate.state() & 8) != 0;
            this.wires[3].on = (gate.state() & 2) != 0;
            this.wires[4].on = !this.wires[3].on && !this.wires[2].on;
            this.torches[0].on = (gate.state() & 0x11) != 0;
            this.torches[1].on = !this.wires[4].on && (gate.state() & 8) == 0;
            this.torches[2].on = !this.wires[4].on && (gate.state() & 2) == 0;
            this.torches[3].on = (gate.state() & 2) == 0 && (gate.state() & 8) == 0;
        }
    }

    public static class RenderBuffer
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("buffer", 4);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(8.0, 3.5, 8), new GateComponentModels.RedstoneTorchModel(8.0, 9.0, 6)};

        public RenderBuffer() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[3].disabled = false;
            this.torches[0].on = false;
            this.torches[1].on = true;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 4) == 0;
            this.wires[1].on = (gate.state() & 0x22) != 0;
            this.wires[2].on = (gate.state() & 0x44) != 0;
            this.wires[3].on = (gate.state() & 0x88) != 0;
            this.wires[1].disabled = (gate.shape() & 1) != 0;
            this.wires[3].disabled = (gate.shape() & 2) != 0;
            this.torches[0].on = (gate.state() & 4) != 0;
            this.torches[1].on = (gate.state() & 4) == 0;
        }
    }

    public static class RenderMultiplexer
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("multiplexer", 6);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(8.0, 2.0, 8), new GateComponentModels.RedstoneTorchModel(9.0, 10.5, 6), new GateComponentModels.RedstoneTorchModel(4.5, 8.0, 6), new GateComponentModels.RedstoneTorchModel(11.5, 8.0, 6)};

        public RenderMultiplexer() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = false;
            this.wires[1].on = true;
            this.wires[2].on = true;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.wires[5].on = false;
            this.torches[0].on = false;
            this.torches[1].on = true;
            this.torches[2].on = false;
            this.torches[3].on = true;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[2].on = (gate.state() & 4) == 0;
            this.wires[3].on = (gate.state() & 4) != 0;
            this.wires[4].on = (gate.state() & 8) != 0;
            this.wires[5].on = (gate.state() & 2) != 0;
            this.torches[0].on = (gate.state() & 0x10) != 0;
            this.torches[1].on = !this.wires[3].on;
            this.torches[2].on = (gate.state() & 8) == 0 && this.wires[3].on;
            this.torches[3].on = (gate.state() & 4) == 0 && !this.wires[5].on;
            this.wires[0].on = this.torches[2].on;
            this.wires[1].on = this.torches[3].on;
        }
    }

    public static class RenderPulse
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("pulse", 3);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(4.0, 9.5, 6), new GateComponentModels.RedstoneTorchModel(11.0, 9.5, 6), new GateComponentModels.RedstoneTorchModel(8.0, 3.5, 8)};

        public RenderPulse() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = false;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 4) == 0;
            this.wires[1].on = (gate.state() & 4) != 0;
            this.wires[2].on = (gate.state() & 0x14) == 4;
            this.torches[0].on = this.wires[0].on;
            this.torches[1].on = this.wires[1].on;
            this.torches[2].on = (gate.state() & 0x10) != 0;
        }
    }

    public static class RenderRepeater
    extends GateRenderer {
        private final ArrayList<List<GateComponentModels.ComponentModel>> models;
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("repeater", 2);
        private final GateComponentModels.RedstoneTorchModel endTorch = new GateComponentModels.RedstoneTorchModel(8.0, 2.0, 6);
        private final GateComponentModels.RedstoneTorchModel[] delayTorches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(12.5, 12.0, 6), new GateComponentModels.RedstoneTorchModel(12.5, 11.0, 6), new GateComponentModels.RedstoneTorchModel(12.5, 10.0, 6), new GateComponentModels.RedstoneTorchModel(12.5, 9.0, 6), new GateComponentModels.RedstoneTorchModel(12.5, 8.0, 6), new GateComponentModels.RedstoneTorchModel(12.5, 7.0, 6), new GateComponentModels.RedstoneTorchModel(12.5, 6.0, 6), new GateComponentModels.RedstoneTorchModel(12.5, 5.0, 6), new GateComponentModels.RedstoneTorchModel(12.5, 4.0, 6)};
        private int shape = 0;

        public RenderRepeater() {
            this.models = new ArrayList(this.delayTorches.length);
            for (int i = 0; i < this.delayTorches.length; ++i) {
                LinkedList<GateComponentModels.ComponentModel> list = new LinkedList<GateComponentModels.ComponentModel>();
                list.add(GateComponentModels.BaseComponentModel.INSTANCE);
                list.addAll(Arrays.asList(this.wires));
                list.add(this.endTorch);
                list.add(this.delayTorches[i]);
                this.models.add(i, list);
            }
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models.get(this.shape);
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.endTorch.on = false;
            this.shape = 0;
            this.delayTorches[0].on = true;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 0x10) == 0;
            this.wires[1].on = (gate.state() & 4) != 0;
            this.endTorch.on = (gate.state() & 0x10) != 0;
            this.shape = gate.shape();
            this.delayTorches[this.shape].on = (gate.state() & 4) == 0;
        }
    }

    public static class RenderRandomizer
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("rand", 7);
        private final GateComponentModels.OnOffModel[] chips = new GateComponentModels.OnOffModel[]{new GateComponentModels.YellowChipModel(8.0, 5.5), new GateComponentModels.YellowChipModel(11.5, 11.5), new GateComponentModels.YellowChipModel(4.5, 11.5)};

        public RenderRandomizer() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.chips));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.wires[5].on = false;
            this.wires[6].on = false;
            this.wires[0].disabled = false;
            this.wires[1].disabled = false;
            this.wires[3].disabled = false;
            this.wires[4].disabled = false;
            this.wires[5].disabled = false;
            this.wires[6].disabled = false;
            this.chips[0].on = false;
            this.chips[1].on = false;
            this.chips[2].on = false;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[2].on = (gate.state() & 4) != 0;
            this.wires[0].on = (gate.state() & 0x11) != 0;
            this.wires[1].on = (gate.state() & 0x22) != 0;
            this.wires[3].on = (gate.state() & 0x88) != 0;
            this.wires[4].on = this.wires[2].on;
            this.wires[5].on = this.wires[2].on;
            this.wires[6].on = this.wires[2].on;
            this.wires[1].disabled = (gate.shape() & 1) != 0;
            this.wires[0].disabled = (gate.shape() & 2) != 0;
            this.wires[3].disabled = (gate.shape() & 4) != 0;
            this.wires[5].disabled = this.wires[1].disabled;
            this.wires[4].disabled = this.wires[0].disabled;
            this.wires[6].disabled = this.wires[3].disabled;
            this.chips[0].on = (gate.state() & 0x10) != 0;
            this.chips[1].on = (gate.state() & 0x20) != 0;
            this.chips[2].on = (gate.state() & 0x80) != 0;
        }
    }

    public static class RenderSRLatch
    extends GateRenderer {
        private final ArrayList<List<GateComponentModels.ComponentModel>> models = new ArrayList(2);
        private final GateComponentModels.WireModel[] wires1 = GateComponentModels.generateWireModels("rslatch", 2);
        private final GateComponentModels.WireModel[] wires2 = GateComponentModels.generateWireModels("rslatch2", 4);
        private final GateComponentModels.RedstoneTorchModel[] torches1 = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(8.0, 3.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 13.0, 6)};
        private final GateComponentModels.RedstoneTorchModel[] torches2 = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(9.5, 3.0, 6), new GateComponentModels.RedstoneTorchModel(6.5, 13.0, 6)};
        private int shape = 0;

        public RenderSRLatch() {
            LinkedList<GateComponentModels.ComponentModel> shape0 = new LinkedList<GateComponentModels.ComponentModel>();
            shape0.add(GateComponentModels.BaseComponentModel.INSTANCE);
            shape0.addAll(Arrays.asList(this.wires1));
            shape0.addAll(Arrays.asList(this.torches1));
            LinkedList<GateComponentModels.ComponentModel> shape1 = new LinkedList<GateComponentModels.ComponentModel>();
            shape1.add(GateComponentModels.BaseComponentModel.INSTANCE);
            shape1.addAll(Arrays.asList(this.wires2));
            shape1.addAll(Arrays.asList(this.torches2));
            this.models.add(shape0);
            this.models.add(shape1);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models.get(this.shape);
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.reflect = false;
            this.shape = 0;
            this.wires1[0].on = false;
            this.wires1[1].on = true;
            this.torches1[0].on = false;
            this.torches1[1].on = true;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.reflect = (gate.shape() & 1) != 0;
            this.shape = gate.shape() >> 1;
            int state = gate.state();
            if (this.reflect) {
                state = IOrientableFacePart.flipMaskZ((int)(state >> 4)) << 4 | IOrientableFacePart.flipMaskZ((int)state);
            }
            if (this.shape == 0) {
                this.wires1[0].on = (state & 0x88) != 0;
                this.wires1[1].on = (state & 0x22) != 0;
                this.torches1[0].on = (state & 0x10) != 0;
                this.torches1[1].on = (state & 0x40) != 0;
            } else {
                this.wires2[1].on = (state & 2) != 0;
                this.wires2[3].on = (state & 8) != 0;
                this.torches2[0].on = (state & 0x10) != 0;
                this.torches2[1].on = (state & 0x40) != 0;
                this.wires2[0].on = this.torches2[1].on;
                this.wires2[2].on = this.torches2[0].on;
            }
        }
    }

    public static class RenderToggleLatch
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("toglatch", 2);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(4.0, 4.0, 6), new GateComponentModels.RedstoneTorchModel(4.0, 12.0, 6)};
        private final GateComponentModels.LeverModel lever = new GateComponentModels.LeverModel(11.0, 8.0);

        public RenderToggleLatch() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
            this.models.add(this.lever);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.lever.state = 0;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 8) != 0;
            this.wires[1].on = (gate.state() & 2) != 0;
            this.torches[0].on = (gate.state() & 0x10) != 0;
            this.torches[1].on = (gate.state() & 0x40) != 0;
            this.lever.state = (gate.state() & 0x10) != 0 ? 0 : 1;
        }
    }

    public static class RenderTransparentLatch
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("translatch", 5);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(4.0, 12.5, 6), new GateComponentModels.RedstoneTorchModel(4.0, 8.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 8.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 2.0, 8), new GateComponentModels.RedstoneTorchModel(14.0, 8.0, 8)};

        public RenderTransparentLatch() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.reflect = false;
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = true;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = true;
            this.torches[3].on = false;
            this.torches[4].on = false;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.reflect = gate.shape() == 1;
            boolean on = (gate.state() & 0x10) != 0;
            this.wires[0].on = !on;
            this.wires[1].on = (gate.state() & 4) != 0;
            this.wires[2].on = (gate.state() & 4) == 0;
            this.wires[3].on = on;
            this.wires[4].on = (gate.state() & 0xA) != 0;
            this.torches[0].on = this.wires[2].on;
            this.torches[1].on = !this.wires[2].on && !this.wires[4].on;
            this.torches[2].on = !this.wires[1].on && !this.wires[3].on;
            this.torches[3].on = on;
            this.torches[4].on = on;
        }
    }

    public static class RenderLightSensor
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("lightsensor", 1);
        private final GateComponentModels.SolarModel solar = new GateComponentModels.SolarModel(8.0, 5.5);

        public RenderLightSensor() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.solar);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = false;
            this.solar.state = 0;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 0xF4) != 0;
            this.solar.state = gate.shape();
        }
    }

    public static class RenderRainSensor
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("rainsensor", 1);
        private final GateComponentModels.RainSensorModel sensor = new GateComponentModels.RainSensorModel(8.0, 6.0);

        public RenderRainSensor() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.sensor);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = false;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 0x44) != 0;
        }
    }

    public static class RenderTimer
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("time", 3);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(8.0, 3.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 8.0, 12)};
        private final GateComponentModels.PointerModel pointer = new GateComponentModels.PointerModel(8.0, 8.0, 8.0);

        public RenderTimer() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.torches[0].on = false;
            this.pointer.angle = 0.0;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.torches[0].on = (gate.state() & 0x10) != 0;
            this.wires[0].on = (gate.state() & 0x88) != 0;
            this.wires[1].on = (gate.state() & 0x22) != 0;
            this.wires[2].on = (gate.state() & 4) != 0;
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        protected void prepareDynamic(IGateRenderData gate, float partialFrame) {
            float interpPointer = !gate.isPointerStarted() ? 0.0f : ((float)gate.pointerValue() + partialFrame) / (float)gate.pointerMax();
            this.pointer.angle = (double)interpPointer * Math.PI * 2.0;
        }

        @Override
        public void renderDynamic(CCRenderState ccrs, Transformation t) {
            this.pointer.renderModel(t, 0, ccrs);
        }
    }

    public static class RenderSequencer
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(8.0, 8.0, 12), new GateComponentModels.RedstoneTorchModel(8.0, 3.0, 6), new GateComponentModels.RedstoneTorchModel(13.0, 8.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 13.0, 6), new GateComponentModels.RedstoneTorchModel(3.0, 8.0, 6)};
        private final GateComponentModels.PointerModel pointer = new GateComponentModels.PointerModel(8.0, 8.0, 8.0);

        public RenderSequencer() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.torches[0].on = true;
            this.torches[1].on = true;
            this.torches[2].on = false;
            this.torches[3].on = false;
            this.torches[4].on = false;
            this.pointer.angle = 0.0;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.torches[0].on = true;
            this.torches[1].on = (gate.state() & 0x10) != 0;
            this.torches[2].on = (gate.state() & 0x20) != 0;
            this.torches[3].on = (gate.state() & 0x40) != 0;
            this.torches[4].on = (gate.state() & 0x80) != 0;
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        protected void prepareDynamic(IGateRenderData gate, float partialFrame) {
            int max = gate.pointerMax() * 4;
            float interpPointer = !gate.isPointerStarted() ? 0.0f : ((float)gate.pointerValue() + partialFrame) / (float)max;
            this.pointer.angle = (double)interpPointer * Math.PI * 2.0;
            if (gate.shape() == 1) {
                this.pointer.angle *= -1.0;
            }
        }

        @Override
        public void renderDynamic(CCRenderState ccrs, Transformation t) {
            this.pointer.renderModel(t, 0, ccrs);
        }
    }

    public static class RenderCounter
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("count", 2);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(11.0, 8.0, 12), new GateComponentModels.RedstoneTorchModel(8.0, 3.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 13.0, 6)};
        private final GateComponentModels.PointerModel pointer = new GateComponentModels.PointerModel(11.0, 8.0, 8.0, 1.2);

        public RenderCounter() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.reflect = false;
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.torches[1].on = false;
            this.torches[2].on = true;
            this.pointer.angle = 3.83972435438746;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.reflect = gate.shape() == 1;
            this.wires[0].on = (gate.state() & 8) != 0;
            this.wires[1].on = (gate.state() & 2) != 0;
            this.torches[1].on = (gate.state() & 0x10) != 0;
            this.torches[2].on = (gate.state() & 0x40) != 0;
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        protected void prepareDynamic(IGateRenderData gate, float partialFrame) {
            double interpPointer = (double)gate.pointerValue() / (double)gate.pointerMax() * 120.0 + 210.0;
            this.pointer.angle = interpPointer * 0.017453292519943;
            this.reflect = gate.shape() == 1;
        }

        @Override
        public void renderDynamic(CCRenderState ccrs, Transformation t) {
            this.pointer.renderModel(t, this.reflect ? 1 : 0, ccrs);
        }
    }

    public static class RenderStateCell
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("statecell", 5);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(10.0, 3.5, 6), new GateComponentModels.RedstoneTorchModel(13.0, 8.0, 12)};
        private final GateComponentModels.OnOffModel chip = new GateComponentModels.RedChipModel(6.5, 10.0);
        private final GateComponentModels.PointerModel pointer = new GateComponentModels.PointerModel(13.0, 8.0, 8.0);

        public RenderStateCell() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
            this.models.add(this.chip);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.reflect = false;
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.torches[0].on = false;
            this.torches[1].on = true;
            this.chip.on = false;
            this.pointer.angle = -1.5707963267948966;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.reflect = gate.shape() == 1;
            int state = gate.state();
            if (this.reflect) {
                state = IOrientableFacePart.flipMaskZ((int)(state >> 4)) << 4 | IOrientableFacePart.flipMaskZ((int)state);
            }
            this.wires[0].on = (state & 0x10) != 0;
            this.wires[1].on = (state & 4) != 0;
            this.wires[2].on = gate.state2() == 0 || (state & 4) != 0;
            this.wires[3].on = (state & 0x88) != 0;
            this.wires[4].on = (state & 2) != 0;
            this.torches[0].on = (state & 0x10) != 0;
            this.torches[1].on = gate.isPointerStarted();
            this.chip.on = gate.state2() != 0;
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        protected void prepareDynamic(IGateRenderData gate, float partialFrame) {
            this.reflect = gate.shape() == 1;
            double interpPointer = !gate.isPointerStarted() ? 0.0 : (double)(((float)gate.pointerValue() + partialFrame) / (float)gate.pointerMax());
            this.pointer.angle = interpPointer - 1.5707963267948966;
        }

        @Override
        public void renderDynamic(CCRenderState ccrs, Transformation t) {
            this.pointer.renderModel(t, this.reflect ? 1 : 0, ccrs);
        }
    }

    public static class RenderSynchronizer
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("sync", 6);
        private final GateComponentModels.RedstoneTorchModel torch = new GateComponentModels.RedstoneTorchModel(8.0, 3.0, 6);
        private final GateComponentModels.OnOffModel[] chips = new GateComponentModels.OnOffModel[]{new GateComponentModels.RedChipModel(4.5, 9.0), new GateComponentModels.RedChipModel(11.5, 9.0)};

        public RenderSynchronizer() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
            this.models.addAll(Arrays.asList(this.chips));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = true;
            this.wires[1].on = true;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.wires[5].on = false;
            this.chips[0].on = false;
            this.chips[1].on = false;
            this.torch.on = false;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            boolean right = (gate.state2() & 1) != 0;
            boolean left = (gate.state2() & 2) != 0;
            this.wires[0].on = !left;
            this.wires[1].on = !right;
            this.wires[2].on = (gate.state() & 4) != 0;
            this.wires[3].on = left && right;
            this.wires[4].on = (gate.state() & 8) != 0;
            this.wires[5].on = (gate.state() & 2) != 0;
            this.chips[0].on = left;
            this.chips[1].on = right;
            this.torch.on = (gate.state() & 0x10) != 0;
        }
    }

    public static class RenderBusXcvr
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("busxcvr", 2);
        private final GateComponentModels.SignalPanelModel[] panels = new GateComponentModels.SignalPanelModel[]{new GateComponentModels.SignalPanelModel(4.0, 8.0, 0), new GateComponentModels.SignalPanelModel(12.0, 8.0, 2)};

        public RenderBusXcvr() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.add(GateComponentModels.BusXcvrCableModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.panels));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.reflect = false;
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.panels[0].signal = 0;
            this.panels[1].signal = 0;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.reflect = gate.shape() != 0;
            int state = gate.state();
            if (this.reflect) {
                state = IOrientableFacePart.flipMaskZ((int)state);
            }
            this.wires[0].on = (state & 2) != 0;
            this.wires[1].on = (state & 8) != 0;
            this.panels[0].signal = gate.bOutput2();
            this.panels[1].signal = gate.bOutput0();
        }
    }

    public static class RenderNullCell
    extends RenderArrayCell {
        public RenderNullCell() {
            super(new GateComponentModels.NullCellTopWireModel(), new GateComponentModels.NullCellBottomWireModel());
            this.models.add(GateComponentModels.NullCellBaseModel.INSTANCE);
        }
    }

    public static class RenderInvertCell
    extends RenderArrayCell {
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("invcell", 1);
        private final GateComponentModels.RedstoneTorchModel torch = new GateComponentModels.RedstoneTorchModel(8.0, 8.0, 6);

        public RenderInvertCell() {
            super(new GateComponentModels.LogicCellTopWireModel(), new GateComponentModels.LogicCellBottomWireModel());
            this.models.add(GateComponentModels.LogicCellBaseModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            super.prepareInventory(stack);
            this.topWire.signal = (byte)-1;
            this.wires[0].on = false;
            this.torch.on = true;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            super.prepare(gate);
            this.torch.on = gate.bottomSignal() == 0;
            this.wires[0].on = gate.bottomSignal() != 0;
        }
    }

    public static class RenderBufferCell
    extends RenderArrayCell {
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("buffcell", 2);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(11.0, 13.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 8.0, 6)};

        public RenderBufferCell() {
            super(new GateComponentModels.LogicCellTopWireModel(), new GateComponentModels.LogicCellBottomWireModel());
            this.models.add(GateComponentModels.LogicCellBaseModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            super.prepareInventory(stack);
            this.wires[0].on = false;
            this.wires[1].on = true;
            this.torches[0].on = true;
            this.torches[1].on = false;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            super.prepare(gate);
            this.torches[0].on = gate.bottomSignal() == 0;
            this.torches[1].on = gate.bottomSignal() != 0;
            this.wires[0].on = gate.bottomSignal() != 0;
            this.wires[1].on = gate.bottomSignal() == 0;
        }
    }

    public static class RenderComparator
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("comparator", 4);
        private final GateComponentModels.RedstoneTorchModel torch = new GateComponentModels.RedstoneTorchModel(8.0, 2.0, 6);
        private final GateComponentModels.OnOffModel[] chips = new GateComponentModels.OnOffModel[]{new GateComponentModels.MinusChipModel(5.0, 8.0), new GateComponentModels.PlusChipModel(11.0, 8.0)};

        public RenderComparator() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.reflect = false;
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.chips[0].on = false;
            this.chips[1].on = false;
            this.torch.on = false;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.reflect = gate.shape() != 0;
            this.wires[0].on = (gate.state() & 0x10) == 0;
            this.wires[1].on = (gate.state() & 2) != 0;
            this.wires[2].on = (gate.state() & 4) != 0;
            this.wires[3].on = (gate.state() & 8) != 0;
            this.chips[0].on = (gate.state() & 1) != 0 && gate.shape() == 1;
            this.chips[1].on = (gate.state() & 1) != 0 && gate.shape() != 1;
            boolean bl = this.torch.on = (gate.state() & 0x10) != 0;
            if (gate.shape() != 0) {
                boolean a = this.wires[1].on;
                boolean b = this.wires[3].on;
                this.wires[3].on = a;
                this.wires[1].on = b;
            }
        }

        @Override
        protected void renderModels(CCRenderState ccrs, int orient, Transformation t) {
            super.renderModels(ccrs, orient, t);
            for (GateComponentModels.OnOffModel m : this.chips) {
                m.renderModel(t, orient % 24, ccrs);
            }
        }
    }

    public static class RenderANDCell
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.CellTopWireModel topWire = new GateComponentModels.AndCellTopWireModel();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("andcell", 2);
        private final GateComponentModels.OnOffModel[] torches = new GateComponentModels.OnOffModel[]{new GateComponentModels.RedstoneTorchModel(8.0, 13.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 2.0, 8), new GateComponentModels.FlippedRedstoneTorchModel(8.0, 10.0, 8.0, 5)};

        public RenderANDCell() {
            this.models.add(GateComponentModels.AndCellBaseModel.INSTANCE);
            this.models.add(this.topWire);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.topWire.signal = 0;
            this.topWire.conn = 0;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = true;
            this.wires[0].on = true;
            this.wires[1].on = false;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.topWire.signal = gate.topSignal();
            this.topWire.conn = gate.topSignalConnMask();
            this.torches[0].on = (gate.state() & 4) == 0;
            this.torches[1].on = (gate.state() & 0x10) != 0;
            this.torches[2].on = gate.topSignal() == 0;
            this.wires[0].on = this.torches[0].on || this.torches[2].on;
            this.wires[1].on = !this.torches[0].on;
        }
    }

    public static class RenderBusRandomizer
    extends GateRenderer {
        private final ArrayList<List<GateComponentModels.ComponentModel>> models = new ArrayList(2);
        private final GateComponentModels.WireModel[] wires1 = GateComponentModels.generateWireModels("busrand1", 2);
        private final GateComponentModels.WireModel[] wires2 = GateComponentModels.generateWireModels("busrand2", 2);
        private final GateComponentModels.SignalPanelModel panel = new GateComponentModels.SignalPanelModel(8.0, 8.0, 0);
        private int shape = 0;

        public RenderBusRandomizer() {
            LinkedList<GateComponentModels.ComponentModel> models0 = new LinkedList<GateComponentModels.ComponentModel>();
            models0.add(GateComponentModels.BaseComponentModel.INSTANCE);
            models0.add(GateComponentModels.BusRandCableModel.INSTANCE);
            models0.add(this.panel);
            models0.addAll(Arrays.asList(this.wires1));
            LinkedList<GateComponentModels.ComponentModel> models1 = new LinkedList<GateComponentModels.ComponentModel>();
            models1.add(GateComponentModels.BaseComponentModel.INSTANCE);
            models1.add(GateComponentModels.BusRandCableModel.INSTANCE);
            models1.add(this.panel);
            models1.addAll(Arrays.asList(this.wires2));
            this.models.add(models0);
            this.models.add(models1);
            this.panel.offColour = 1969815807;
            this.panel.onColour = -506068737;
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models.get(this.shape);
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.shape = 0;
            this.panel.signal = 0;
            this.panel.disableMask = 0;
            this.wires1[0].on = false;
            this.wires2[0].on = false;
            this.wires1[1].on = false;
            this.wires2[1].on = false;
        }

        @Override
        protected void prepare(IGateRenderData part) {
            this.shape = part.shape();
            this.panel.signal = part.bOutput0();
            this.panel.disableMask = ~part.bInput2();
            this.wires1[0].on = (part.state() & 2) != 0;
            this.wires2[0].on = (part.state() & 2) != 0;
            this.wires1[1].on = (part.state() & 8) != 0;
            this.wires2[1].on = (part.state() & 8) != 0;
        }
    }

    public static class RenderBusConverter
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("busconv", 3);
        private final GateComponentModels.SignalBarModel bar = new GateComponentModels.SignalBarModel(8.0, 8.0);

        public RenderBusConverter() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.add(GateComponentModels.BusConvCableModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.bar);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.bar.signal = 0;
            this.bar.inverted = false;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 0x20) != 0;
            this.wires[1].on = (gate.state() & 0x80) != 0;
            this.wires[2].on = gate.rsIO() != 0;
            this.bar.inverted = gate.shape() != 0;
            this.bar.signal = gate.rsIO();
        }
    }

    public static class RenderBusInputPanel
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("businput", 1);
        private final GateComponentModels.InputPanelButtonsModel buttons = new GateComponentModels.InputPanelButtonsModel();
        private final BlockPos.MutableBlockPos lightPos = new BlockPos.MutableBlockPos();

        public RenderBusInputPanel() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.add(GateComponentModels.BusInputPanelCableModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.buttons);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = false;
            this.buttons.pressMask = 0;
            this.lightPos.m_122178_(0, 0, 0);
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 1) != 0;
            this.buttons.pressMask = gate.bInput0();
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        protected void prepareDynamic(IGateRenderData gate, float partialFrame) {
            this.buttons.pressMask = gate.bInput0();
            this.lightPos.m_122190_((Vec3i)gate.worldPos());
        }

        @Override
        public void renderCustomDynamic(CCRenderState ccrs, Transformation t, PoseStack mStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float partialTicks) {
            this.buttons.renderLights(ccrs, (BlockPos)this.lightPos, mStack, buffers, t);
        }
    }

    public static class RenderTransparentLatchCell
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.CellTopWireModel topWire = new GateComponentModels.TransparentLatchCellTopWireModel();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("transparent-latch-cell", 5);
        private final GateComponentModels.OnOffModel[] torches = new GateComponentModels.OnOffModel[]{new GateComponentModels.RedstoneTorchModel(12.5, 12.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 12.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 8.0, 6), new GateComponentModels.RedstoneTorchModel(8.0, 2.0, 8)};

        public RenderTransparentLatchCell() {
            this.models.add(GateComponentModels.TransparentLatchCellBaseModel.INSTANCE);
            this.models.add(this.topWire);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.topWire.signal = 0;
            this.topWire.conn = 0;
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = true;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = true;
            this.torches[3].on = false;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            boolean on = (gate.state() & 0x10) != 0;
            this.topWire.signal = gate.topSignal();
            this.topWire.conn = gate.topSignalConnMask() & 0xFFFFFFFD;
            this.wires[0].on = !on;
            this.wires[1].on = gate.topSignal() != 0;
            this.wires[2].on = gate.topSignal() == 0;
            this.wires[3].on = on;
            this.wires[4].on = (gate.state() & 4) != 0;
            this.torches[0].on = this.wires[2].on;
            this.torches[1].on = !this.wires[2].on && !this.wires[4].on;
            this.torches[2].on = !this.wires[1].on && !this.wires[3].on;
            this.torches[3].on = on;
        }
    }

    public static class RenderSegmentDisplay
    extends GateRenderer {
        private final ArrayList<List<GateComponentModels.ComponentModel>> models = new ArrayList(2);
        private final GateComponentModels.SevenSegmentDisplayModel sevenSeg1 = new GateComponentModels.SevenSegmentDisplayModel(4.5, 8.0);
        private final GateComponentModels.SevenSegmentDisplayModel sevenSeg0 = new GateComponentModels.SevenSegmentDisplayModel(11.5, 8.0);
        private final GateComponentModels.SixteenSegmentDisplayModel sixteenSeg = new GateComponentModels.SixteenSegmentDisplayModel(8.0, 8.0);
        private int shape = 0;

        public RenderSegmentDisplay() {
            LinkedList<GateComponentModels.SingleComponentModel> models0 = new LinkedList<GateComponentModels.SingleComponentModel>();
            models0.add(GateComponentModels.BaseComponentModel.INSTANCE);
            models0.add(GateComponentModels.SegmentDisplayBusCableModel.INSTANCE);
            models0.add(this.sevenSeg1);
            models0.add(this.sevenSeg0);
            LinkedList<GateComponentModels.SingleComponentModel> models1 = new LinkedList<GateComponentModels.SingleComponentModel>();
            models1.add(GateComponentModels.BaseComponentModel.INSTANCE);
            models1.add(GateComponentModels.SegmentDisplayBusCableModel.INSTANCE);
            models1.add(this.sixteenSeg);
            this.models.add(models0);
            this.models.add(models1);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models.get(this.shape);
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.shape = 0;
            this.sevenSeg1.signal = 64;
            this.sevenSeg0.signal = 64;
            this.sixteenSeg.signal = 0;
            int c = EnumColour.RED.ordinal();
            this.sevenSeg0.setColourByIndex(c);
            this.sevenSeg1.setColourByIndex(c);
            this.sixteenSeg.setColourByIndex(c);
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.shape = gate.shape();
            this.sevenSeg1.signal = gate.bInput0() >> 8;
            this.sevenSeg0.signal = gate.bInput0() & 0xFF;
            this.sixteenSeg.signal = gate.bInput0();
            int c = gate.state();
            this.sevenSeg0.setColourByIndex(c);
            this.sevenSeg1.setColourByIndex(c);
            this.sixteenSeg.setColourByIndex(c);
        }
    }

    public static class RenderDecodingRandomizer
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("decrand", 6);
        private final GateComponentModels.RedstoneTorchModel[] torches = new GateComponentModels.RedstoneTorchModel[]{new GateComponentModels.RedstoneTorchModel(8.0, 2.5, 8), new GateComponentModels.RedstoneTorchModel(14.0, 8.0, 8), new GateComponentModels.RedstoneTorchModel(2.0, 8.0, 8), new GateComponentModels.RedstoneTorchModel(9.0, 8.0, 6)};
        private final GateComponentModels.OnOffModel[] chips = new GateComponentModels.OnOffModel[]{new GateComponentModels.YellowChipModel(5.0, 13.0), new GateComponentModels.YellowChipModel(11.0, 13.0), new GateComponentModels.RedChipModel(5.5, 8.0)};

        public RenderDecodingRandomizer() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
            this.models.addAll(Arrays.asList(this.chips));
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[4].on = true;
            this.wires[5].on = true;
            this.wires[0].disabled = false;
            this.wires[3].disabled = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = false;
            this.torches[3].on = false;
            this.chips[0].on = false;
            this.chips[1].on = true;
            this.chips[2].on = true;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            int state = gate.state();
            this.wires[0].on = state >> 4 == 2;
            this.wires[1].on = state >> 4 == 8;
            this.wires[2].on = (state & 4) != 0;
            this.wires[3].on = (state & 4) != 0;
            this.wires[4].on = state >> 4 == 1 || state >> 4 == 2;
            this.wires[5].on = state >> 4 == 1;
            this.wires[0].disabled = gate.shape() != 0;
            this.wires[3].disabled = gate.shape() != 0;
            this.torches[0].on = state >> 4 == 1;
            this.torches[1].on = state >> 4 == 2;
            this.torches[2].on = state >> 4 == 8;
            this.torches[3].on = !this.wires[4].on;
            this.chips[0].on = state >> 4 == 2;
            this.chips[1].on = state >> 4 == 1 || state >> 4 == 2;
            this.chips[2].on = true;
        }
    }

    public static class RenderFabricatedGate
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.SidedWireModel simpleWires = new GateComponentModels.SidedWireModel(GateComponentModels.generateWireModels("ic1", 4));
        private final GateComponentModels.SidedWireModel analogWires = new GateComponentModels.SidedWireModel(GateComponentModels.generateWireModels("ic2", 4));
        private final GateComponentModels.SidedICBundledCableModel bundledWires = new GateComponentModels.SidedICBundledCableModel();
        private final GateComponentModels.FabricatedICModel icHousing = GateComponentModels.FabricatedICModel.INSTANCE;
        public static final String KEY_FORMAT = "format";
        public static final String KEY_ACTIVE = "active";
        public static final String KEY_IC_NAME = "ic_name";
        public static final String KEY_TILE_MAP = "tile_map";
        public static final String KEY_IS_BUILT = "is_built";
        public static final String KEY_IO_SPEC = "io_spec";
        public static final String KEY_COMP_STATE = "state";
        public static final String KEY_FLAT_MAP = "flat_map";
        public static final String KEY_SIMULATION = "sim_cont";
        public static final String KEY_COMPILER_LOG = "compiler_log";
        private boolean runtimeError = false;
        private String name = "untitled";

        public static boolean hasFabricationTarget(@Nullable CompoundTag tag) {
            return tag != null && tag.m_128441_(KEY_IS_BUILT) && tag.m_128441_(KEY_FLAT_MAP);
        }

        public RenderFabricatedGate() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.add(this.simpleWires);
            this.models.add(this.analogWires);
            this.models.add(this.bundledWires);
            this.models.add(this.icHousing);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            if (stack == null || !RenderFabricatedGate.hasFabricationTarget(stack.m_41783_())) {
                this.runtimeError = true;
                this.name = "ERROR!";
                this.simpleWires.sidemask = 0;
                this.analogWires.sidemask = 0;
                this.bundledWires.sidemask = 0;
                return;
            }
            this.runtimeError = false;
            CompoundTag tag = stack.m_41783_();
            this.name = tag.m_128461_(KEY_IC_NAME);
            CompoundTag ifspecTag = tag.m_128469_(KEY_IO_SPEC);
            byte rMask = ifspecTag.m_128445_("rmask");
            int aMask = 0;
            byte bMask = ifspecTag.m_128445_("bmask");
            this.simpleWires.sidemask = rMask & 0xF | rMask >> 4 & 0xF;
            this.analogWires.sidemask = aMask;
            this.bundledWires.sidemask = bMask & 0xF | bMask >> 4 & 0xF;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.simpleWires.sidemask = gate.state2() & 0xF;
            this.analogWires.sidemask = gate.state2() >> 4 & 0xF;
            this.bundledWires.sidemask = gate.state2() >> 8 & 0xF;
            this.simpleWires.wires[0].on = (gate.state() & 0x11) != 0;
            this.simpleWires.wires[1].on = (gate.state() & 0x22) != 0;
            this.simpleWires.wires[2].on = (gate.state() & 0x44) != 0;
            this.simpleWires.wires[3].on = (gate.state() & 0x88) != 0;
            this.analogWires.wires[0].on = this.simpleWires.wires[0].on;
            this.analogWires.wires[1].on = this.simpleWires.wires[1].on;
            this.analogWires.wires[2].on = this.simpleWires.wires[2].on;
            this.analogWires.wires[3].on = this.simpleWires.wires[3].on;
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        protected void prepareDynamic(IGateRenderData gate, float partialFrame) {
            this.runtimeError = gate.hasRuntimeError();
            this.name = gate.getGateName();
        }

        @Override
        public void renderDynamic(CCRenderState ccrs, Transformation t) {
        }

        @Override
        public void renderCustomDynamic(CCRenderState ccrs, Transformation t, PoseStack mStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float partialTicks) {
            this.icHousing.renderName(this.name, mStack, t, this.runtimeError ? EnumColour.RED.argb() : EnumColour.WHITE.argb());
            ccrs.reset();
            ccrs.brightness = packedLight;
            ccrs.overlay = packedOverlay;
            ccrs.bind((VertexConsumer)new TransformingVertexConsumer(buffers.m_6299_(RenderType.m_110469_()), mStack), DefaultVertexFormat.f_85811_);
            this.icHousing.renderGlass(t, ccrs);
        }
    }

    public static class RenderIOGate
    extends GateRenderer {
        private final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        private final GateComponentModels.WireModel[] wires = GateComponentModels.generateWireModels("fabio", 1);
        private final GateComponentModels.IOCrimpWireModel crimpWire = new GateComponentModels.IOCrimpWireModel();
        private final GateComponentModels.IOCrimpColourBoxModel colourBox = new GateComponentModels.IOCrimpColourBoxModel(3.0, 10.5);

        public RenderIOGate() {
            this.models.add(GateComponentModels.BaseComponentModel.INSTANCE);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(GateComponentModels.IOCrimpConnectorModel.INSTANCE);
            this.models.add(this.crimpWire);
            this.models.add(this.colourBox);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.crimpWire.signal = 0;
            this.colourBox.colour = 0;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.wires[0].on = (gate.state() & 0x44) != 0;
            this.crimpWire.signal = (byte)(this.wires[0].on ? 255 : 0);
            this.colourBox.colour = gate.state2() & 0xF;
            this.colourBox.isInput = gate.shape() == 0;
        }
    }

    public static abstract class RenderArrayCell
    extends GateRenderer {
        protected final List<GateComponentModels.ComponentModel> models = new LinkedList<GateComponentModels.ComponentModel>();
        protected final GateComponentModels.CellTopWireModel topWire;
        protected final GateComponentModels.CellBottomWireModel bottomWire;

        public RenderArrayCell(GateComponentModels.CellTopWireModel topWire, GateComponentModels.CellBottomWireModel bottomWire) {
            this.topWire = topWire;
            this.bottomWire = bottomWire;
            this.models.add(topWire);
            this.models.add(bottomWire);
        }

        @Override
        protected List<GateComponentModels.ComponentModel> getModels() {
            return this.models;
        }

        @Override
        protected void prepareInventory(@Nullable ItemStack stack) {
            this.bottomWire.signal = 0;
            this.topWire.signal = 0;
            this.topWire.conn = 0;
        }

        @Override
        protected void prepare(IGateRenderData gate) {
            this.bottomWire.signal = gate.bottomSignal();
            this.topWire.signal = gate.topSignal();
            this.topWire.conn = gate.topSignalConnMask();
        }
    }
}

