/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration.gui.screen;

import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.multipart.api.part.MultiPart;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import mrtjp.projectred.integration.IntegrationNetwork;
import mrtjp.projectred.integration.part.ComplexGatePart;
import mrtjp.projectred.integration.part.GatePart;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.ButtonNode;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.RedUIScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CounterScreen
extends RedUIScreen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("projectred_integration", "textures/gui/counter_gate.png");
    private final GatePart gate;
    private final ComplexGatePart.ICounterGuiLogic counterGate;

    public CounterScreen(GatePart gate) {
        super(256, 145, (Component)Component.m_237115_((String)gate.getType().getRegistryName().toString()));
        this.gate = gate;
        this.counterGate = (ComplexGatePart.ICounterGuiLogic)((Object)gate);
        for (int row = 0; row < 3; ++row) {
            int y = 16 + 40 * row;
            this.createButton(5, y, 40, 20, row, -10);
            this.createButton(46, y, 40, 20, row, -5);
            this.createButton(87, y, 40, 20, row, -1);
            this.createButton(129, y, 40, 20, row, 1);
            this.createButton(170, y, 40, 20, row, 5);
            this.createButton(211, y, 40, 20, row, 10);
        }
    }

    private void createButton(int x, int y, int w, int h, int id, int delta) {
        ButtonNode b = new ButtonNode();
        b.setPosition(x, y);
        b.setSize(w, h);
        b.setButtonText((delta < 0 ? "" : "+") + delta);
        b.setClickFunction(() -> {
            PacketCustom packet = new PacketCustom(IntegrationNetwork.NET_CHANNEL, 4);
            IntegrationNetwork.writePartIndex((MCDataOutput)packet, (MultiPart)this.gate);
            packet.writeByte(id);
            packet.writeShort(delta);
            packet.sendToServer();
        });
        this.addChild((RedUINode)b);
    }

    public void drawBack(PoseStack stack, Point mouse, float partialFrame) {
        super.drawBack(stack, mouse, partialFrame);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int x = this.getFrame().x();
        int y = this.getFrame().y();
        int w = this.getFrame().width();
        this.m_93228_(stack, x, y, 0, 0, this.getFrame().width(), this.getFrame().height());
        String s = "Maximum: " + this.counterGate.getCounterMax();
        this.getFontRenderer().m_92883_(stack, s, (float)x + (float)(w - this.getFontRenderer().m_92895_(s)) / 2.0f, (float)(y + 5), 0x404040);
        s = "Increment: " + this.counterGate.getCounterIncr();
        this.getFontRenderer().m_92883_(stack, s, (float)x + (float)(w - this.getFontRenderer().m_92895_(s)) / 2.0f, (float)(y + 45), 0x404040);
        s = "Decrement: " + this.counterGate.getCounterDecr();
        this.getFontRenderer().m_92883_(stack, s, (float)x + (float)(w - this.getFontRenderer().m_92895_(s)) / 2.0f, (float)(y + 85), 0x404040);
        s = "State: " + this.counterGate.getCounterValue();
        this.getFontRenderer().m_92883_(stack, s, (float)x + (float)(w - this.getFontRenderer().m_92895_(s)) / 2.0f, (float)(y + 125), 0x404040);
    }

    public void update() {
        if (!this.gate.hasTile()) {
            Objects.requireNonNull(this.getMinecraft().f_91074_).m_6915_();
        }
    }
}

