/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.BlockMultipart;
import codechicken.multipart.util.MultipartPlaceContext;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.FaceLookup;
import mrtjp.projectred.core.RedstoneFaceLookup;
import mrtjp.projectred.core.RedstonePropagator;
import mrtjp.projectred.core.part.IOrientableFacePart;
import mrtjp.projectred.core.part.IPropagationFacePart;
import mrtjp.projectred.core.part.IPropagationPart;
import mrtjp.projectred.core.part.IRedstonePropagationPart;
import mrtjp.projectred.core.part.IRedwirePart;
import mrtjp.projectred.integration.GateType;
import mrtjp.projectred.integration.part.GatePart;
import mrtjp.projectred.integration.part.RedstoneGatePart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ArrayGatePart
extends RedstoneGatePart
implements IRedwirePart,
IPropagationFacePart,
IRedstonePropagationPart {
    private int propagationMask = 15;

    public ArrayGatePart(GateType type) {
        super(type);
    }

    public int getPropagationMask() {
        return this.propagationMask;
    }

    public int getSignal() {
        return this.getSignal(this.toInternalMask(this.propagationMask));
    }

    public void setSignal(int signal) {
        this.setSignal(this.toInternalMask(this.propagationMask), signal);
    }

    public void updateAndPropagate(@Nullable IPropagationPart prev, int mode) {
        int rd = this.sideDiff(prev);
        int uMask = 0;
        for (int r = 0; r < 4; ++r) {
            int pMask;
            if ((rd & 1 << r) == 0 || (pMask = this.propagationMask(this.toInternal(r))) <= 0 || (pMask & uMask) == pMask) continue;
            this.propagationMask = this.toAbsoluteMask(pMask);
            super.updateAndPropagate(prev, mode);
            uMask |= pMask;
        }
        if (uMask == 0) {
            BlockPos prevPos = prev instanceof MultiPart ? ((MultiPart)prev).pos() : this.pos();
            RedstonePropagator.addNeighborChange((Level)this.level(), (BlockPos)prevPos, (BlockPos)this.pos());
        }
        this.propagationMask = 15;
    }

    public void propagateOther(int mode) {
        int nonConn = ~(this.getConnMap() | this.getConnMap() >> 4 | this.getConnMap() >> 8) & 0xF;
        this.notifyExternals(nonConn & this.propagationMask);
    }

    private int sideDiff(@Nullable IPropagationPart p) {
        BlockPos diff;
        if (!(p instanceof MultiPart)) {
            return 15;
        }
        MultiPart part = (MultiPart)p;
        if (!(p instanceof IOrientableFacePart)) {
            return 15;
        }
        IOrientableFacePart facePart = (IOrientableFacePart)p;
        BlockPos here = this.pos();
        BlockPos there = part.pos();
        if (here.equals((Object)there) && (this.getSide() & 6) != (facePart.getSide() & 6)) {
            return 1 << Rotation.rotationTo((int)this.getSide(), (int)facePart.getSide());
        }
        if (this.getSide() != facePart.getSide()) {
            there = there.m_121945_(Direction.values()[this.getSide() ^ 1]);
        }
        if ((diff = there.m_121996_((Vec3i)here)).m_123341_() == 0 && diff.m_123342_() == 1 && diff.m_123343_() == 0) {
            return 1 << Rotation.rotationTo((int)this.getSide(), (int)0);
        }
        if (diff.m_123341_() == 0 && diff.m_123342_() == -1 && diff.m_123343_() == 0) {
            return 1 << Rotation.rotationTo((int)this.getSide(), (int)1);
        }
        if (diff.m_123341_() == 0 && diff.m_123342_() == 0 && diff.m_123343_() == 1) {
            return 1 << Rotation.rotationTo((int)this.getSide(), (int)2);
        }
        if (diff.m_123341_() == 0 && diff.m_123342_() == 0 && diff.m_123343_() == -1) {
            return 1 << Rotation.rotationTo((int)this.getSide(), (int)3);
        }
        if (diff.m_123341_() == 1 && diff.m_123342_() == 0 && diff.m_123343_() == 0) {
            return 1 << Rotation.rotationTo((int)this.getSide(), (int)4);
        }
        if (diff.m_123341_() == -1 && diff.m_123342_() == 0 && diff.m_123343_() == 0) {
            return 1 << Rotation.rotationTo((int)this.getSide(), (int)5);
        }
        throw new RuntimeException("Propagating to distant part from " + here + " to " + there + "!?");
    }

    public int calculateSignal() {
        int ipmask = this.toInternalMask(this.propagationMask);
        if (this.overrideSignal(ipmask)) {
            return this.calculateSignal(ipmask);
        }
        RedstonePropagator.setDustProvidesPower((boolean)false);
        RedstonePropagator.setRedwiresProvidePower((boolean)false);
        int signal = 0;
        for (int r = 0; r < 4; ++r) {
            int s;
            if ((this.propagationMask & 1 << r) == 0) continue;
            if (this.maskConnectsCorner(r)) {
                lookup = FaceLookup.lookupCorner((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
                s = RedstoneFaceLookup.resolveSignal((FaceLookup)lookup, (boolean)true);
            } else if (this.maskConnectsStraight(r)) {
                lookup = FaceLookup.lookupStraight((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
                s = RedstoneFaceLookup.resolveSignal((FaceLookup)lookup, (boolean)true);
                if (s == 0) {
                    s = RedstoneFaceLookup.resolveVanillaSignal((FaceLookup)lookup, (MultiPart)this, (boolean)true, (boolean)true);
                }
            } else if (this.maskConnectsInside(r)) {
                lookup = FaceLookup.lookupInsideFace((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
                s = RedstoneFaceLookup.resolveSignal((FaceLookup)lookup, (boolean)true);
            } else {
                lookup = FaceLookup.lookupStraight((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
                s = RedstoneFaceLookup.resolveVanillaSignal((FaceLookup)lookup, (MultiPart)this, (boolean)true, (boolean)true);
            }
            signal = Math.max(s, signal);
        }
        RedstonePropagator.setDustProvidesPower((boolean)true);
        RedstonePropagator.setRedwiresProvidePower((boolean)true);
        return signal;
    }

    public void onSignalUpdate() {
        this.tile().m_6596_();
        super.onChange();
    }

    public int getRedwireSignal(int r) {
        int ir = this.toInternal(r);
        int pmask = this.propagationMask(ir);
        return pmask != 0 ? this.getSignal(pmask) : this.getOutput(ir) * 17;
    }

    public boolean diminishOnSide(int r) {
        return (this.redwireMask(this.shape()) & 1 << this.toInternal(r)) != 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        if (super.canConnectRedstone(side)) {
            return true;
        }
        if ((side & 6) == (this.getSide() & 6)) {
            return false;
        }
        return this.canConnectRedwire(this.toInternal(this.absoluteRot(side)));
    }

    protected int rsLevel(int i) {
        return RedstonePropagator.canRedwiresProvidePower() ? (i + 16) / 17 : 0;
    }

    @Override
    public int weakPowerLevel(int side) {
        if ((side & 6) == (this.getSide() & 6)) {
            return 0;
        }
        int ir = this.toInternal(this.absoluteRot(side));
        if ((this.redwireMask(this.shape()) & 1 << ir) != 0) {
            return this.rsLevel(this.getSignal(this.propagationMask(ir)));
        }
        return super.weakPowerLevel(side);
    }

    @Override
    public boolean preparePlacement(MultipartPlaceContext context) {
        ArrayGatePart part;
        MultiPart tpart;
        if (!super.preparePlacement(context)) {
            return false;
        }
        if (this.canCross() && context.m_43723_() != null && (tpart = BlockMultipart.getPart((BlockGetter)context.m_43723_().m_9236_(), (BlockPos)context.m_8083_(), (int)(this.getSide() ^ 1))) instanceof ArrayGatePart && (part = (ArrayGatePart)tpart).getGateType() == this.getGateType() && (part.getRotation() & 1) == (this.getRotation() & 1)) {
            this.setRotation((this.getRotation() + 1) % 4);
        }
        return true;
    }

    public boolean occlusionTest(MultiPart npart) {
        ArrayGatePart part;
        if (npart instanceof ArrayGatePart && (part = (ArrayGatePart)npart).getGateType() == this.getGateType() && part.getSide() == (this.getSide() ^ 1) && (part.getRotation() & 1) != (this.getRotation() & 1)) {
            return true;
        }
        return super.occlusionTest(npart);
    }

    @Override
    protected void rotate() {
        int r = this.getRotation();
        this.setRotation((r + 1) % 4);
        boolean b = this.tile().canReplacePart((MultiPart)this, (MultiPart)this);
        this.setRotation(r);
        if (b) {
            super.rotate();
        }
    }

    protected boolean canCross() {
        return false;
    }

    @Override
    protected boolean gateLogicCanConnectTo(IConnectable part, int r) {
        if (part instanceof IRedwirePart && this.canConnectRedwire(r)) {
            return true;
        }
        return super.gateLogicCanConnectTo(part, r);
    }

    @Override
    protected void onChange() {
        super.onChange();
        RedstonePropagator.propagateTo((IPropagationPart)this, (int)0);
    }

    protected boolean canConnectRedwire(int r) {
        return (this.redwireMask(r) & 1 << r) != 0;
    }

    protected abstract int redwireMask(int var1);

    protected abstract int propagationMask(int var1);

    protected abstract int getSignal(int var1);

    protected abstract void setSignal(int var1, int var2);

    protected boolean overrideSignal(int mask) {
        return false;
    }

    protected int calculateSignal(int mask) {
        return 0;
    }

    public static class TransparentLatchCell
    extends SimpleTopWireArrayGate {
        public TransparentLatchCell(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 1;
        }

        @Override
        protected int inputMask(int shape) {
            return 4;
        }

        @Override
        protected int calcOutput(int input) {
            return (input & 0xA) == 0 ? this.state() >> 4 : ((input & 4) == 0 ? 0 : 1);
        }
    }

    public static class ANDCell
    extends SimpleTopWireArrayGate {
        public ANDCell(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 1;
        }

        @Override
        protected int inputMask(int shape) {
            return 4;
        }

        @Override
        protected int calcOutput(int input) {
            return (input & 4) != 0 && (input & 0xA) != 0 ? 1 : 0;
        }
    }

    public static class SimpleTopWireArrayGate
    extends TopWireArrayGate {
        public SimpleTopWireArrayGate(GateType type) {
            super(type);
        }

        @Override
        protected void gateLogicOnChange() {
            int newOutput;
            int newInput;
            int iMask = this.inputMask(this.shape());
            int rMask = this.redwireMask(this.shape());
            int oMask = this.outputMask(this.shape());
            int fMask = this.feedbackMask(this.shape());
            int oldInput = this.getState() & 0xF;
            if (oldInput != (newInput = this.getInput(iMask | fMask) | this.getRedwireInput(rMask))) {
                this.setState(this.getState() & 0xF0 | newInput);
                this.onInputChange();
            }
            if ((newOutput = this.calcOutput(this.state() & (iMask | rMask)) & oMask) != this.state() >> 4) {
                this.scheduleTick(this.getDelay(this.shape()));
            }
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            int newOutput;
            int iMask = this.inputMask(this.shape());
            int rMask = this.redwireMask(this.shape());
            int oMask = this.outputMask(this.shape());
            int oldOutput = this.state() >> 4;
            if (oldOutput != (newOutput = this.calcOutput(this.state() & (iMask | rMask)) & oMask)) {
                this.setState(this.state() & 0xF | newOutput << 4);
                this.onOutputChange(oMask);
            }
            this.gateLogicOnChange();
        }

        @Override
        protected void gateLogicSetup() {
            int iMask = this.inputMask(this.shape());
            int rMask = this.redwireMask(this.shape());
            int oMask = this.outputMask(this.shape());
            int input = this.getInput(iMask) | this.getRedwireInput(rMask);
            int output = this.calcOutput(input) & oMask;
            if (output != 0) {
                this.setState(output << 4);
                this.onOutputChange(output);
            }
        }

        protected int getDelay(int shape) {
            return 2;
        }

        protected int feedbackMask(int shape) {
            return 0;
        }

        protected int getRedwireInput(int mask) {
            return this.getSignal(mask) != 0 ? mask : 0;
        }

        protected int calcOutput(int input) {
            return 0;
        }
    }

    public static abstract class TopWireArrayGate
    extends ArrayGatePart
    implements IGateWireRenderConnect {
        private static final int KEY_SIGNAL = 20;
        private byte signal = 0;

        public TopWireArrayGate(GateType type) {
            super(type);
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.m_128344_("signal", this.signal);
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.signal = tag.m_128445_("signal");
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            super.writeDesc(packet);
            packet.writeByte((int)this.signal);
        }

        @Override
        public void readDesc(MCDataInput packet) {
            super.readDesc(packet);
            this.signal = packet.readByte();
        }

        @Override
        protected void read(MCDataInput packet, int key) {
            switch (key) {
                case 20: {
                    this.signal = packet.readByte();
                    if (!Configurator.staticGates) break;
                    this.tile().markRender();
                    break;
                }
                default: {
                    super.read(packet, key);
                }
            }
        }

        protected void sendSignalUpdate() {
            this.sendUpdate(20, w -> w.writeByte((int)this.signal));
        }

        @Override
        public VoxelShape getCollisionShape(CollisionContext context) {
            return ArrayGatePartCrossing.cShapes[this.getSide()];
        }

        @Override
        public VoxelShape getShape(CollisionContext context) {
            return this.getCollisionShape(context);
        }

        @Override
        public VoxelShape getOcclusionShape() {
            return ArrayGatePartCrossing.oShapes[this.getSide()];
        }

        @Override
        public void onSignalUpdate() {
            super.onSignalUpdate();
            this.sendSignalUpdate();
        }

        @Override
        public byte topSignal() {
            return this.signal;
        }

        @Override
        public int topSignalConnMask() {
            return IGateWireRenderConnect.getConnsAtHeight(this, 10.0);
        }

        @Override
        public int renderConnectMask() {
            return 10;
        }

        @Override
        public double getHeight(int r) {
            return 10.0;
        }

        @Override
        protected int redwireMask(int shape) {
            return 10;
        }

        @Override
        protected int propagationMask(int r) {
            return r % 2 == 1 ? 10 : 0;
        }

        @Override
        protected int getSignal(int mask) {
            return mask == 10 ? this.signal & 0xFF : 0;
        }

        @Override
        protected void setSignal(int mask, int signal) {
            if (mask == 10) {
                this.signal = (byte)signal;
            }
        }
    }

    public static class BufferCell
    extends ArrayGatePartCrossing {
        public BufferCell(GateType type) {
            super(type);
        }

        @Override
        protected boolean powerUp() {
            return (this.state() & 2) == 0;
        }
    }

    public static class InvertCell
    extends ArrayGatePartCrossing {
        public InvertCell(GateType type) {
            super(type);
        }

        @Override
        protected boolean powerUp() {
            return (this.state() & 2) != 0;
        }
    }

    public static class NullCell
    extends ArrayGatePartCrossing {
        public NullCell(GateType type) {
            super(type);
        }

        @Override
        protected boolean canCross() {
            return true;
        }

        @Override
        public int getLightEmission() {
            return 0;
        }
    }

    public static abstract class ArrayGatePartCrossing
    extends ArrayGatePart
    implements IGateWireRenderConnect {
        private static final Cuboid6[][] oBoxes = new Cuboid6[6][2];
        private static final Cuboid6[] cBoxes = new Cuboid6[6];
        private static final VoxelShape[] oShapes = new VoxelShape[6];
        private static final VoxelShape[] cShapes = new VoxelShape[6];
        private static final int KEY_SIGNAL = 20;
        private byte signal1 = 0;
        private byte signal2 = 0;

        public ArrayGatePartCrossing(GateType type) {
            super(type);
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.m_128344_("s1", this.signal1);
            tag.m_128344_("s2", this.signal2);
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.signal1 = tag.m_128445_("s1");
            this.signal2 = tag.m_128445_("s2");
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            super.writeDesc(packet);
            packet.writeByte((int)this.signal1);
            packet.writeByte((int)this.signal2);
        }

        @Override
        public void readDesc(MCDataInput packet) {
            super.readDesc(packet);
            this.signal1 = packet.readByte();
            this.signal2 = packet.readByte();
        }

        @Override
        protected void read(MCDataInput packet, int key) {
            switch (key) {
                case 20: {
                    this.signal1 = packet.readByte();
                    this.signal2 = packet.readByte();
                    if (!Configurator.staticGates) break;
                    this.tile().markRender();
                    break;
                }
                default: {
                    super.read(packet, key);
                }
            }
        }

        protected void sendSignalUpdate() {
            this.sendUpdate(20, w -> w.writeByte((int)this.signal1).writeByte((int)this.signal2));
        }

        @Override
        public VoxelShape getCollisionShape(CollisionContext context) {
            return cShapes[this.getSide()];
        }

        @Override
        public VoxelShape getShape(CollisionContext context) {
            return this.getCollisionShape(context);
        }

        @Override
        public VoxelShape getOcclusionShape() {
            return oShapes[this.getSide()];
        }

        @Override
        public byte bottomSignal() {
            return this.signal1;
        }

        @Override
        public byte topSignal() {
            return this.signal2;
        }

        @Override
        public int topSignalConnMask() {
            return IGateWireRenderConnect.getConnsAtHeight(this, 10.0);
        }

        @Override
        protected int redwireMask(int shape) {
            return 15;
        }

        @Override
        protected int propagationMask(int r) {
            return r % 2 == 0 ? 5 : 10;
        }

        @Override
        protected int outputMask(int shape) {
            return 15;
        }

        @Override
        protected int inputMask(int shape) {
            return 15;
        }

        @Override
        public int renderConnectMask() {
            return 10;
        }

        @Override
        public double getHeight(int r) {
            return 10.0;
        }

        @Override
        protected int getSignal(int mask) {
            return (mask == 5 ? this.signal1 : this.signal2) & 0xFF;
        }

        @Override
        protected void setSignal(int mask, int signal) {
            if (mask == 5) {
                this.signal1 = (byte)signal;
            } else {
                this.signal2 = (byte)signal;
            }
        }

        @Override
        public void onSignalUpdate() {
            super.onSignalUpdate();
            this.sendSignalUpdate();
        }

        @Override
        protected void gateLogicOnChange() {
            boolean newSignal;
            boolean oldSignal = (this.state() & 1) != 0;
            boolean bl = newSignal = this.signal1 != 0;
            if (oldSignal != newSignal) {
                this.setState(this.state() & 2 | (newSignal ? 1 : 0));
                this.onInputChange();
                this.scheduleTick(2);
            }
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            boolean newOutput;
            boolean input = (this.state() & 1) != 0;
            boolean oldOutput = (this.state() & 2) != 0;
            boolean bl = newOutput = !input;
            if (oldOutput != newOutput) {
                this.setState(this.state() & 1 | (newOutput ? 2 : 0));
                this.onOutputChange(0);
                this.onChange();
            }
        }

        @Override
        public int calculateSignal(int mask) {
            return 255;
        }

        @Override
        protected boolean overrideSignal(int mask) {
            return mask == 10 && this.powerUp();
        }

        protected boolean powerUp() {
            return false;
        }

        static {
            for (int s = 0; s < 6; ++s) {
                Cuboid6 occlusion1 = new Cuboid6(0.125, 0.0, 0.0, 0.875, 0.75, 1.0);
                Cuboid6 occlusion2 = new Cuboid6(0.0, 0.0, 0.125, 1.0, 0.75, 0.875);
                Cuboid6 collision = new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
                Transformation t = Rotation.sideRotations[s].at(Vector3.CENTER);
                ArrayGatePartCrossing.oBoxes[s][0] = occlusion1.apply(t);
                ArrayGatePartCrossing.oBoxes[s][1] = occlusion2.apply(t);
                ArrayGatePartCrossing.cBoxes[s] = collision.apply(t);
                ImmutableSet.Builder builder = ImmutableSet.builder();
                builder.add((Object)VoxelShapeCache.getShape((Cuboid6)oBoxes[s][0]));
                builder.add((Object)VoxelShapeCache.getShape((Cuboid6)oBoxes[s][1]));
                ArrayGatePartCrossing.oShapes[s] = VoxelShapeCache.merge((ImmutableSet)builder.build());
                ArrayGatePartCrossing.cShapes[s] = VoxelShapeCache.getShape((Cuboid6)cBoxes[s]);
            }
        }
    }

    public static interface IGateWireRenderConnect {
        public int renderConnectMask();

        public double getHeight(int var1);

        public static int getConnsAtHeight(GatePart gate, double h) {
            int conn = 0;
            for (int r = 0; r < 4; ++r) {
                if (IGateWireRenderConnect.getConnHeight(gate, r) != h) continue;
                conn |= 1 << r;
            }
            return gate.toInternalMask(conn);
        }

        public static double getConnHeight(GatePart gate, int r) {
            IConnectable part = gate.getStraight(r);
            if (part instanceof IGateWireRenderConnect) {
                IGateWireRenderConnect gConn = (IGateWireRenderConnect)part;
                if (part instanceof GatePart) {
                    GatePart gPart = (GatePart)part;
                    int ir = gPart.toInternal(gate.rotFromStraight(r));
                    if ((gConn.renderConnectMask() & 1 << ir) != 0) {
                        return gConn.getHeight(ir);
                    }
                }
            }
            return -1.0;
        }
    }
}

