/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NeighborTileChangePart;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.List;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.part.IOrientableFacePart;
import mrtjp.projectred.integration.GateType;
import mrtjp.projectred.integration.IntegrationNetwork;
import mrtjp.projectred.integration.part.GatePart;
import mrtjp.projectred.integration.part.RedstoneGatePart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public abstract class ComplexGatePart
extends RedstoneGatePart {
    public static final int KEY_STATE2 = 20;
    private byte state2 = 0;

    public ComplexGatePart(GateType type) {
        super(type);
    }

    @Override
    public int state2() {
        return this.state2 & 0xFF;
    }

    public void setState2(int state2) {
        this.state2 = (byte)state2;
    }

    protected boolean clientNeedsState2() {
        return false;
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128344_("state2", this.state2);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.state2 = tag.m_128445_("state2");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        if (this.clientNeedsState2()) {
            packet.writeByte((int)this.state2);
        }
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        if (this.clientNeedsState2()) {
            this.state2 = packet.readByte();
        }
    }

    @Override
    protected void read(MCDataInput packet, int key) {
        switch (key) {
            case 20: {
                this.state2 = packet.readByte();
                break;
            }
            default: {
                super.read(packet, key);
            }
        }
    }

    protected void sendState2Update() {
        this.sendUpdate(20, w -> w.writeByte((int)this.state2));
    }

    public static class Comparator
    extends RedstoneGatePart
    implements NeighborTileChangePart {
        private short lState2 = 0;

        public Comparator(GateType type) {
            super(type);
        }

        @Override
        public int state2() {
            return this.lState2;
        }

        public void setState2(int state2) {
            this.lState2 = (short)state2;
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.m_128376_("state2", this.lState2);
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.lState2 = tag.m_128448_("state2");
        }

        @Override
        protected int outputMask(int shape) {
            return 1;
        }

        @Override
        protected int inputMask(int shape) {
            return 14;
        }

        @Override
        protected boolean gateLogicCycleShape() {
            this.setShape(this.shape() == 0 ? 1 : 0);
            return true;
        }

        @Override
        protected int getOutput(int r) {
            return r == 0 ? this.state2() & 0xF : 0;
        }

        private int calcBottomComparatorInput() {
            Direction absDir = Direction.values()[Rotation.rotateSide((int)this.getSide(), (int)this.toAbsolute(2))];
            BlockPos pos1 = this.tile().m_58899_().m_121945_(absDir);
            BlockState state1 = this.level().m_8055_(pos1);
            int i = this.getDiodeSignal(2);
            if (state1.m_60807_()) {
                i = state1.m_60674_(this.level(), pos1);
            } else if (i < 15 && state1.m_60796_((BlockGetter)this.level(), pos1)) {
                ItemFrame entityitemframe;
                BlockPos pos2 = pos1.m_121945_(absDir);
                BlockState state2 = this.level().m_8055_(pos2);
                if (state2.m_60807_()) {
                    i = Math.max(state2.m_60674_(this.level(), pos2), i);
                }
                if ((entityitemframe = this.getItemFrame(this.level(), absDir, pos2)) != null) {
                    i = Math.max(entityitemframe.m_31824_(), i);
                }
            }
            return i;
        }

        private int getDiodeSignal(int r) {
            Direction absDir = Direction.values()[Rotation.rotateSide((int)this.getSide(), (int)this.toAbsolute(r))];
            BlockPos pos = this.tile().m_58899_().m_121945_(absDir);
            BlockState state = this.level().m_8055_(pos);
            int i = this.level().m_46681_(pos, absDir);
            if (i >= 15) {
                return i;
            }
            if (state.m_60713_(Blocks.f_50088_)) {
                i = Math.max(i, (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_));
            }
            return i;
        }

        @Nullable
        private ItemFrame getItemFrame(Level world, Direction facing, BlockPos pos) {
            List list = world.m_6443_(ItemFrame.class, new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)), p_210304_1_ -> p_210304_1_ != null && p_210304_1_.m_6350_() == facing);
            return list.size() == 1 ? (ItemFrame)list.get(0) : null;
        }

        private int calcAnalogInputMask() {
            return this.getAnalogRedstoneInput(1) << 4 | this.calcBottomComparatorInput() << 8 | this.getAnalogRedstoneInput(3) << 12;
        }

        private int digitize(int analog) {
            int digital = 0;
            for (int i = 0; i < 4; ++i) {
                if ((analog >> i * 4 & 0xF) <= 0) continue;
                digital |= 1 << i;
            }
            return digital;
        }

        @Override
        protected void gateLogicOnChange() {
            int newInput;
            int oldInput = this.state2() & 0xFFF0;
            if (oldInput != (newInput = this.calcAnalogInputMask())) {
                this.setState2(this.state2() & 0xF | newInput);
                this.setState(this.state() & 0xF0 | this.digitize(newInput));
                this.onInputChange();
            }
            if ((this.state2() & 0xF) != this.calcOutput()) {
                this.scheduleTick(2);
            }
        }

        private int calcOutput() {
            int backInput = this.state2() >> 8 & 0xF;
            int lrMaxInput = Math.max(this.state2() >> 4 & 0xF, this.state2() >> 12 & 0xF);
            return this.shape() == 0 ? (backInput > lrMaxInput ? backInput : 0) : Math.max(backInput - lrMaxInput, 0);
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            int newOutput;
            int oldOutput = this.state2() & 0xF;
            if (oldOutput != (newOutput = this.calcOutput())) {
                this.setState2(this.state2() & 0xFFF0 | newOutput);
                this.setState(this.state() & 0xF | (newOutput != 0 ? 16 : 0));
                this.onOutputChange(1);
            }
        }

        public void onNeighborTileChanged(Direction side, boolean weak) {
            if (side.ordinal() == Rotation.rotateSide((int)this.getSide(), (int)this.toAbsolute(2))) {
                this.onChange();
            }
        }

        public boolean weakTileChanges() {
            return true;
        }
    }

    public static class Synchronizer
    extends ComplexGatePart {
        public Synchronizer(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 1;
        }

        @Override
        protected int inputMask(int shape) {
            return 14;
        }

        @Override
        protected void gateLogicOnChange() {
            int oldInput = this.state() & 0xF;
            int newInput = this.getInput(14);
            int high = newInput & ~oldInput;
            if (oldInput != newInput) {
                int oldValue = this.state2();
                this.setState(this.state() & 0xF0 | newInput);
                this.onInputChange();
                if ((newInput & 4) != 0) {
                    this.setState2(0);
                } else {
                    if ((high & 2) != 0) {
                        this.setState2(this.state2() | 1);
                    }
                    if ((high & 8) != 0) {
                        this.setState2(this.state2() | 2);
                    }
                }
                if (this.right() && this.left()) {
                    this.scheduleTick(2);
                }
                if (this.state2() != oldValue) {
                    this.sendState2Update();
                }
            }
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            int oldValue = this.state2();
            if (!this.pulsing() && this.right() && this.left()) {
                this.setState(this.state() | 0x10);
                this.onOutputChange(1);
                this.setState2(this.state2() | 4);
                this.scheduleTick(2);
            } else if (this.pulsing()) {
                this.setState(this.state() & 0xFFFFFFEF);
                this.onOutputChange(1);
                this.setState2(0);
            }
            if (this.state2() != oldValue) {
                this.sendState2Update();
            }
        }

        protected boolean right() {
            return (this.state2() & 1) != 0;
        }

        protected boolean left() {
            return (this.state2() & 2) != 0;
        }

        protected boolean pulsing() {
            return (this.state2() & 4) != 0;
        }
    }

    public static class StateCell
    extends RedstoneTimerGatePart {
        public StateCell(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            int mask = 9;
            if (shape == 1) {
                mask = IOrientableFacePart.flipMaskZ((int)mask);
            }
            return mask;
        }

        @Override
        protected int inputMask(int shape) {
            int mask = 6;
            if (shape == 1) {
                mask = IOrientableFacePart.flipMaskZ((int)mask);
            }
            return mask;
        }

        @Override
        protected boolean gateLogicCycleShape() {
            this.setShape(this.shape() == 0 ? 1 : 0);
            return true;
        }

        @Override
        protected void gateLogicOnChange() {
            int newInput;
            int oldInput = this.state() & 0xF;
            if (oldInput != (newInput = this.getInput(14))) {
                this.setState(this.state() & 0xF0 | newInput);
                this.onInputChange();
                if (this.shape() == 1) {
                    newInput = IOrientableFacePart.flipMaskZ((int)newInput);
                }
                if ((newInput & 4) != 0 && this.state2() == 0) {
                    this.setState2(1);
                    this.sendState2Update();
                    this.scheduleTick(2);
                }
                if (this.state2() != 0) {
                    if ((newInput & 6) != 0) {
                        this.resetPointer();
                    } else {
                        this.startPointer();
                    }
                }
            }
        }

        @Override
        protected void pointerTick() {
            this.resetPointer();
            if (!this.level().f_46443_) {
                this.setState2(0);
                this.sendState2Update();
                this.setState(0x10 | this.state() & 0xF);
                this.onOutputChange(this.outputMask(this.shape()));
                this.scheduleTick(2);
                this.tickSound();
            }
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            int output = 0;
            if (this.state2() != 0) {
                output = 8;
            }
            if (this.shape() == 1) {
                output = IOrientableFacePart.flipMaskZ((int)output);
            }
            this.setState(output << 4 | this.state() & 0xF);
            this.onOutputChange(this.outputMask(this.shape()));
        }
    }

    public static class Counter
    extends RedstoneGatePart
    implements ICounterGuiLogic {
        private static final int KEY_VALUE = 30;
        private static final int KEY_MAX = 31;
        private static final int KEY_INCR = 32;
        private static final int KEY_DECR = 33;
        private int value = 0;
        private int max = 10;
        private int incr = 1;
        private int decr = 1;

        public Counter(GateType type) {
            super(type);
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.m_128405_("val", this.value);
            tag.m_128405_("max", this.max);
            tag.m_128405_("inc", this.incr);
            tag.m_128405_("dec", this.decr);
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.value = tag.m_128451_("val");
            this.max = tag.m_128451_("max");
            this.incr = tag.m_128451_("inc");
            this.decr = tag.m_128451_("dec");
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            super.writeDesc(packet);
            packet.writeInt(this.value);
            packet.writeInt(this.max);
            packet.writeInt(this.incr);
            packet.writeInt(this.decr);
        }

        @Override
        public void readDesc(MCDataInput packet) {
            super.readDesc(packet);
            this.value = packet.readInt();
            this.max = packet.readInt();
            this.incr = packet.readInt();
            this.decr = packet.readInt();
        }

        @Override
        protected void read(MCDataInput packet, int key) {
            switch (key) {
                case 30: {
                    this.value = packet.readInt();
                    break;
                }
                case 31: {
                    this.max = packet.readInt();
                    break;
                }
                case 32: {
                    this.incr = packet.readInt();
                    break;
                }
                case 33: {
                    this.decr = packet.readInt();
                    break;
                }
                default: {
                    super.read(packet, key);
                }
            }
        }

        protected void sendValueUpdate() {
            this.sendUpdate(30, p -> p.writeInt(this.value));
        }

        protected void sendMaxUpdate() {
            this.sendUpdate(31, p -> p.writeInt(this.max));
        }

        protected void sendIncrUpdate() {
            this.sendUpdate(32, p -> p.writeInt(this.incr));
        }

        protected void sendDecrUpdate() {
            this.sendUpdate(33, p -> p.writeInt(this.decr));
        }

        @Override
        public int getCounterValue() {
            return this.value;
        }

        @Override
        public int getCounterMax() {
            return this.max;
        }

        @Override
        public int getCounterIncr() {
            return this.incr;
        }

        @Override
        public int getCounterDecr() {
            return this.decr;
        }

        @Override
        public void setCounterValue(int i) {
            int oldVal = this.value;
            this.value = Math.min(this.max, Math.max(0, i));
            if (this.value != oldVal) {
                this.tickSound();
                this.sendValueUpdate();
            }
        }

        @Override
        public void setCounterMax(int i) {
            int oldMax = this.max;
            this.max = Math.min(Short.MAX_VALUE, Math.max(1, i));
            if (this.max != oldMax) {
                this.tickSound();
                this.sendMaxUpdate();
                int oldVal = this.value;
                this.value = Math.min(this.value, Math.max(0, i));
                if (this.value != oldVal) {
                    this.sendValueUpdate();
                    this.scheduleTick(2);
                }
            }
        }

        @Override
        public void setCounterIncr(int i) {
            int oldIncr = this.incr;
            this.incr = Math.min(this.max, Math.max(1, i));
            if (this.incr != oldIncr) {
                this.tickSound();
                this.sendIncrUpdate();
            }
        }

        @Override
        public void setCounterDecr(int i) {
            int oldDecr = this.decr;
            this.decr = Math.min(this.max, Math.max(1, i));
            if (this.decr != oldDecr) {
                this.tickSound();
                this.sendDecrUpdate();
            }
        }

        @Override
        protected int outputMask(int shape) {
            return 5;
        }

        @Override
        protected int inputMask(int shape) {
            return 10;
        }

        @Override
        protected void gateLogicOnChange() {
            int high;
            int oldInput = this.state() & 0xF;
            int newInput = this.getInput(10);
            if (this.shape() == 1) {
                newInput = IOrientableFacePart.flipMaskZ((int)newInput);
            }
            if (((high = newInput & ~oldInput) & 2) != 0) {
                this.setCounterValue(this.value + this.incr);
            }
            if ((high & 8) != 0) {
                this.setCounterValue(this.value - this.decr);
            }
            if (oldInput != newInput) {
                this.setState(this.state() & 0xF0 | newInput);
                this.onInputChange();
                this.scheduleTick(2);
            }
        }

        @Override
        protected boolean gateLogicCycleShape() {
            this.setShape(this.shape() == 0 ? 1 : 0);
            return true;
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            int newOutput;
            int oldOutput = this.state();
            int n = this.value == this.max ? 1 : (newOutput = this.value == 0 ? 4 : 0);
            if (newOutput != oldOutput) {
                this.setState(this.state() & 0xF | newOutput << 4);
            }
            if (newOutput != oldOutput) {
                this.onOutputChange(5);
            }
        }

        @Override
        public boolean isPointerStarted() {
            return true;
        }

        @Override
        public int pointerValue() {
            return this.value;
        }

        @Override
        public int pointerMax() {
            return this.max;
        }

        @Override
        protected boolean gateLogicActivate(Player player, ItemStack held, PartRayTraceResult hit) {
            if (held.m_41619_() || !(held.m_41720_() instanceof IScrewdriver)) {
                if (!this.level().f_46443_) {
                    ICounterGuiLogic.openFromServer(player, this);
                }
                return true;
            }
            return false;
        }
    }

    public static class Sequencer
    extends ComplexGatePart
    implements ITimerGuiLogic {
        private static final int KEY_POINTER_MAX = 30;
        private int pointer_max = 40;

        public Sequencer(GateType type) {
            super(type);
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.m_128405_("pmax", this.pointer_max);
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.pointer_max = tag.m_128451_("pmax");
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            super.writeDesc(packet);
            packet.writeInt(this.pointer_max);
        }

        @Override
        public void readDesc(MCDataInput packet) {
            super.readDesc(packet);
            this.pointer_max = packet.readInt();
        }

        @Override
        protected void read(MCDataInput packet, int key) {
            switch (key) {
                case 30: {
                    this.pointer_max = packet.readInt();
                    break;
                }
                default: {
                    super.read(packet, key);
                }
            }
        }

        protected void sendPointerMaxUpdate() {
            this.sendUpdate(30, p -> p.writeInt(this.pointer_max));
        }

        @Override
        public int getTimerMax() {
            return this.pointer_max;
        }

        @Override
        public void setTimerMax(int t) {
            int minTime = Math.max(4, Configurator.minTimerTicks);
            if (t < minTime) {
                t = minTime;
            }
            if (t != this.pointer_max) {
                this.pointer_max = t;
                this.sendPointerMaxUpdate();
            }
        }

        @Override
        public boolean isPointerStarted() {
            return true;
        }

        @Override
        public int pointerValue() {
            return (int)(this.level().m_46468_() % ((long)this.pointer_max * 4L));
        }

        @Override
        public int pointerMax() {
            return this.pointer_max;
        }

        @Override
        protected int outputMask(int shape) {
            return 15;
        }

        @Override
        protected void gateLogicOnChange() {
        }

        @Override
        protected void gateLogicOnScheduledTick() {
        }

        @Override
        protected void gateLogicOnTick() {
            if (this.level().f_46443_) {
                return;
            }
            int oldOut = this.state() >> 4;
            int out = 1 << (int)(this.level().m_46468_() % ((long)this.pointer_max * 4L) / (long)this.pointer_max);
            if (this.shape() == 1) {
                out = IOrientableFacePart.flipMaskZ((int)out);
            }
            if (oldOut != out) {
                this.setState(out << 4);
                this.onOutputChange(15);
                this.tickSound();
            }
        }

        @Override
        protected boolean gateLogicCycleShape() {
            this.setShape(this.shape() == 0 ? 1 : 0);
            return true;
        }

        @Override
        protected boolean gateLogicActivate(Player player, ItemStack held, PartRayTraceResult hit) {
            if (held.m_41619_() || !(held.m_41720_() instanceof IScrewdriver)) {
                if (!this.level().f_46443_) {
                    ITimerGuiLogic.openFromServer(player, this);
                }
                return true;
            }
            return false;
        }
    }

    public static class Timer
    extends RedstoneTimerGatePart {
        public Timer(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 11;
        }

        @Override
        protected int inputMask(int shape) {
            return 14;
        }

        @Override
        protected void gateLogicSetup() {
            this.startPointer();
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            this.setState(this.state() & 0xF);
            this.onOutputChange(11);
            this.gateLogicOnChange();
        }

        @Override
        protected void gateLogicOnChange() {
            int oldInput = this.state() & 0xF;
            int newInput = this.getInput(14);
            if (newInput != oldInput) {
                this.setState(this.state() & 0xF0 | newInput);
                this.onInputChange();
            }
            if (!this.isTickScheduled()) {
                if (newInput > 0) {
                    this.resetPointer();
                } else {
                    this.startPointer();
                }
            }
        }

        @Override
        protected void pointerTick() {
            this.resetPointer();
            if (!this.level().f_46443_) {
                this.scheduleTick(2);
                this.setState(0xB0 | this.state() & 0xF);
                this.onOutputChange(11);
                this.tickSound();
            }
        }
    }

    public static abstract class RedstoneTimerGatePart
    extends ComplexGatePart
    implements ITimerGuiLogic {
        private static final int KEY_POINTER_MAX = 30;
        private static final int KEY_POINTER_START = 31;
        private int pointer_max = 38;
        private long pointer_start = -1L;

        public RedstoneTimerGatePart(GateType type) {
            super(type);
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.m_128405_("pmax", this.pointer_max);
            tag.m_128356_("pelapsed", this.pointer_start < 0L ? -1L : this.level().m_46467_() - this.pointer_start);
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.pointer_max = tag.m_128451_("pmax");
            this.pointer_start = tag.m_128454_("pelapsed");
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            super.writeDesc(packet);
            packet.writeInt(this.pointer_max);
            packet.writeLong(this.pointer_start);
        }

        @Override
        public void readDesc(MCDataInput packet) {
            super.readDesc(packet);
            this.pointer_max = packet.readInt();
            this.pointer_start = packet.readLong();
        }

        @Override
        protected void gateLogicOnWorldLoad() {
            if (this.pointer_start >= 0L) {
                this.pointer_start = this.level().m_46467_() - this.pointer_start;
            }
        }

        @Override
        protected void read(MCDataInput packet, int key) {
            switch (key) {
                case 30: {
                    this.pointer_max = packet.readInt();
                    break;
                }
                case 31: {
                    this.pointer_start = packet.readInt();
                    if (this.pointer_start < 0L) break;
                    this.pointer_start = this.level().m_46467_() - this.pointer_start;
                    break;
                }
                default: {
                    super.read(packet, key);
                }
            }
        }

        protected void sendPointerMaxUpdate() {
            this.sendUpdate(30, p -> p.writeInt(this.pointer_max));
        }

        protected void sendPointerUpdate() {
            this.sendUpdate(31, p -> p.writeInt(this.pointer_start < 0L ? -1 : this.pointerValue()));
        }

        @Override
        public int getTimerMax() {
            return this.pointer_max + 2;
        }

        @Override
        public void setTimerMax(int t) {
            int minTime = Math.max(4, Configurator.minTimerTicks);
            if (t < minTime) {
                t = minTime;
            }
            if (t != this.pointer_max) {
                this.pointer_max = t - 2;
                this.sendPointerMaxUpdate();
            }
        }

        @Override
        protected void gateLogicOnTick() {
            if (this.pointer_start >= 0L) {
                if (this.level().m_46467_() >= this.pointer_start + (long)this.pointer_max) {
                    this.pointerTick();
                } else if (this.pointer_start > this.level().m_46467_()) {
                    this.pointer_start = this.level().m_46467_();
                }
            }
        }

        protected void startPointer() {
            if (this.pointer_start < 0L) {
                this.pointer_start = this.level().m_46467_();
                this.tile().m_6596_();
                if (!this.level().f_46443_) {
                    this.sendPointerUpdate();
                }
            }
        }

        protected void resetPointer() {
            if (this.pointer_start >= 0L) {
                this.pointer_start = -1L;
                this.tile().m_6596_();
                if (!this.level().f_46443_) {
                    this.sendPointerUpdate();
                }
            }
        }

        protected abstract void pointerTick();

        @Override
        public boolean isPointerStarted() {
            return this.pointer_start >= 0L;
        }

        @Override
        public int pointerMax() {
            return this.pointer_max;
        }

        @Override
        public int pointerValue() {
            return this.pointer_start < 0L ? 0 : (int)(this.level().m_46467_() - this.pointer_start);
        }

        @Override
        protected boolean gateLogicActivate(Player player, ItemStack held, PartRayTraceResult hit) {
            if (held.m_41619_() || !(held.m_41720_() instanceof IScrewdriver)) {
                if (!this.level().f_46443_) {
                    ITimerGuiLogic.openFromServer(player, this);
                }
                return true;
            }
            return false;
        }
    }

    public static interface ICounterGuiLogic {
        public int getCounterMax();

        public void setCounterMax(int var1);

        public int getCounterIncr();

        public void setCounterIncr(int var1);

        public int getCounterDecr();

        public void setCounterDecr(int var1);

        public int getCounterValue();

        public void setCounterValue(int var1);

        public static void openFromServer(Player player, GatePart part) {
            PacketCustom packet = new PacketCustom(IntegrationNetwork.NET_CHANNEL, 2);
            IntegrationNetwork.writePartIndex((MCDataOutput)packet, (MultiPart)part);
            packet.sendToPlayer((ServerPlayer)player);
        }
    }

    public static interface ITimerGuiLogic {
        public int getTimerMax();

        public void setTimerMax(int var1);

        public static void openFromServer(Player player, GatePart part) {
            PacketCustom packet = new PacketCustom(IntegrationNetwork.NET_CHANNEL, 1);
            IntegrationNetwork.writePartIndex((MCDataOutput)packet, (MultiPart)part);
            packet.sendToPlayer((ServerPlayer)player);
        }
    }

    public static class ToggleLatch
    extends ComplexGatePart {
        public ToggleLatch(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 5;
        }

        @Override
        protected int inputMask(int shape) {
            return 10;
        }

        @Override
        protected boolean clientNeedsState2() {
            return true;
        }

        @Override
        protected void gateLogicSetup() {
            this.setState(16);
            this.sendStateUpdate();
        }

        @Override
        protected void gateLogicOnChange() {
            int oldInput = this.state() & 0xF;
            int newInput = this.getInput(10);
            int high = newInput & ~oldInput;
            if (high == 2 || high == 8) {
                this.toggle();
            }
            if (oldInput != newInput) {
                this.setState(this.state() & 0xF0 | newInput);
                this.onInputChange();
            }
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            int newOutput;
            int oldOutput = this.state() >> 4;
            int n = newOutput = this.state2() == 0 ? 1 : 4;
            if (oldOutput != newOutput) {
                this.setState(newOutput << 4 | this.state() & 0xF);
                this.onOutputChange(5);
            }
            this.gateLogicOnChange();
        }

        @Override
        protected boolean gateLogicActivate(Player player, ItemStack held, PartRayTraceResult hit) {
            if (held.m_41619_() || !(held.m_41720_() instanceof IScrewdriver)) {
                if (!this.level().f_46443_) {
                    this.toggle();
                }
                return true;
            }
            return false;
        }

        private void toggle() {
            this.setState2(this.state2() == 0 ? 1 : 0);
            this.scheduleTick(2);
            this.tickSound();
        }
    }

    public static class SRLatch
    extends ComplexGatePart {
        public SRLatch(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return shape >> 1 == 0 ? 15 : 5;
        }

        @Override
        protected int inputMask(int shape) {
            return 10;
        }

        @Override
        protected boolean gateLogicCycleShape() {
            this.setShape((this.shape() + 1) % 4);
            this.setState2(IOrientableFacePart.flipMaskZ((int)this.state2()));
            this.setState(IOrientableFacePart.flipMaskZ((int)this.state()));
            this.onOutputChange(15);
            this.scheduleTick(2);
            return true;
        }

        @Override
        protected void gateLogicSetup() {
            this.setState2(2);
            this.setState(48);
        }

        @Override
        protected void gateLogicOnChange() {
            int stateInput = this.state2();
            int oldInput = this.state() & 0xF;
            int newInput = this.getInput(10);
            int oldOutput = this.state() >> 4;
            if (newInput != oldInput) {
                if (stateInput != 10 && newInput != 0 && newInput != stateInput) {
                    this.setState(newInput);
                    this.setState2(newInput);
                    this.onOutputChange(oldOutput);
                    this.scheduleTick(2);
                } else {
                    this.setState(oldOutput << 4 | newInput);
                    this.onInputChange();
                }
            }
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            int newOutput;
            int oldOutput = this.state() >> 4;
            if (oldOutput != (newOutput = this.calcOutput())) {
                this.setState(this.state() & 0xF | newOutput << 4);
                this.onOutputChange(this.outputMask(this.shape()));
            }
            this.gateLogicOnChange();
        }

        private int calcOutput() {
            int input = this.state() & 0xF;
            int stateInput = this.state2();
            if ((this.shape() & 1) != 0) {
                input = IOrientableFacePart.flipMaskZ((int)input);
                stateInput = IOrientableFacePart.flipMaskZ((int)stateInput);
            }
            if (stateInput == 10) {
                if (input == 10) {
                    this.scheduleTick(2);
                    return 0;
                }
                stateInput = input == 0 ? (this.level().f_46441_.m_188499_() ? 2 : 8) : input;
                this.setState2((this.shape() & 1) != 0 ? IOrientableFacePart.flipMaskZ((int)stateInput) : stateInput);
            }
            int output = IOrientableFacePart.shiftMask((int)stateInput, (int)1);
            if ((this.shape() & 2) == 0) {
                output |= stateInput;
            }
            if ((this.shape() & 1) != 0) {
                output = IOrientableFacePart.flipMaskZ((int)output);
            }
            return output;
        }
    }
}

