/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.WaypointMapIcon;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import java.util.Objects;

public class Waypoint {
    public final MapDimension dimension;
    public final int x;
    public final int y;
    public final int z;
    public boolean hidden = false;
    public double minimapDistance = 50000.0;
    public double inWorldDistance = 0.0;
    public String name = "";
    public int color = 0xFFFFFF;
    public WaypointType type = WaypointType.DEFAULT;
    public WaypointMapIcon mapIcon;

    public Waypoint(MapDimension d, int x, int y, int z) {
        this.dimension = d;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void update() {
        this.mapIcon = new WaypointMapIcon(this);
    }

    public double getDrawDistance(boolean isMinimap) {
        if (isMinimap) {
            return this.minimapDistance;
        }
        return this.inWorldDistance == 0.0 ? (Double)FTBChunksClientConfig.WAYPOINT_MAX_DISTANCE.get() : this.inWorldDistance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Waypoint waypoint = (Waypoint)o;
        return this.x == waypoint.x && this.y == waypoint.y && this.z == waypoint.z && this.dimension.dimension.equals(waypoint.dimension.dimension);
    }

    public int hashCode() {
        return Objects.hash(this.dimension.dimension, this.x, this.y, this.z);
    }
}

