/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.Mth;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.EnumUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.config.KiwiConfig;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.shadowed.com.moandjiezana.toml.Toml;
import snownee.kiwi.shadowed.com.moandjiezana.toml.TomlWriter;

public class ConfigHandler {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private boolean hasModules;
    private final String modId;
    private final String fileName;
    private final KiwiConfig.ConfigType type;
    @Nullable
    private final Class<?> clazz;
    private final Map<String, Value<?>> valueMap = Maps.newLinkedHashMap();
    Method onChanged;

    public ConfigHandler(String modId, String fileName, KiwiConfig.ConfigType type, Class<?> clazz, boolean hasModules) {
        this.hasModules = hasModules;
        this.modId = modId;
        this.clazz = clazz;
        this.fileName = fileName;
        this.type = type;
        KiwiConfigManager.register(this);
        if (clazz != null) {
            try {
                this.onChanged = clazz.getDeclaredMethod("onChanged", String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get().resolve(this.fileName + ".toml");
    }

    public void init() {
        this.build();
        Path configPath = this.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            this.refresh();
        }
        this.save();
    }

    public void refresh() {
        Map<String, Object> map;
        Path configPath = this.getConfigPath();
        try {
            Kiwi.logger.info("Loading config from file: {}", (Object)configPath);
            Toml toml = new Toml().read(configPath.toFile());
            map = toml.toMap();
        }
        catch (IllegalStateException e) {
            this.save();
            return;
        }
        if (map.isEmpty()) {
            this.save();
            return;
        }
        HashMap flatMap = Maps.newHashMap();
        ConfigHandler.flatten(ConfigHandler.removeQuotes(map), flatMap, "", this.valueMap.keySet());
        for (Map.Entry e : flatMap.entrySet()) {
            Value<?> value = this.valueMap.get(e.getKey());
            if (value == null) continue;
            Object $ = e.getValue();
            Class<?> type = value.getType();
            if (Enum.class.isAssignableFrom(type)) {
                $ = EnumUtils.getEnumIgnoreCase(type, (String)((String)$), (Enum)((Enum)type.getEnumConstants()[0]));
            }
            value.accept($, this.onChanged);
        }
    }

    private static Map<String, Object> removeQuotes(Map<String, Object> map) {
        HashMap newMap = Maps.newHashMap();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            Map<String, Object> value;
            String key = e.getKey();
            if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            if ((value = e.getValue()) instanceof Map) {
                value = ConfigHandler.removeQuotes(value);
            }
            newMap.put(key, value);
        }
        return newMap;
    }

    private static void flatten(Map<String, Object> src, Map<String, Object> dst, String path, Set<String> keys) {
        for (Map.Entry<String, Object> e : src.entrySet()) {
            String key = e.getKey();
            String newPath = path + key;
            if (e.getValue() instanceof Map && !keys.contains(newPath)) {
                ConfigHandler.flatten((Map)e.getValue(), dst, newPath + ".", keys);
                continue;
            }
            dst.put(newPath, e.getValue());
        }
    }

    public void save() {
        Path configPath = this.getConfigPath();
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (Value<?> value : this.valueMap.values()) {
            List<String> path = List.of(value.path.split("\\."));
            Object v = value.field == null ? value.value : ConfigHandler.convert(value.field);
            value.accept(v, this.onChanged);
            ConfigHandler.getEndMap(map, path).put(path.get(path.size() - 1), v);
        }
        TomlWriter writer = new TomlWriter();
        try {
            writer.write((Object)map, configPath.toFile());
        }
        catch (JsonSyntaxException | IOException e) {
            Kiwi.logger.catching(e);
        }
    }

    private void build() {
        if (this.hasModules) {
            KiwiConfigManager.defineModules(this.modId, this, !this.fileName.equals(this.modId + "-modules"));
        }
        if (this.clazz == null) {
            return;
        }
        Joiner joiner = Joiner.on((char)'.');
        for (Field field : this.clazz.getFields()) {
            KiwiConfig.Range range;
            KiwiConfig.Comment comment;
            int mods = field.getModifiers();
            if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || Modifier.isFinal(mods) || field.getAnnotation(KiwiModule.Skip.class) != null) continue;
            List<String> path = ConfigHandler.getPath(field);
            String pathKey = joiner.join(path);
            KiwiConfig.Translation translation = field.getAnnotation(KiwiConfig.Translation.class);
            String translationKey = translation != null ? translation.value() : pathKey;
            Object converted = ConfigHandler.convert(field);
            if (converted == null) continue;
            Value<Object> value = this.define(pathKey, converted, field, translationKey);
            if (field.getAnnotation(KiwiConfig.LevelRestart.class) != null || field.getAnnotation(KiwiConfig.GameRestart.class) != null) {
                value.requiresRestart = true;
            }
            if ((comment = field.getAnnotation(KiwiConfig.Comment.class)) != null) {
                value.comment = comment.value();
            }
            if ((range = field.getAnnotation(KiwiConfig.Range.class)) == null) continue;
            value.min = range.min();
            value.max = range.max();
        }
    }

    static List<String> getPath(Field field) {
        List<String> annotatedPath = ConfigHandler.getPath((AnnotatedElement)field);
        return annotatedPath == null ? Collections.singletonList(field.getName()) : annotatedPath;
    }

    static List<String> getPath(AnnotatedElement annotatedElement) {
        KiwiConfig.Path path = annotatedElement.getDeclaredAnnotation(KiwiConfig.Path.class);
        if (path != null) {
            return List.of(path.value().split("\\."));
        }
        KiwiConfig.AdvancedPath advancedPath = annotatedElement.getDeclaredAnnotation(KiwiConfig.AdvancedPath.class);
        if (advancedPath != null) {
            return Arrays.asList(advancedPath.value());
        }
        return null;
    }

    public <T> Value<T> define(String path, T value, @Nullable Field field, String translation) {
        Value<T> v = new Value<T>(path, field, value, translation);
        this.valueMap.put(path, v);
        return v;
    }

    private static Map<String, Object> getEndMap(Map<String, Object> map, List<String> path) {
        int l = path.size() - 1;
        for (int i = 0; i < l; ++i) {
            map = (Map)map.computeIfAbsent((String)path.get(i), $ -> Maps.newHashMap());
        }
        return map;
    }

    private static Object convert(Field field) {
        try {
            Class<?> type = field.getType();
            if (!(type == Integer.TYPE || type == Long.TYPE || type == Double.TYPE || type == Float.TYPE || type == Boolean.TYPE || type == String.class || Enum.class.isAssignableFrom(type) || List.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type))) {
                return null;
            }
            if (type == String.class) {
                String defaultVal = (String)field.get(null);
                if (defaultVal == null) {
                    defaultVal = "";
                }
                return defaultVal;
            }
            if (List.class.isAssignableFrom(type)) {
                List defaultVal = (List)field.get(null);
                if (defaultVal == null) {
                    defaultVal = List.of();
                }
                return defaultVal;
            }
            if (Map.class.isAssignableFrom(type)) {
                Map defaultVal = (Map)field.get(null);
                if (defaultVal == null) {
                    defaultVal = Map.of();
                }
                return defaultVal;
            }
            return field.get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setHasModules(boolean hasModules) {
        this.hasModules = hasModules;
    }

    public boolean hasModules() {
        return this.hasModules;
    }

    public String getModId() {
        return this.modId;
    }

    public KiwiConfig.ConfigType getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    private static Class<?> toPrimitiveClass(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        return clazz;
    }

    public <T> Value<T> get(String path) {
        return this.valueMap.get(path);
    }

    public Map<String, Value<?>> getValueMap() {
        return this.valueMap;
    }

    public static class Value<T> {
        String path;
        @Nullable
        public Field field;
        @NotNull
        public T value;
        @NotNull
        public final T defValue;
        public boolean requiresRestart;
        @Nullable
        public String[] comment;
        @Nullable
        public String translation;
        public double min = Double.NaN;
        public double max = Double.NaN;

        public Value(String path, @Nullable Field field, T value, String translation) {
            this.path = path;
            this.field = field;
            this.value = value;
            this.defValue = this.value;
            this.translation = translation;
        }

        public T get() {
            return this.value;
        }

        public Class<?> getType() {
            return this.field != null ? this.field.getType() : ConfigHandler.toPrimitiveClass(this.value.getClass());
        }

        public void accept(Object $, Method onChanged) {
            try {
                Class<?> type = this.getType();
                if (type == Integer.TYPE) {
                    int max;
                    int min = Double.isNaN(this.min) ? Integer.MIN_VALUE : (int)this.min;
                    int n = max = Double.isNaN(this.max) ? Integer.MAX_VALUE : (int)this.max;
                    if ($.getClass() == Long.class) {
                        $ = ((Long)$).intValue();
                    }
                    $ = Mth.m_14045_((int)((Integer)$), (int)min, (int)max);
                } else if (type == Float.TYPE) {
                    float max;
                    float min = Double.isNaN(this.min) ? Float.MIN_VALUE : (float)this.min;
                    float f = max = Double.isNaN(this.max) ? Float.MAX_VALUE : (float)this.max;
                    if ($.getClass() == Double.class) {
                        $ = Float.valueOf(((Double)$).floatValue());
                    }
                    $ = Float.valueOf(Mth.m_14036_((float)((Float)$).floatValue(), (float)min, (float)max));
                } else if (type == Double.TYPE) {
                    double min = Double.isNaN(this.min) ? Double.MIN_VALUE : this.min;
                    double max = Double.isNaN(this.max) ? Double.MAX_VALUE : this.max;
                    $ = Mth.m_14008_((double)((Double)$), (double)min, (double)max);
                } else if (type == Long.TYPE) {
                    long min = Double.isNaN(this.min) ? Long.MIN_VALUE : (long)this.min;
                    long max = Double.isNaN(this.max) ? Long.MAX_VALUE : (long)this.max;
                    $ = Mth.m_14053_((long)((Long)$), (long)min, (long)max);
                }
                if (this.field != null) {
                    if (type == Boolean.TYPE) {
                        this.field.setBoolean(null, (Boolean)$);
                    } else if (type == Integer.TYPE) {
                        this.field.setInt(null, (Integer)$);
                    } else if (type == Float.TYPE) {
                        this.field.setFloat(null, ((Float)$).floatValue());
                    } else if (type == Double.TYPE) {
                        this.field.setDouble(null, (Double)$);
                    } else if (type == Long.TYPE) {
                        this.field.setLong(null, (Long)$);
                    } else {
                        this.field.set(null, $);
                    }
                }
                boolean changed = !Objects.equals(this.value, $);
                this.value = $;
                if (changed && onChanged != null) {
                    onChanged.invoke(null, this.path);
                }
            }
            catch (Exception e1) {
                Kiwi.logger.catching((Throwable)e1);
            }
        }

        public <A extends Annotation> A getAnnotation(Class<A> clazz) {
            return this.field == null ? null : (A)this.field.getAnnotation(clazz);
        }
    }
}

