/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons;

import mekanism.api.providers.IModuleDataProvider;
import mekanism.client.ClientRegistrationUtil;
import mekanism.common.Mekanism;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.MekanismConfigHelper;
import mekanism.common.item.ItemModule;
import mekanism.common.registration.impl.EntityTypeDeferredRegister;
import mekanism.common.registration.impl.EntityTypeRegistryObject;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registration.impl.ItemRegistryObject;
import mekanism.common.registration.impl.ModuleDeferredRegister;
import mekanism.common.registration.impl.ModuleRegistryObject;
import mekanism.common.registries.MekanismModules;
import meranha.mekaweapons.WeaponsConfig;
import meranha.mekaweapons.WeaponsRenderer;
import meranha.mekaweapons.items.ItemMagnetizer;
import meranha.mekaweapons.items.ItemMekaBow;
import meranha.mekaweapons.items.ItemMekaTana;
import meranha.mekaweapons.items.MekaArrowEntity;
import meranha.mekaweapons.items.MekaArrowRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod.EventBusSubscriber(modid="mekaweapons", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="mekaweapons")
public class MekaWeapons {
    public static final String MODID = "mekaweapons";
    public static final WeaponsConfig general = new WeaponsConfig();
    public static final ModuleDeferredRegister MODULES = new ModuleDeferredRegister("mekaweapons");
    public static final ModuleRegistryObject<?> ARROWENERGY_UNIT = MODULES.registerMarker("arrowenergy_unit", () -> MODULE_ARROWENERGY.m_5456_(), builder -> builder.rarity(Rarity.RARE));
    public static final ModuleRegistryObject<?> AUTOFIRE_UNIT = MODULES.registerMarker("autofire_unit", () -> MODULE_AUTOFIRE.m_5456_(), builder -> builder.rarity(Rarity.RARE));
    public static final ModuleRegistryObject<?> DRAWSPEED_UNIT = MODULES.registerMarker("drawspeed_unit", () -> MODULE_DRAWSPEED.m_5456_(), builder -> builder.maxStackSize(3).rarity(Rarity.RARE));
    public static final ModuleRegistryObject<?> GRAVITYDAMPENER_UNIT = MODULES.registerMarker("gravitydampener_unit", () -> MODULE_GRAVITYDAMPENER.m_5456_(), builder -> builder.rarity(Rarity.EPIC));
    public static final ItemDeferredRegister ITEMS = new ItemDeferredRegister("mekaweapons");
    public static final ItemRegistryObject<ItemMekaTana> MEKA_TANA = ITEMS.registerUnburnable("mekatana", ItemMekaTana::new);
    public static final ItemRegistryObject<ItemMekaBow> MEKA_BOW = ITEMS.registerUnburnable("mekabow", ItemMekaBow::new);
    public static final ItemRegistryObject<Item> MAGNETIZER = ITEMS.registerUnburnable("magnetizer", ItemMagnetizer::new);
    public static final ItemRegistryObject<Item> KATANA_BLADE = ITEMS.register("katana_blade");
    public static final ItemRegistryObject<Item> BOW_RISER = ITEMS.register("bow_riser");
    public static final ItemRegistryObject<Item> BOW_LIMB = ITEMS.register("bow_limb");
    public static final ItemRegistryObject<ItemModule> MODULE_ARROWENERGY = ITEMS.registerModule(ARROWENERGY_UNIT);
    public static final ItemRegistryObject<ItemModule> MODULE_AUTOFIRE = ITEMS.registerModule(AUTOFIRE_UNIT);
    public static final ItemRegistryObject<ItemModule> MODULE_DRAWSPEED = ITEMS.registerModule(DRAWSPEED_UNIT);
    public static final ItemRegistryObject<ItemModule> MODULE_GRAVITYDAMPENER = ITEMS.registerModule(GRAVITYDAMPENER_UNIT);
    public static final EntityTypeDeferredRegister ENTITY_TYPES = new EntityTypeDeferredRegister("mekaweapons");
    public static final EntityTypeRegistryObject<MekaArrowEntity> MEKA_ARROW = ENTITY_TYPES.register("meka_arrow", EntityType.Builder.m_20704_(MekaArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20));
    public static final String ADD_MEKA_BOW_MODULES = "add_meka_bow_modules";
    public static final String ADD_MEKATANA_MODULES = "add_mekatana_modules";

    public MekaWeapons() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        MODULES.register(modEventBus);
        ENTITY_TYPES.register(modEventBus);
        MekanismConfigHelper.registerConfig((ModContainer)ModLoadingContext.get().getActiveContainer(), (IMekanismConfig)general);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::registerRenderers);
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        if (ModList.get().isLoaded("curios")) {
            CuriosRendererRegistry.register((Item)((Item)MAGNETIZER.get()), WeaponsRenderer::new);
        }
        event.enqueueWork(() -> {
            ClientRegistrationUtil.setPropertyOverride(MEKA_BOW, (ResourceLocation)Mekanism.rl((String)"pull"), (stack, world, entity, seed) -> {
                Item patt5892$temp;
                if (entity != null && entity.m_21211_() == stack && (patt5892$temp = stack.m_41720_()) instanceof ItemMekaBow) {
                    ItemMekaBow bow = (ItemMekaBow)patt5892$temp;
                    return (float)(stack.m_41779_() - entity.m_21212_()) / bow.getUseTick(stack);
                }
                return 0.0f;
            });
            ClientRegistrationUtil.setPropertyOverride(MEKA_BOW, (ResourceLocation)Mekanism.rl((String)"pulling"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        });
    }

    public void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)MEKA_ARROW.get(), MekaArrowRenderer::new);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("magnetizer").icon(new ResourceLocation("curios:slot/magnetizer_slot")).build());
        MekaWeapons.addMekaBowModules(new IModuleDataProvider[]{MekanismModules.ENERGY_UNIT, MekanismModules.ATTACK_AMPLIFICATION_UNIT, AUTOFIRE_UNIT, ARROWENERGY_UNIT, DRAWSPEED_UNIT, GRAVITYDAMPENER_UNIT});
        MekaWeapons.addMekaTanaModules(new IModuleDataProvider[]{MekanismModules.ENERGY_UNIT, MekanismModules.ATTACK_AMPLIFICATION_UNIT, MekanismModules.TELEPORTATION_UNIT});
    }

    private static void sendModuleIMC(String method, IModuleDataProvider<?> ... moduleDataProviders) {
        if (moduleDataProviders == null || moduleDataProviders.length == 0) {
            throw new IllegalArgumentException("No module data providers given.");
        }
        InterModComms.sendTo((String)"mekanism", (String)method, () -> moduleDataProviders);
    }

    public static void addMekaBowModules(IModuleDataProvider<?> ... moduleDataProviders) {
        MekaWeapons.sendModuleIMC(ADD_MEKA_BOW_MODULES, moduleDataProviders);
    }

    public static void addMekaTanaModules(IModuleDataProvider<?> ... moduleDataProviders) {
        MekaWeapons.sendModuleIMC(ADD_MEKATANA_MODULES, moduleDataProviders);
    }
}

