/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.items;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.WeaponsLang;
import meranha.mekaweapons.items.MekaArrowEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class ItemMekaBow
extends BowItem
implements IModuleContainerItem,
IModeItem {
    public boolean isFullChargeShot = false;

    public ItemMekaBow(Item.Properties properties) {
        super(properties.m_41497_(Rarity.EPIC).setNoRepair().m_41487_(1));
    }

    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed((KeyMapping)MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
        } else {
            StorageUtils.addStoredEnergy((ItemStack)stack, tooltip, (boolean)true);
            if (this.hasModule(stack, (IModuleDataProvider)MekaWeapons.AUTOFIRE_UNIT)) {
                tooltip.add((Component)WeaponsLang.AUTOFIRE_MODE.translateColored(EnumColor.YELLOW, new Object[]{BooleanStateDisplay.OnOff.of((boolean)this.isModuleEnabled(stack, (IModuleDataProvider)MekaWeapons.AUTOFIRE_UNIT))}));
            }
            if (this.hasModule(stack, (IModuleDataProvider)MekaWeapons.ARROWENERGY_UNIT)) {
                tooltip.add((Component)WeaponsLang.ARROWENERGY_MODE.translateColored(EnumColor.YELLOW, new Object[]{BooleanStateDisplay.OnOff.of((boolean)this.isModuleEnabled(stack, (IModuleDataProvider)MekaWeapons.ARROWENERGY_UNIT))}));
            }
            tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, MekanismKeyHandler.detailsKey.m_90863_()}));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.mekaweapons.attackdamage", (Object[])new Object[]{this.getDamage(stack)}).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }

    public void m_5929_(@Nonnull Level world, @Nonnull LivingEntity player, @Nonnull ItemStack stack, int timeLeft) {
        if ((!player.m_6298_(stack).m_41619_() || this.isInfinite((Player)player, stack)) && this.isModuleEnabled(stack, (IModuleDataProvider)MekaWeapons.AUTOFIRE_UNIT) && (float)(this.m_8105_(stack) - timeLeft) == this.getUseTick(stack)) {
            player.m_5810_();
            stack.m_41674_(world, player, 0);
            player.m_6672_(player.m_7655_());
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack;
        boolean hasAmmo = !player.m_6298_(stack = player.m_21120_(hand)).m_41619_() || this.isInfinite(player, stack);
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (Level)world, (Player)player, (InteractionHand)hand, (boolean)hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (!player.m_150110_().f_35937_ && !hasAmmo) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5551_(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            IEnergyContainer energyContainer = null;
            if (!player.m_7500_()) {
                energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
                FloatingLong energyNeeded = (FloatingLong)MekaWeapons.general.mekaBowEnergyUsage.get();
                if (energyContainer == null || energyContainer.extract(energyNeeded, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyNeeded)) {
                    return;
                }
                energyContainer.extract((FloatingLong)MekaWeapons.general.mekaBowEnergyUsage.get(), Action.EXECUTE, AutomationType.MANUAL);
            }
            ItemStack ammo = player.m_6298_(stack);
            int charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)world, (Player)player, (int)(this.m_8105_(stack) - timeLeft), (boolean)this.isInfinite(player, stack));
            if (charge < 0) {
                return;
            }
            if (!ammo.m_41619_() || this.isInfinite(player, stack)) {
                float velocity = ItemMekaBow.m_40661_((int)charge);
                if ((double)velocity < 0.1) {
                    return;
                }
                if (ammo.m_41619_()) {
                    ammo = new ItemStack((ItemLike)Items.f_42412_);
                }
                if (!world.f_46443_) {
                    int punch;
                    ArrowItem arrowitem = (ArrowItem)(ammo.m_41720_() instanceof ArrowItem ? ammo.m_41720_() : Items.f_42412_);
                    AbstractArrow arrowEntity = this.customArrow(arrowitem.m_6394_(world, ammo, (LivingEntity)player));
                    this.isFullChargeShot = velocity >= 1.0f;
                    int unitMultiplier = 0;
                    arrowEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, (float)(3 + unitMultiplier) * velocity, 0.0f);
                    int damage = this.getDamage(stack);
                    arrowEntity.m_36781_((double)damage / 3.0);
                    int power = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
                    if (power > 0) {
                        arrowEntity.m_36781_((double)damage + 0.5 * (double)power + 0.5);
                    }
                    if ((punch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                        arrowEntity.m_36735_(punch);
                    }
                    if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                        arrowEntity.m_20254_(100);
                    }
                    if (this.isInfinite(player, stack) || player.m_7500_() && (ammo.m_41720_() == Items.f_42737_ || ammo.m_41720_() == Items.f_42738_)) {
                        arrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    world.m_7967_((Entity)arrowEntity);
                }
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (world.f_46441_.m_188501_() * 0.4f + 1.2f) + velocity * 0.5f);
                if (!this.isInfinite(player, stack) && !player.m_7500_()) {
                    ammo.m_41774_(1);
                    if (ammo.m_41619_()) {
                        player.m_150109_().m_36057_(ammo);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public boolean isInfinite(Player player, ItemStack stack) {
        return player.m_7500_() || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0 || this.isModuleEnabled(stack, (IModuleDataProvider)MekaWeapons.ARROWENERGY_UNIT);
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return true;
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth((ItemStack)stack);
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        IModule module = this.getModule(stack, (IModuleDataProvider)MekanismModules.ENERGY_UNIT);
        @NotNull FloatingLongSupplier maxEnergy = () -> module == null ? (FloatingLong)MekaWeapons.general.mekaBowBaseEnergyCapacity.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getEnergyCapacity(module);
        return new ItemCapabilityWrapper(stack, new ItemCapabilityWrapper.ItemCapability[]{RateLimitEnergyHandler.create((FloatingLongSupplier)MekaWeapons.general.mekaBowBaseChargeRate, (FloatingLongSupplier)maxEnergy, (Predicate)BasicEnergyContainer.manualOnly, (Predicate)BasicEnergyContainer.alwaysTrue)});
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public boolean m_5812_(@Nonnull ItemStack stack) {
        return false;
    }

    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, boolean displayChangeMessage) {
        IModule autoFireUnit = this.getModule(stack, (IModuleDataProvider)MekaWeapons.AUTOFIRE_UNIT);
        if (autoFireUnit != null) {
            autoFireUnit.toggleEnabled(player, (Component)WeaponsLang.AUTOFIRE_MODE_CHANGE.translateColored(EnumColor.WHITE, new Object[0]));
        }
    }

    public int getDamage(@Nonnull ItemStack stack) {
        IModule attackAmplificationUnit = this.getModule(stack, (IModuleDataProvider)MekanismModules.ATTACK_AMPLIFICATION_UNIT);
        int damage = MekaWeapons.general.mekaBowBaseDamage.get();
        if (attackAmplificationUnit != null && attackAmplificationUnit.isEnabled()) {
            for (int i = 0; i < attackAmplificationUnit.getInstalledCount(); ++i) {
                damage += MekaWeapons.general.mekaBowBaseDamage.get();
            }
        }
        return damage;
    }

    public float getUseTick(@Nonnull ItemStack stack) {
        float useTick = 20.0f;
        IModule drawSpeedUnit = this.getModule(stack, (IModuleDataProvider)MekaWeapons.DRAWSPEED_UNIT);
        if (drawSpeedUnit != null && drawSpeedUnit.isEnabled()) {
            for (int i = 0; i < drawSpeedUnit.getInstalledCount(); ++i) {
                useTick -= 5.0f;
            }
        }
        return useTick;
    }

    @NotNull
    public AbstractArrow customArrow(AbstractArrow arrow) {
        Entity owner = arrow.m_37282_();
        if (!(owner instanceof LivingEntity)) {
            return new MekaArrowEntity((EntityType<? extends MekaArrowEntity>)MekaWeapons.MEKA_ARROW.getEntityType(), arrow.f_19853_);
        }
        return new MekaArrowEntity((LivingEntity)arrow.m_37282_(), arrow.f_19853_);
    }

    public boolean isGravityDampenerEnabled(@Nonnull ItemStack stack) {
        IModule gravityDampenerUnit = this.getModule(stack, (IModuleDataProvider)MekaWeapons.GRAVITYDAMPENER_UNIT);
        return gravityDampenerUnit != null && gravityDampenerUnit.isEnabled();
    }
}

