/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.event.MekanismTeleportEvent;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.value.CachedValue;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.mekatool.ModuleAttackAmplificationUnit;
import mekanism.common.content.gear.mekatool.ModuleTeleportationUnit;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.ItemEnergized;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import meranha.mekaweapons.MekaWeapons;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class ItemMekaTana
extends ItemEnergized
implements IModuleContainerItem {
    private final Int2ObjectMap<AttributeCache> attributeCaches = new Int2ObjectArrayMap(ModuleAttackAmplificationUnit.AttackDamage.values().length);

    public ItemMekaTana(Item.Properties properties) {
        super((FloatingLongSupplier)MekaWeapons.general.mekaTanaBaseChargeRate, (FloatingLongSupplier)MekaWeapons.general.mekaTanaBaseEnergyCapacity, properties.m_41497_(Rarity.EPIC).setNoRepair());
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed((KeyMapping)MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
        } else {
            StorageUtils.addStoredEnergy((ItemStack)stack, tooltip, (boolean)true);
            tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, MekanismKeyHandler.detailsKey.m_90863_()}));
        }
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        if (stack.m_41619_()) {
            return 0;
        }
        return Math.max(MekanismUtils.getEnchantmentLevel((ListTag)ItemDataUtils.getList((ItemStack)stack, (String)"Enchantments"), (Enchantment)enchantment), super.getEnchantmentLevel(stack, enchantment));
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44882_((ListTag)ItemDataUtils.getList((ItemStack)stack, (String)"Enchantments"));
        super.getAllEnchantments(stack).forEach((enchantment, level) -> enchantments.merge(enchantment, level, Math::max));
        return enchantments;
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        IModule attackAmplificationUnit = this.getModule(stack, (IModuleDataProvider)MekanismModules.ATTACK_AMPLIFICATION_UNIT);
        if (attackAmplificationUnit != null && attackAmplificationUnit.isEnabled()) {
            IEnergyContainer energyContainer;
            int unitDamage = MekaWeapons.general.mekaTanaBaseDamage.get();
            for (int i = 0; i < attackAmplificationUnit.getInstalledCount(); ++i) {
                unitDamage += MekaWeapons.general.mekaTanaBaseDamage.get();
            }
            if (unitDamage > 0 && (energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0)) != null && !energyContainer.isEmpty()) {
                energyContainer.extract(((FloatingLong)MekaWeapons.general.mekaTanaEnergyUsage.get()).multiply((double)unitDamage / 4.0), Action.EXECUTE, AutomationType.MANUAL);
            }
        }
        return true;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            int unitDamage = MekaWeapons.general.mekaTanaBaseDamage.get();
            IModule attackAmplificationUnit = this.getModule(stack, (IModuleDataProvider)MekanismModules.ATTACK_AMPLIFICATION_UNIT);
            if (attackAmplificationUnit != null && attackAmplificationUnit.isEnabled()) {
                for (int i = 0; i < attackAmplificationUnit.getInstalledCount(); ++i) {
                    unitDamage += MekaWeapons.general.mekaTanaBaseDamage.get();
                }
                if (unitDamage > 0) {
                    FloatingLong energy;
                    FloatingLong energyCost = (FloatingLong)MekaWeapons.general.mekaTanaEnergyUsage.get();
                    IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
                    FloatingLong floatingLong = energy = energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
                    if (energy.smallerThan(energyCost)) {
                        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)MekaWeapons.general.mekaTanaBaseDamage.get(), AttributeModifier.Operation.ADDITION));
                        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", MekaWeapons.general.mekaTanaAttackSpeed.get(), AttributeModifier.Operation.ADDITION));
                        return builder.build();
                    }
                }
            }
            return (Multimap)((AttributeCache)this.attributeCaches.computeIfAbsent(unitDamage, damage -> new AttributeCache(builder -> {
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)damage, AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", MekaWeapons.general.mekaTanaAttackSpeed.get(), AttributeModifier.Operation.ADDITION));
            }, new CachedValue[]{MekaWeapons.general.mekaTanaBaseDamage, MekaWeapons.general.mekaTanaAttackSpeed}))).get();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        IModule module;
        ItemStack stack = player.m_21120_(hand);
        if (!world.m_5776_() && (module = this.getModule(stack, (IModuleDataProvider)MekanismModules.TELEPORTATION_UNIT)) != null && module.isEnabled()) {
            BlockPos pos;
            BlockHitResult result = MekanismUtils.rayTrace((Player)player, (double)MekaWeapons.general.mekaTanaMaxTeleportReach.get());
            if ((!((ModuleTeleportationUnit)module.getCustomInstance()).requiresBlockTarget() || result.m_6662_() != HitResult.Type.MISS) && this.isValidDestinationBlock(world, (pos = result.m_82425_()).m_7494_()) && this.isValidDestinationBlock(world, pos.m_6630_(2))) {
                double targetZ;
                double targetY;
                double distance = player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                if (distance < 5.0) {
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
                FloatingLong energyNeeded = ((FloatingLong)MekaWeapons.general.mekaTanaTeleportUsage.get()).multiply(distance / 10.0);
                if (energyContainer == null || energyContainer.getEnergy().smallerThan(energyNeeded)) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                double targetX = (double)pos.m_123341_() + 0.5;
                MekanismTeleportEvent.MekaTool event = new MekanismTeleportEvent.MekaTool(player, targetX, targetY = (double)pos.m_123342_() + 1.5, targetZ = (double)pos.m_123343_() + 0.5, stack, result);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                energyContainer.extract(energyNeeded, Action.EXECUTE, AutomationType.MANUAL);
                if (player.m_20159_()) {
                    player.m_142098_(targetX, targetY, targetZ);
                } else {
                    player.m_6021_(targetX, targetY, targetZ);
                }
                player.m_183634_();
                Mekanism.packetHandler().sendToAllTracking((Object)new PacketPortalFX(pos.m_7494_()), world, pos);
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private boolean isValidDestinationBlock(Level world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_60795_() || MekanismUtils.isLiquidBlock((Block)blockState.m_60734_());
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    protected FloatingLong getMaxEnergy(ItemStack stack) {
        IModule module = this.getModule(stack, (IModuleDataProvider)MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekaWeapons.general.mekaTanaBaseEnergyCapacity.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getEnergyCapacity(module);
    }

    protected FloatingLong getChargeRate(ItemStack stack) {
        IModule module = this.getModule(stack, (IModuleDataProvider)MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekaWeapons.general.mekaTanaBaseChargeRate.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getChargeRate(module);
    }
}

