/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public abstract class IEProjectileEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Optional<UUID>> SHOOTER_PARAMETER = SynchedEntityData.m_135353_(IEProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public int ticksInAir;
    protected IntSet piercedEntities;
    @Nullable
    protected UUID shooterUUID;
    private boolean forceNoGravity;
    private int tickLimit = 40;

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world) {
        super(type, world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world, double x, double y, double z) {
        this(type, world);
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_6034_(x, y, z);
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world, LivingEntity living, double ax, double ay, double az) {
        this(type, world, living, living.m_20185_(), living.m_20186_() + (double)living.m_20192_(), living.m_20189_(), ax, ay, az);
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world, @Nonnull LivingEntity living, float velocity, float inaccuracy) {
        this(type, world);
        this.m_5602_((Entity)living);
        this.setShooterSynced();
        this.m_6034_(living.m_20185_(), living.m_20188_() - 0.1, living.m_20189_());
        this.m_37251_((Entity)living, living.m_146909_(), living.m_146908_(), 0.0f, velocity, inaccuracy);
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world, LivingEntity living, double x, double y, double z, double ax, double ay, double az) {
        this(type, world);
        float yaw = living != null ? living.m_146908_() : 0.0f;
        float pitch = living != null ? living.m_146909_() : 0.0f;
        this.m_7678_(x, y, z, yaw, pitch);
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20334_(ax, ay, az);
        this.m_5602_((Entity)living);
        this.setShooterSynced();
        Vec3 motion = this.m_20184_();
        this.m_6686_(motion.f_82479_, motion.f_82480_, motion.f_82481_, 3.0f, 1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOTER_PARAMETER, Optional.empty());
    }

    @Nonnull
    public EntityDimensions m_6972_(Pose poseIn) {
        return new EntityDimensions(0.125f, 0.125f, true);
    }

    public void setTickLimit(int limit) {
        this.tickLimit = limit;
    }

    public void setShooterSynced() {
        this.f_19804_.m_135381_(SHOOTER_PARAMETER, Optional.ofNullable(this.shooterUUID));
    }

    public UUID getShooterSynced() {
        Optional s = (Optional)this.f_19804_.m_135370_(SHOOTER_PARAMETER);
        return s.orElse(null);
    }

    @Nullable
    public UUID getShooterUUID() {
        return this.shooterUUID;
    }

    @Nonnull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public boolean isInGround() {
        return this.f_36703_;
    }

    public void m_8119_() {
        Vec3 vec33;
        Vec3 vec32;
        BlockHitResult blockHitResult;
        if (!this.isInGround()) {
            ++this.ticksInAir;
        }
        if (this.ticksInAir >= this.tickLimit || this.f_36704_ >= this.getMaxTicksInGround()) {
            this.m_146870_();
        }
        if (this.m_37282_() == null && this.f_19853_.f_46443_) {
            this.shooterUUID = this.getShooterSynced();
        }
        Vec3 delta = this.m_20184_().m_82520_(0.0, 0.0, 0.0);
        float xRotPrev = this.m_146909_();
        float yRotPrev = this.m_146908_();
        float xRot0Prev = this.f_19860_;
        float yRot0Prev = this.f_19859_;
        this.forceNoGravity = true;
        super.m_8119_();
        this.forceNoGravity = false;
        if (!(this.m_213877_() || this.f_36703_ || (blockHitResult = this.f_19853_.m_45547_(new ClipContext(vec32 = this.m_20182_(), vec33 = vec32.m_82549_(delta), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this))).m_6662_() == HitResult.Type.MISS || ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)blockHitResult))) {
            this.m_6532_((HitResult)blockHitResult);
            this.f_19812_ = true;
        }
        if (!this.f_36703_) {
            this.m_146926_(xRotPrev);
            this.m_146922_(yRotPrev);
            this.f_19860_ = xRot0Prev;
            this.f_19859_ = yRot0Prev;
            float absMotion = (float)delta.m_82553_();
            this.m_146922_((float)(Math.atan2(delta.f_82479_, delta.f_82481_) * 180.0 / Math.PI));
            this.m_146926_((float)(Math.atan2(delta.f_82480_, absMotion) * 180.0 / Math.PI));
            while (this.m_146909_() - this.f_19860_ < -180.0f) {
                this.f_19860_ -= 360.0f;
            }
            while (this.m_146909_() - this.f_19860_ >= 180.0f) {
                this.f_19860_ += 360.0f;
            }
            while (this.m_146908_() - this.f_19859_ < -180.0f) {
                this.f_19859_ -= 360.0f;
            }
            while (this.m_146908_() - this.f_19859_ >= 180.0f) {
                this.f_19859_ += 360.0f;
            }
            this.m_146926_(this.f_19860_ + (this.m_146909_() - this.f_19860_) * 0.2f);
            this.m_146922_(this.f_19859_ + (this.m_146908_() - this.f_19859_) * 0.2f);
            float movementDecay = this.getMotionDecayFactor();
            if (this.m_20069_()) {
                movementDecay *= 0.8f;
            }
            if (movementDecay > 0.0f) {
                this.m_20256_(delta.m_82490_((double)movementDecay).m_82520_(0.0, -this.getGravity(), 0.0));
            }
        }
    }

    public void m_6123_(Player player) {
        if (!this.f_19853_.f_46443_ && (this.f_36703_ || this.m_36797_()) && this.f_36706_ <= 0) {
            boolean flag;
            boolean bl = flag = this.f_36705_ == AbstractArrow.Pickup.ALLOWED || this.f_36705_ == AbstractArrow.Pickup.CREATIVE_ONLY && player.m_150110_().f_35937_ || this.m_36797_() && this.m_37282_().m_20148_() == player.m_20148_();
            if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED && !player.m_150109_().m_36054_(this.m_7941_())) {
                flag = false;
            }
            if (flag) {
                player.m_7938_((Entity)this, 1);
                this.m_146870_();
            }
        }
    }

    protected void handlePiecing(Entity target) {
        if (this.m_36796_() > 0) {
            if (this.piercedEntities == null) {
                this.piercedEntities = new IntOpenHashSet((int)this.m_36796_());
            }
            if (this.piercedEntities.size() >= this.m_36796_() + 1) {
                this.m_146870_();
                return;
            }
            this.piercedEntities.add(target.m_19879_());
        } else {
            this.m_146870_();
        }
    }

    public double getGravity() {
        return 0.05f;
    }

    public boolean canIgnite() {
        return false;
    }

    public int getMaxTicksInGround() {
        return 100;
    }

    protected float getMotionDecayFactor() {
        return 0.99f;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.shooterUUID != null) {
            nbt.m_128362_("Owner", this.shooterUUID);
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.shooterUUID = nbt.m_128441_("Owner") ? nbt.m_128342_("Owner") : null;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_5602_(@Nullable Entity entityIn) {
        super.m_5602_(entityIn);
        if (entityIn != null) {
            this.shooterUUID = entityIn.m_20148_();
        }
    }

    public boolean m_20068_() {
        return this.forceNoGravity || super.m_20068_();
    }
}

