/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import com.google.common.base.CaseFormat;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;

public abstract class SpellPiece {
    @OnlyIn(value=Dist.CLIENT)
    private static RenderType layer;
    private static final String TAG_KEY_LEGACY = "spellKey";
    private static final String TAG_KEY = "key";
    private static final String TAG_PARAMS = "params";
    private static final String TAG_COMMENT = "comment";
    private static final String PSI_PREFIX = "psi.spellparam.";
    public final ResourceLocation registryKey;
    public final Spell spell;
    public boolean isInGrid = false;
    public int x;
    public int y;
    private final Map<EnumSpellStat, StatLabel> statLabels = new HashMap<EnumSpellStat, StatLabel>();
    public String comment;
    public final Map<String, SpellParam<?>> params = new LinkedHashMap();
    public final Map<SpellParam<?>, SpellParam.Side> paramSides = new LinkedHashMap();

    public SpellPiece(Spell spell) {
        this.spell = spell;
        this.registryKey = PsiAPI.getSpellPieceKey(this.getClass());
        this.initParams();
    }

    public void initParams() {
    }

    public abstract EnumPieceType getPieceType();

    public abstract Class<?> getEvaluationType();

    public abstract Object evaluate() throws SpellCompilationException;

    public abstract Object execute(SpellContext var1) throws SpellRuntimeException;

    public Component getEvaluationTypeString() {
        Class<?> evalType = this.getEvaluationType();
        String evalStr = evalType == null ? "null" : CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, evalType.getSimpleName());
        MutableComponent s = Component.m_237115_((String)("psi.datatype." + evalStr));
        if (this.getPieceType() == EnumPieceType.CONSTANT) {
            s.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"psimisc.constant"));
        }
        return s;
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
    }

    public void addParam(SpellParam<?> param) {
        this.params.put(param.name, param);
        this.paramSides.put(param, SpellParam.Side.OFF);
    }

    public boolean isInputSide(SpellParam.Side side) {
        return this.paramSides.containsValue((Object)side);
    }

    public <T> T getParamValueOrDefault(SpellContext context, SpellParam<T> param, T def) throws SpellRuntimeException {
        try {
            T v = this.getParamValue(context, param);
            return v == null ? def : v;
        }
        catch (SpellRuntimeException e) {
            return def;
        }
    }

    public <T> T getNonnullParamValue(SpellContext context, SpellParam<T> param) throws SpellRuntimeException {
        T v = this.getParamValue(context, param);
        if (v == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        return v;
    }

    public <T> T getParamValue(SpellContext context, SpellParam<T> param) throws SpellRuntimeException {
        Number number;
        Object returnValue = this.getRawParamValue(context, param);
        if (returnValue instanceof Number && (Double.isNaN((number = (Number)returnValue).doubleValue()) || Double.isInfinite(number.doubleValue()))) {
            throw new SpellRuntimeException("psi.spellerror.nan");
        }
        return (T)returnValue;
    }

    public Object getRawParamValue(SpellContext context, SpellParam<?> param) {
        SpellParam.Side side = this.paramSides.get(param);
        if (!side.isEnabled()) {
            return null;
        }
        try {
            SpellPiece piece = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, side);
            if (piece == null || !param.canAccept(piece)) {
                return null;
            }
            return context.evaluatedObjects[piece.x][piece.y];
        }
        catch (SpellCompilationException e) {
            return null;
        }
    }

    public <T> T getParamEvaluationeOrDefault(SpellParam<T> param, T def) throws SpellCompilationException {
        T v = this.getParamEvaluation(param);
        return v == null ? def : v;
    }

    public <T> T getNonNullParamEvaluation(SpellParam<T> param) throws SpellCompilationException {
        T v = this.getParamEvaluation(param);
        if (v == null) {
            throw new SpellCompilationException("psi.spellerror.nullparam", this.x, this.y);
        }
        return v;
    }

    public <T> T getParamEvaluation(SpellParam<?> param) throws SpellCompilationException {
        SpellParam.Side side = this.paramSides.get(param);
        if (!side.isEnabled()) {
            return null;
        }
        SpellPiece piece = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, side);
        if (piece == null || !param.canAccept(piece)) {
            return null;
        }
        return (T)piece.evaluate();
    }

    public String getUnlocalizedName() {
        return this.registryKey.m_135827_() + ".spellpiece." + this.registryKey.m_135815_();
    }

    public String getSortingName() {
        return Component.m_237115_((String)this.getUnlocalizedName()).getString();
    }

    public String getUnlocalizedDesc() {
        return this.registryKey.m_135827_() + ".spellpiece." + this.registryKey.m_135815_() + ".desc";
    }

    public void setStatLabel(EnumSpellStat type, StatLabel descriptor) {
        this.statLabels.put(type, descriptor);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack ms, MultiBufferSource buffers, int light) {
        ms.m_85836_();
        this.drawBackground(ms, buffers, light);
        ms.m_85837_(0.0, 0.0, (double)0.1f);
        this.drawAdditional(ms, buffers, light);
        if (this.isInGrid) {
            ms.m_85837_(0.0, 0.0, (double)0.1f);
            this.drawParams(ms, buffers, light);
            ms.m_85837_(0.0, 0.0, (double)0.1f);
            this.drawComment(ms, buffers, light);
        }
        ms.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getLayer() {
        if (layer == null) {
            RenderType.CompositeState glState = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172814_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ClientPsiAPI.PSI_PIECE_TEXTURE_ATLAS, false, false)).m_110671_(new RenderStateShard.LightmapStateShard(true)).m_110685_(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
                RenderSystem.m_69478_();
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }, () -> {
                RenderSystem.m_69461_();
                RenderSystem.m_69453_();
            })).m_110661_(new RenderStateShard.CullStateShard(false)).m_110691_(false);
            layer = RenderType.m_173209_((String)ClientPsiAPI.PSI_PIECE_TEXTURE_ATLAS.toString(), (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)64, (RenderType.CompositeState)glState);
        }
        return layer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(PoseStack ms, MultiBufferSource buffers, int light) {
        Material material = ClientPsiAPI.getSpellPieceMaterial(this.registryKey);
        VertexConsumer buffer = material.m_119194_(buffers, ignored -> SpellPiece.getLayer());
        Matrix4f mat = ms.m_85850_().m_85861_();
        buffer.m_85982_(mat, 0.0f, 16.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, 16.0f, 16.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, 16.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditional(PoseStack ms, MultiBufferSource buffers, int light) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawComment(PoseStack ms, MultiBufferSource buffers, int light) {
        if (this.comment != null && !this.comment.isEmpty()) {
            VertexConsumer buffer = buffers.m_6299_(PsiAPI.internalHandler.getProgrammerLayer());
            float wh = 6.0f;
            float minU = 0.5859375f;
            float minV = 0.71875f;
            float maxU = (150.0f + wh) / 256.0f;
            float maxV = (184.0f + wh) / 256.0f;
            Matrix4f mat = ms.m_85850_().m_85861_();
            buffer.m_85982_(mat, -2.0f, 4.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, maxV).m_85969_(light).m_5752_();
            buffer.m_85982_(mat, 4.0f, 4.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_85969_(light).m_5752_();
            buffer.m_85982_(mat, 4.0f, -2.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, minV).m_85969_(light).m_5752_();
            buffer.m_85982_(mat, -2.0f, -2.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV).m_85969_(light).m_5752_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawParams(PoseStack ms, MultiBufferSource buffers, int light) {
        VertexConsumer buffer = buffers.m_6299_(PsiAPI.internalHandler.getProgrammerLayer());
        for (SpellParam<?> param : this.paramSides.keySet()) {
            this.drawParam(ms, buffer, light, param);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawParam(PoseStack ms, VertexConsumer buffer, int light, SpellParam<?> param) {
        SpellParam.Side side = this.paramSides.get(param);
        if (!side.isEnabled() || param.getArrowType() == SpellParam.ArrowType.NONE) {
            return;
        }
        int index = this.getParamArrowIndex(param);
        int count = this.getParamArrowCount(side);
        SpellPiece neighbour = this.spell.grid.getPieceAtSideSafely(this.x, this.y, side);
        if (neighbour != null) {
            int nbcount = neighbour.getParamArrowCount(side.getOpposite());
            if (side.asInt() > side.getOpposite().asInt()) {
                index += nbcount;
            }
            count += nbcount;
        }
        float percent = 0.5f;
        if (count > 1) {
            percent = (float)index / (float)(count - 1);
        }
        this.drawParam(ms, buffer, light, side, param.color, param.getArrowType(), percent);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawParam(PoseStack ms, VertexConsumer buffer, int light, SpellParam.Side side, int color, SpellParam.ArrowType arrowType, float percent) {
        if (arrowType == SpellParam.ArrowType.NONE) {
            return;
        }
        float minX = 4.0f + (float)side.minx * percent + (float)side.maxx * (1.0f - percent);
        float minY = 4.0f + (float)side.miny * percent + (float)side.maxy * (1.0f - percent);
        float maxX = minX + 8.0f;
        float maxY = minY + 8.0f;
        if (arrowType == SpellParam.ArrowType.OUT) {
            side = side.getOpposite();
        }
        float wh = 8.0f;
        float minU = (float)side.u / 256.0f;
        float minV = (float)side.v / 256.0f;
        float maxU = ((float)side.u + wh) / 256.0f;
        float maxV = ((float)side.v + wh) / 256.0f;
        int r = PsiRenderHelper.r(color);
        int g = PsiRenderHelper.g(color);
        int b = PsiRenderHelper.b(color);
        int a = 255;
        Matrix4f mat = ms.m_85850_().m_85861_();
        buffer.m_85982_(mat, minX, maxY, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, maxX, maxY, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, maxX, minY, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, minX, minY, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, minV).m_85969_(light).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getParamArrowCount(SpellParam.Side side) {
        int count = 0;
        for (SpellParam<?> p : this.paramSides.keySet()) {
            if (p.getArrowType() == SpellParam.ArrowType.NONE || this.paramSides.get(p) != side) continue;
            ++count;
        }
        return count;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getParamArrowIndex(SpellParam<?> param) {
        SpellParam.Side side = this.paramSides.get(param);
        int count = 0;
        for (SpellParam<?> p : this.paramSides.keySet()) {
            if (p == param) {
                return count;
            }
            if (p.getArrowType() == SpellParam.ArrowType.NONE || this.paramSides.get(p) != side) continue;
            ++count;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTooltip(PoseStack ms, int tooltipX, int tooltipY, List<Component> tooltip, Screen screen) {
        PsiAPI.internalHandler.renderTooltip(ms, tooltipX, tooltipY, tooltip, 0x505000FF, -267386864, screen.f_96543_, screen.f_96544_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawCommentText(PoseStack ms, int tooltipX, int tooltipY, List<Component> commentText, Screen screen) {
        PsiAPI.internalHandler.renderTooltip(ms, tooltipX, tooltipY - 9 - commentText.size() * 10, commentText, 0x5000A000, -268427776, screen.f_96543_, screen.f_96544_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getTooltip(List<Component> tooltip) {
        String addon;
        tooltip.add((Component)Component.m_237115_((String)this.getUnlocalizedName()));
        tooltip.add((Component)Component.m_237115_((String)this.getUnlocalizedDesc()).m_130940_(ChatFormatting.GRAY));
        TooltipHelper.tooltipIfShift(tooltip, () -> this.addToTooltipAfterShift(tooltip));
        if (!this.statLabels.isEmpty()) {
            TooltipHelper.tooltipIfCtrl(tooltip, () -> this.addToTooltipAfterCtrl(tooltip));
        }
        if (!(addon = this.registryKey.m_135827_()).equals("psi") && ModList.get().getModContainerById(addon).isPresent()) {
            tooltip.add((Component)Component.m_237110_((String)"psimisc.provider_mod", (Object[])new Object[]{((ModContainer)ModList.get().getModContainerById(addon).get()).getNamespace()}));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addToTooltipAfterShift(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237113_((String)""));
        MutableComponent eval = this.getEvaluationTypeString().m_6879_().m_130940_(ChatFormatting.GOLD);
        tooltip.add((Component)Component.m_237113_((String)"Output ").m_7220_((Component)eval));
        for (SpellParam<?> param : this.paramSides.keySet()) {
            MutableComponent pName = Component.m_237115_((String)param.name).m_130940_(ChatFormatting.YELLOW);
            MutableComponent pEval = Component.m_237113_((String)" [").m_7220_(param.getRequiredTypeString()).m_130946_("]").m_130940_(ChatFormatting.YELLOW);
            tooltip.add((Component)Component.m_237113_((String)(param.canDisable ? "[Input] " : " Input  ")).m_7220_((Component)pName).m_7220_((Component)pEval));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addToTooltipAfterCtrl(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237113_((String)""));
        this.statLabels.forEach((type, stat) -> {
            tooltip.add((Component)Component.m_237115_((String)type.getName()).m_130946_(":"));
            tooltip.add((Component)Component.m_237113_((String)(" " + stat.toString())).m_130940_(ChatFormatting.YELLOW));
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean interceptKeystrokes() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onCharTyped(char character, int keyCode, boolean doit) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onKeyPressed(int keyCode, int scanCode, boolean doit) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasConfig() {
        return !this.params.isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getShownPieces(List<SpellPiece> pieces) {
        pieces.add(this);
    }

    public static SpellPiece createFromNBT(Spell spell, CompoundTag cmp) {
        Object key = cmp.m_128441_(TAG_KEY_LEGACY) ? cmp.m_128461_(TAG_KEY_LEGACY) : cmp.m_128461_(TAG_KEY);
        if (((String)key).startsWith("_")) {
            key = PSI_PREFIX + ((String)key).substring(1);
        }
        try {
            key = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, (String)key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean exists = false;
        ResourceLocation rl = new ResourceLocation((String)key);
        if (PsiAPI.isPieceRegistered(rl)) {
            exists = true;
        } else {
            Set pieceNamespaces = PsiAPI.getSpellPieceRegistry().m_6566_().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
            for (String namespace : pieceNamespaces) {
                rl = new ResourceLocation(namespace, (String)key);
                if (!PsiAPI.isPieceRegistered(rl)) continue;
                exists = true;
                break;
            }
        }
        if (exists) {
            Class<? extends SpellPiece> clazz = PsiAPI.getSpellPiece(rl);
            SpellPiece p = SpellPiece.create(clazz, spell);
            p.readFromNBT(cmp);
            return p;
        }
        return null;
    }

    public static SpellPiece create(Class<? extends SpellPiece> clazz, Spell spell) {
        try {
            return clazz.getConstructor(Spell.class).newInstance(spell);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SpellPiece copy() {
        CompoundTag cmp = new CompoundTag();
        this.writeToNBT(cmp);
        return SpellPiece.createFromNBT(this.spell, cmp);
    }

    public SpellPiece copyFromSpell(Spell spell) {
        CompoundTag cmp = new CompoundTag();
        this.writeToNBT(cmp);
        return SpellPiece.createFromNBT(spell, cmp);
    }

    public void readFromNBT(CompoundTag cmp) {
        CompoundTag paramCmp = cmp.m_128469_(TAG_PARAMS);
        for (String s : this.params.keySet()) {
            SpellParam<?> param = this.params.get(s);
            Object key = s;
            if (paramCmp.m_128441_((String)key)) {
                this.paramSides.put(param, SpellParam.Side.fromInt(paramCmp.m_128451_((String)key)));
                continue;
            }
            if (((String)key).startsWith(PSI_PREFIX)) {
                key = "_" + ((String)key).substring(PSI_PREFIX.length());
            }
            this.paramSides.put(param, SpellParam.Side.fromInt(paramCmp.m_128451_((String)key)));
        }
        this.comment = cmp.m_128461_(TAG_COMMENT);
    }

    public void writeToNBT(CompoundTag cmp) {
        if (this.comment == null) {
            this.comment = "";
        }
        cmp.m_128359_(TAG_KEY, this.registryKey.toString().replaceAll("^psi.spellparam.", "_"));
        int paramCount = 0;
        CompoundTag paramCmp = new CompoundTag();
        for (String s : this.params.keySet()) {
            SpellParam<?> param = this.params.get(s);
            SpellParam.Side side = this.paramSides.get(param);
            paramCmp.m_128405_(s.replaceAll("^psi.spellparam.", "_"), side.asInt());
            ++paramCount;
        }
        if (paramCount > 0) {
            cmp.m_128365_(TAG_PARAMS, (Tag)paramCmp);
        }
        if (!this.comment.isEmpty()) {
            cmp.m_128359_(TAG_COMMENT, this.comment);
        }
    }
}

