/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.CompiledSpell;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.core.helper.SharingHelper;
import vazkii.psi.client.gui.button.GuiButtonHelp;
import vazkii.psi.client.gui.button.GuiButtonIO;
import vazkii.psi.client.gui.button.GuiButtonSideConfig;
import vazkii.psi.client.gui.widget.CallbackTextFieldWidget;
import vazkii.psi.client.gui.widget.PiecePanelWidget;
import vazkii.psi.client.gui.widget.SideConfigWidget;
import vazkii.psi.client.gui.widget.SpellCostsWidget;
import vazkii.psi.client.gui.widget.StatusWidget;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageSpellModified;
import vazkii.psi.common.spell.SpellCompiler;
import vazkii.psi.common.spell.other.PieceConnector;
import vazkii.psi.mixin.client.AccessorRenderState;

public class GuiProgrammer
extends Screen {
    public static final ResourceLocation texture = new ResourceLocation("psi:textures/gui/programmer.png");
    public static final RenderType LAYER;
    public final TileProgrammer programmer;
    public Spell spell;
    public List<Component> tooltip = new ArrayList<Component>();
    public final Stack<Spell> undoSteps = new Stack();
    public final Stack<Spell> redoSteps = new Stack();
    public static SpellPiece clipboard;
    public Either<CompiledSpell, SpellCompilationException> compileResult;
    public int xSize;
    public int ySize;
    public int padLeft;
    public int padTop;
    public int left;
    public int top;
    public int gridLeft;
    public int gridTop;
    public int cursorX;
    public int cursorY;
    public static int selectedX;
    public static int selectedY;
    public boolean commentEnabled;
    public GuiButtonHelp helpButton;
    public EditBox spellNameField;
    public EditBox commentField;
    public PiecePanelWidget panelWidget;
    public SideConfigWidget configWidget;
    public SpellCostsWidget spellCostsWidget;
    public StatusWidget statusWidget;
    public TooltipFlag tooltipFlag;
    public boolean mouseMoved = false;
    public boolean takingScreenshot = false;
    public boolean shareToReddit = false;
    boolean spectator;

    public GuiProgrammer(TileProgrammer programmer) {
        this(programmer, programmer.spell);
    }

    public GuiProgrammer(TileProgrammer tile, Spell spell) {
        super((Component)Component.m_237119_());
        this.programmer = tile;
        this.spell = spell;
        this.compileResult = new SpellCompiler().compile(spell);
    }

    public void m_94757_(double xPos, double mouseY) {
        this.mouseMoved = true;
    }

    protected void m_7856_() {
        this.xSize = 174;
        this.ySize = 184;
        this.padLeft = 7;
        this.padTop = 7;
        this.left = (this.f_96543_ - this.xSize) / 2;
        this.top = (this.f_96544_ - this.ySize) / 2;
        this.gridLeft = this.left + this.padLeft;
        this.gridTop = this.top + this.padTop;
        this.cursorY = -1;
        this.cursorX = -1;
        TooltipFlag.Default default_ = this.tooltipFlag = this.getMinecraft().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        this.spectator = this.programmer == null ? false : !this.programmer.playerLock.isEmpty() && !this.programmer.playerLock.equals(this.getMinecraft().f_91074_.m_7755_().getString());
        this.statusWidget = (StatusWidget)this.m_142416_((GuiEventListener)new StatusWidget(this.left - 48, this.top + 5, 48, 30, "", this));
        this.spellCostsWidget = (SpellCostsWidget)this.m_142416_((GuiEventListener)new SpellCostsWidget(this.left + this.xSize + 3, this.top + (this.takingScreenshot ? 40 : 20), 100, 126, "", this));
        this.panelWidget = (PiecePanelWidget)this.m_142416_(new PiecePanelWidget(0, 0, 100, 125, "", this));
        this.helpButton = (GuiButtonHelp)this.m_142416_((GuiEventListener)new GuiButtonHelp(this.left + this.xSize + 2, this.top + this.ySize - (this.spectator ? 32 : 48), this));
        this.configWidget = (SideConfigWidget)this.m_142416_((GuiEventListener)new SideConfigWidget(this.left - 81, this.top + 55, 81, 115, this));
        this.spellNameField = (EditBox)this.m_142416_((GuiEventListener)new CallbackTextFieldWidget(this.getMinecraft().f_91062_, this.left + this.xSize - 130, this.top + this.ySize - 14, 120, 10, button -> {
            this.spell.name = this.spellNameField.m_94155_();
            this.onSpellChanged(true);
        }));
        this.spellNameField.m_94182_(false);
        this.spellNameField.m_94199_(20);
        this.spellNameField.m_94186_(!this.spectator);
        this.commentField = (EditBox)this.m_142416_((GuiEventListener)new CallbackTextFieldWidget(this.getMinecraft().f_91062_, this.left, this.top + this.ySize / 2 - 10, this.xSize, 20, button -> {}));
        this.commentField.m_94186_(false);
        this.commentField.m_94194_(false);
        this.commentField.m_94199_(500);
        this.panelWidget.searchField = (EditBox)this.m_142416_((GuiEventListener)new CallbackTextFieldWidget(this.getMinecraft().f_91062_, 0, 0, 70, 10, button -> {
            this.panelWidget.page = 0;
            this.panelWidget.updatePanelButtons();
        }));
        this.panelWidget.searchField.m_94186_(false);
        this.panelWidget.searchField.m_94194_(false);
        this.panelWidget.searchField.m_94182_(false);
        if (this.spell == null) {
            this.spell = new Spell();
        }
        if (this.programmer != null && this.programmer.spell == null) {
            this.programmer.spell = this.spell;
        }
        this.spellNameField.m_94144_(this.spell.name);
        this.panelWidget.populatePanelButtons();
        this.onSelectedChanged();
        this.m_142416_((GuiEventListener)new GuiButtonIO(this.left + this.xSize + 2, this.top + this.ySize - (this.spectator ? 16 : 32), true, this, button -> {
            if (GuiProgrammer.m_96638_()) {
                CompoundTag cmp = new CompoundTag();
                if (this.spell != null) {
                    this.spell.writeToNBT(cmp);
                }
                this.getMinecraft().f_91068_.m_90911_(cmp.toString());
            }
        }));
        if (!this.spectator) {
            this.m_142416_((GuiEventListener)new GuiButtonIO(this.left + this.xSize + 2, this.top + this.ySize - 16, false, this, button -> {
                if (GuiProgrammer.m_96638_()) {
                    String cb = this.getMinecraft().f_91068_.m_90876_();
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    try {
                        cb = cb.replaceAll("([^a-z0-9])\\d+:", "$1");
                        CompoundTag cmp = TagParser.m_129359_((String)cb);
                        if (cmp.m_128441_("modsRequired")) {
                            ListTag mods = (ListTag)cmp.m_128423_("modsRequired");
                            for (Tag mod : mods) {
                                String modName = ((CompoundTag)mod).m_128461_("modName");
                                if (!PsiAPI.getSpellPieceRegistry().m_6566_().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet()).contains(modName)) {
                                    player.m_213846_((Component)Component.m_237110_((String)"psimisc.modnotfound", (Object[])new Object[]{modName}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                                }
                                if (!modName.equals("psi")) continue;
                                boolean sendMessage = false;
                                String modVersion = ((CompoundTag)mod).m_128461_("modVersion");
                                int[] versionEntry = Arrays.stream(modVersion.replaceFirst("^\\D+", "").split("\\D+")).mapToInt(Integer::parseInt).toArray();
                                int[] currentVersion = Arrays.stream(((ModContainer)ModList.get().getModContainerById("psi").get()).getModInfo().getVersion().toString().replaceFirst("^\\D+", "").split("\\D+")).mapToInt(Integer::parseInt).toArray();
                                for (int i = 0; i < versionEntry.length; ++i) {
                                    if (i + 1 > currentVersion.length) {
                                        sendMessage = true;
                                        break;
                                    }
                                    if (currentVersion[i] > versionEntry[i]) break;
                                    if (currentVersion[i] >= versionEntry[i]) continue;
                                    sendMessage = true;
                                    break;
                                }
                                if (!sendMessage) continue;
                                player.m_213846_((Component)Component.m_237115_((String)"psimisc.spellonnewerversion").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                            }
                        } else {
                            player.m_213846_((Component)Component.m_237115_((String)"psimisc.spellmaynotfunctionasintended").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                        }
                        this.spell = Spell.createFromNBT(cmp);
                        if (this.spell == null) {
                            return;
                        }
                        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((Player)player);
                        for (int i = 0; i < 9; ++i) {
                            for (int j = 0; j < 9; ++j) {
                                SpellPiece piece = this.spell.grid.gridData[i][j];
                                if (piece == null) continue;
                                ResourceLocation group = PsiAPI.getGroupForPiece(piece.getClass());
                                if (player.m_7500_() || group != null && data.isPieceGroupUnlocked(group, piece.registryKey)) continue;
                                player.m_213846_((Component)Component.m_237115_((String)"psimisc.missing_pieces").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                                return;
                            }
                        }
                        this.pushState(true);
                        this.spellNameField.m_94144_(this.spell.name);
                        this.onSpellChanged(false);
                    }
                    catch (Exception t) {
                        player.m_213846_((Component)Component.m_237110_((String)"psimisc.malformed_json", (Object[])new Object[]{t.getMessage()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                        Psi.logger.error("Error importing spell from clipboard", (Throwable)t);
                    }
                }
            }));
        }
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        if (!(this.programmer == null || this.programmer.m_58904_().m_7702_(this.programmer.m_58899_()) == this.programmer && this.programmer.canPlayerInteract((Player)this.getMinecraft().f_91074_))) {
            this.getMinecraft().m_91152_(null);
            return;
        }
        String comment = "";
        int color = Psi.magical ? 0 : 0xFFFFFF;
        ms.m_85836_();
        this.m_7333_(ms);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        this.m_93228_(ms, this.left, this.top, 0, 0, this.xSize, this.ySize);
        SpellPiece piece = null;
        if (SpellGrid.exists(selectedX, selectedY)) {
            piece = this.spell.grid.gridData[selectedX][selectedY];
        }
        this.cursorX = (mouseX - this.gridLeft) / 18;
        this.cursorY = (mouseY - this.gridTop) / 18;
        if (this.panelWidget.panelEnabled || this.cursorX > 8 || this.cursorY > 8 || this.cursorX < 0 || this.cursorY < 0 || mouseX < this.gridLeft || mouseY < this.gridTop) {
            this.cursorX = -1;
            this.cursorY = -1;
        }
        ms.m_85836_();
        this.tooltip.clear();
        ms.m_85837_((double)this.gridLeft, (double)this.gridTop, 0.0);
        MultiBufferSource.BufferSource buffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        this.spell.draw(ms, (MultiBufferSource)buffers, 0xF000F0);
        buffers.m_109911_();
        this.compileResult.right().ifPresent(ex -> {
            Pair<Integer, Integer> errorPos = ex.location;
            if (errorPos != null && (Integer)errorPos.getRight() != -1 && (Integer)errorPos.getLeft() != -1) {
                this.f_96547_.m_92750_(ms, "!!", (float)((Integer)errorPos.getLeft() * 18 + 12), (float)((Integer)errorPos.getRight() * 18 + 8), 0xFF0000);
            }
        });
        ms.m_85849_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ms.m_85837_(0.0, 0.0, 1.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        if (selectedX != -1 && selectedY != -1 && !this.takingScreenshot) {
            this.m_93228_(ms, this.gridLeft + selectedX * 18, this.gridTop + selectedY * 18, 32, this.ySize, 16, 16);
        }
        if (GuiProgrammer.m_96639_()) {
            this.tooltip.clear();
            this.cursorX = selectedX;
            this.cursorY = selectedY;
            mouseX = this.gridLeft + this.cursorX * 18 + 10;
            mouseY = this.gridTop + this.cursorY * 18 + 8;
        }
        if (this.takingScreenshot) {
            Set addons = this.spell.getPieceNamespaces().stream().filter(namespace -> !namespace.equals("psi")).collect(Collectors.toSet());
            if (addons.size() > 0) {
                String requiredAddons = ChatFormatting.GREEN + "Required Addons:";
                this.f_96547_.m_92750_(ms, requiredAddons, (float)(this.left - this.f_96547_.m_92895_(requiredAddons) - 5), (float)(this.top + 40), 0xFFFFFF);
                int i = 1;
                for (String addon : addons) {
                    if (!ModList.get().getModContainerById(addon).isPresent()) continue;
                    String modName = ((ModContainer)ModList.get().getModContainerById(addon).get()).getModInfo().getDisplayName();
                    this.f_96547_.m_92750_(ms, "* " + modName, (float)(this.left - this.f_96547_.m_92895_(requiredAddons) - 5), (float)(this.top + 40 + 10 * i), 0xFFFFFF);
                    ++i;
                }
            }
            String version = "Psi " + ((ModContainer)ModList.get().getModContainerById("psi").get()).getModInfo().getVersion().toString();
            this.f_96547_.m_92750_(ms, version, (float)this.left + (float)this.xSize / 2.0f - (float)this.f_96547_.m_92895_(version) / 2.0f, (float)(this.top - 22), 0xFFFFFF);
        }
        SpellPiece pieceAtCursor = null;
        if (this.cursorX != -1 && this.cursorY != -1) {
            pieceAtCursor = this.spell.grid.gridData[this.cursorX][this.cursorY];
            if (pieceAtCursor != null) {
                pieceAtCursor.getTooltip(this.tooltip);
                comment = pieceAtCursor.comment;
            }
            if (!this.takingScreenshot) {
                if (this.cursorX == selectedX && this.cursorY == selectedY) {
                    this.m_93228_(ms, this.gridLeft + this.cursorX * 18, this.gridTop + this.cursorY * 18, 16, this.ySize, 8, 16);
                } else {
                    this.m_93228_(ms, this.gridLeft + this.cursorX * 18, this.gridTop + this.cursorY * 18, 16, this.ySize, 16, 16);
                }
            }
        }
        int topY = this.top - 22;
        if (!this.takingScreenshot) {
            int topYText = topY;
            if (this.spectator) {
                String spectator = ChatFormatting.RED + I18n.m_118938_((String)"psimisc.spectator", (Object[])new Object[0]);
                this.f_96547_.m_92750_(ms, spectator, (float)this.left + (float)this.xSize / 2.0f - (float)this.f_96547_.m_92895_(spectator) / 2.0f, (float)topYText, 0xFFFFFF);
                topYText -= 10;
            }
            if (piece != null) {
                String pieceName = I18n.m_118938_((String)piece.getUnlocalizedName(), (Object[])new Object[0]);
                this.f_96547_.m_92750_(ms, pieceName, (float)this.left + (float)this.xSize / 2.0f - (float)this.f_96547_.m_92895_(pieceName) / 2.0f, (float)topYText, 0xFFFFFF);
                topYText -= 10;
            }
            String coords = SpellGrid.exists(this.cursorX, this.cursorY) ? I18n.m_118938_((String)"psimisc.programmer_coords", (Object[])new Object[]{GuiProgrammer.convertIntToLetter(selectedX + 1), selectedY + 1, GuiProgrammer.convertIntToLetter(this.cursorX + 1), this.cursorY + 1}) : I18n.m_118938_((String)"psimisc.programmer_coords_no_cursor", (Object[])new Object[]{GuiProgrammer.convertIntToLetter(selectedX + 1), selectedY + 1});
            this.f_96547_.m_92883_(ms, coords, (float)(this.left + 4), (float)(topY + this.ySize + 24), 0x44FFFFFF);
            String version = "Psi " + ((ModContainer)ModList.get().getModContainerById("psi").get()).getModInfo().getVersion().toString();
            this.f_96547_.m_92750_(ms, version, (float)this.left + (float)this.xSize / 2.0f - (float)this.f_96547_.m_92895_(version) / 2.0f, (float)(topY + this.ySize + 24 + this.f_96547_.m_92920_(coords, this.f_96547_.m_92895_(coords)) + 5), 0x44FFFFFF);
        }
        if (Psi.magical) {
            this.f_96547_.m_92883_(ms, I18n.m_118938_((String)"psimisc.name", (Object[])new Object[0]), (float)(this.left + this.padLeft), (float)(this.spellNameField.f_93621_ + 1), color);
        } else {
            this.f_96547_.m_92750_(ms, I18n.m_118938_((String)"psimisc.name", (Object[])new Object[0]), (float)(this.left + this.padLeft), (float)(this.spellNameField.f_93621_ + 1), color);
        }
        if (this.commentEnabled) {
            String enterCommit = I18n.m_118938_((String)"psimisc.enter_commit", (Object[])new Object[0]);
            this.f_96547_.m_92750_(ms, enterCommit, (float)this.left + (float)this.xSize / 2.0f - (float)this.f_96547_.m_92895_(enterCommit) / 2.0f, (float)(this.commentField.f_93621_ + 24), 0xFFFFFF);
            String semicolonLine = I18n.m_118938_((String)"psimisc.semicolon_line", (Object[])new Object[0]);
            this.f_96547_.m_92750_(ms, semicolonLine, (float)this.left + (float)this.xSize / 2.0f - (float)this.f_96547_.m_92895_(semicolonLine) / 2.0f, (float)(this.commentField.f_93621_ + 34), 0xFFFFFF);
        }
        ArrayList<Component> legitTooltip = null;
        if (GuiProgrammer.m_96639_()) {
            legitTooltip = new ArrayList<Component>(this.tooltip);
        }
        if (GuiProgrammer.m_96639_()) {
            this.tooltip = legitTooltip;
        }
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        if (!this.takingScreenshot && this.tooltip != null && !this.tooltip.isEmpty() && pieceAtCursor == null && this.mouseMoved) {
            this.m_96597_(ms, this.tooltip, mouseX, mouseY);
        }
        if (!this.takingScreenshot && pieceAtCursor != null && this.mouseMoved) {
            if (this.tooltip != null && !this.tooltip.isEmpty()) {
                pieceAtCursor.drawTooltip(ms, mouseX, mouseY, this.tooltip, this);
            }
            if (comment != null && !comment.isEmpty()) {
                List<Component> commentList = Arrays.stream(comment.split(";")).map(Component::m_237113_).collect(Collectors.toList());
                pieceAtCursor.drawCommentText(ms, mouseX, mouseY, commentList, this);
            }
        }
        ms.m_85849_();
        if (this.takingScreenshot) {
            String name = this.spell.name;
            CompoundTag cmp = new CompoundTag();
            if (this.spell != null) {
                this.spell.writeToNBT(cmp);
            }
            String export = cmp.toString();
            if (this.shareToReddit) {
                SharingHelper.uploadAndShare(name, export);
            } else {
                SharingHelper.uploadAndOpen(name, export);
            }
            this.takingScreenshot = false;
            this.shareToReddit = false;
        }
    }

    public void removeButtons(List<Button> list) {
        this.removeButtonList(list);
    }

    private void removeButtonList(List<Button> list) {
        this.f_169369_.removeAll(list);
    }

    public void addButtons(List<Button> list) {
        list.forEach(x$0 -> {
            Button cfr_ignored_0 = (Button)this.m_142416_((GuiEventListener)x$0);
        });
    }

    public void pushState(boolean wipeRedo) {
        if (wipeRedo) {
            this.redoSteps.clear();
        }
        this.undoSteps.push(this.spell.copy());
        if (this.undoSteps.size() > 25) {
            this.undoSteps.remove(0);
        }
    }

    public void onSpellChanged(boolean nameOnly) {
        if (this.programmer != null) {
            if (!this.spectator) {
                MessageSpellModified message = new MessageSpellModified(this.programmer.m_58899_(), this.spell);
                MessageRegister.HANDLER.sendToServer((Object)message);
            }
            this.programmer.spell = this.spell;
            this.programmer.onSpellChanged();
        }
        this.onSelectedChanged();
        if (!nameOnly || this.compileResult.right().filter(ex -> ex.getMessage().equals("psi.spellerror.noname")).isPresent() || this.spell.name.isEmpty()) {
            this.compileResult = new SpellCompiler().compile(this.spell);
        }
    }

    public void onSelectedChanged() {
        SpellPiece piece;
        this.f_169369_.removeAll(this.configWidget.configButtons);
        this.m_6702_().removeAll(this.configWidget.configButtons);
        this.configWidget.configButtons.clear();
        this.spellNameField.m_94186_(!this.spectator);
        if (selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null) {
            boolean intercept = piece.interceptKeystrokes();
            this.spellNameField.m_94186_(!this.spectator && !intercept);
            if (piece.hasConfig()) {
                int i = 0;
                for (String paramName : piece.params.keySet()) {
                    SpellParam<?> param = piece.params.get(paramName);
                    int x = this.left - 17;
                    int y = this.top + 70 + i * 26;
                    for (SpellParam.Side side : ImmutableSet.of((Object)((Object)SpellParam.Side.TOP), (Object)((Object)SpellParam.Side.BOTTOM), (Object)((Object)SpellParam.Side.LEFT), (Object)((Object)SpellParam.Side.RIGHT), (Object)((Object)SpellParam.Side.OFF))) {
                        if (!side.isEnabled() && !param.canDisable) continue;
                        int xp = x + side.offx * 8;
                        int yp = y + side.offy * 8;
                        this.configWidget.configButtons.add(new GuiButtonSideConfig(this, selectedX, selectedY, i, paramName, side, xp, yp, button -> {
                            if (!this.spectator) {
                                this.pushState(true);
                                GuiButtonSideConfig.performAction(this, selectedX, selectedY, paramName, side);
                                this.onSpellChanged(false);
                            }
                        }));
                    }
                    ++i;
                }
                this.configWidget.configButtons.forEach(x$0 -> {
                    Button cfr_ignored_0 = (Button)this.m_142416_((GuiEventListener)x$0);
                });
                this.configWidget.configEnabled = true;
                return;
            }
        }
        this.configWidget.configEnabled = false;
    }

    public boolean m_5534_(char character, int keyCode) {
        SpellPiece piece;
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        if (this.spectator) {
            return false;
        }
        super.m_5534_(character, keyCode);
        if (!this.commentEnabled && !this.spellNameField.m_93696_() && selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null && piece.interceptKeystrokes() && piece.onCharTyped(character, keyCode, false)) {
            this.pushState(true);
            piece.onCharTyped(character, keyCode, true);
            this.onSpellChanged(false);
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.getMinecraft().f_91068_.m_90926_(true);
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        if (keyCode == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        if (this.spectator) {
            return true;
        }
        if (this.commentEnabled) {
            switch (keyCode) {
                case 257: {
                    this.closeComment(true);
                    return true;
                }
                case 256: {
                    this.closeComment(false);
                    return true;
                }
            }
        }
        SpellPiece piece = null;
        if (selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null && piece.interceptKeystrokes() && piece.onKeyPressed(keyCode, scanCode, false)) {
            this.pushState(true);
            piece.onKeyPressed(keyCode, scanCode, true);
            this.onSpellChanged(false);
            return true;
        }
        if (this.spellNameField.m_93696_() && keyCode == 258) {
            this.spellNameField.m_94178_(false);
            return true;
        }
        if (!(this.spellNameField.m_93696_() || this.panelWidget.panelEnabled || this.commentEnabled)) {
            int param = -1;
            for (int i = 0; i < 4; ++i) {
                if (!InputConstants.m_84830_((long)this.getMinecraft().m_91268_().m_85439_(), (int)(49 + i))) continue;
                param = i;
            }
            switch (keyCode) {
                case 259: 
                case 261: {
                    if (GuiProgrammer.m_96637_() && GuiProgrammer.m_96638_() && !this.spell.grid.isEmpty()) {
                        this.pushState(true);
                        this.spell = new Spell();
                        this.spellNameField.m_94144_("");
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (piece == null) break;
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                    this.onSpellChanged(false);
                    return true;
                }
                case 258: {
                    this.spellNameField.m_94178_(!this.spellNameField.m_93696_());
                    this.m_94718_((GuiEventListener)this.spellNameField);
                    return true;
                }
                case 265: {
                    if (GuiProgrammer.m_96637_()) {
                        if (GuiProgrammer.m_96638_()) {
                            this.pushState(true);
                            this.spell.grid.mirrorVertical();
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.TOP, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.TOP, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.TOP) || selectedY <= 0) break;
                    this.onSelectedChanged();
                    if (GuiProgrammer.m_96638_() && this.spell.grid.gridData[selectedX][--selectedY] == null) {
                        PieceConnector connector = new PieceConnector(this.spell);
                        connector.x = selectedX;
                        connector.y = selectedY;
                        connector.paramSides.put(connector.target, SpellParam.Side.BOTTOM);
                        this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = connector;
                        this.onSpellChanged(false);
                    }
                    return true;
                }
                case 263: {
                    if (GuiProgrammer.m_96637_()) {
                        if (GuiProgrammer.m_96638_()) {
                            this.pushState(true);
                            this.spell.grid.rotate(false);
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.LEFT, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.LEFT, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.LEFT) || selectedX <= 0) break;
                    this.onSelectedChanged();
                    if (GuiProgrammer.m_96638_() && this.spell.grid.gridData[--selectedX][selectedY] == null) {
                        PieceConnector connector = new PieceConnector(this.spell);
                        connector.x = selectedX;
                        connector.y = selectedY;
                        connector.paramSides.put(connector.target, SpellParam.Side.RIGHT);
                        this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = connector;
                        this.onSpellChanged(false);
                    }
                    return true;
                }
                case 262: {
                    if (GuiProgrammer.m_96637_()) {
                        if (GuiProgrammer.m_96638_()) {
                            this.pushState(true);
                            this.spell.grid.rotate(true);
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.RIGHT, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.RIGHT, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.RIGHT) || selectedX >= 8) break;
                    this.onSelectedChanged();
                    if (GuiProgrammer.m_96638_() && this.spell.grid.gridData[++selectedX][selectedY] == null) {
                        PieceConnector connector = new PieceConnector(this.spell);
                        connector.x = selectedX;
                        connector.y = selectedY;
                        connector.paramSides.put(connector.target, SpellParam.Side.LEFT);
                        this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = connector;
                        this.onSpellChanged(false);
                    }
                    return true;
                }
                case 264: {
                    if (GuiProgrammer.m_96637_()) {
                        if (GuiProgrammer.m_96638_()) {
                            this.pushState(true);
                            this.spell.grid.mirrorVertical();
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.BOTTOM, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.BOTTOM, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.BOTTOM) || selectedY >= 8) break;
                    this.onSelectedChanged();
                    if (GuiProgrammer.m_96638_() && this.spell.grid.gridData[selectedX][++selectedY] == null) {
                        PieceConnector connector = new PieceConnector(this.spell);
                        connector.x = selectedX;
                        connector.y = selectedY;
                        connector.paramSides.put(connector.target, SpellParam.Side.TOP);
                        this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = connector;
                        this.onSpellChanged(false);
                    }
                    return true;
                }
                case 90: {
                    if (!GuiProgrammer.m_96637_() || this.undoSteps.isEmpty()) break;
                    this.redoSteps.add(this.spell.copy());
                    this.spell = this.undoSteps.pop();
                    this.onSpellChanged(false);
                    return true;
                }
                case 89: {
                    if (!GuiProgrammer.m_96637_() || this.redoSteps.isEmpty()) break;
                    this.pushState(false);
                    this.spell = this.redoSteps.pop();
                    this.onSpellChanged(false);
                    return true;
                }
                case 67: {
                    if (piece == null || !GuiProgrammer.m_96637_()) break;
                    clipboard = piece.copy();
                    return true;
                }
                case 88: {
                    if (piece == null || !GuiProgrammer.m_96637_()) break;
                    clipboard = piece.copy();
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                    this.onSpellChanged(false);
                    return true;
                }
                case 86: {
                    if (!SpellGrid.exists(selectedX, selectedY) || clipboard == null || !GuiProgrammer.m_96637_()) break;
                    SpellPiece copy = clipboard.copy();
                    copy.x = selectedX;
                    copy.y = selectedY;
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = copy;
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY].isInGrid = true;
                    this.onSpellChanged(false);
                    return true;
                }
                case 68: {
                    if (piece == null || !GuiProgrammer.m_96637_()) break;
                    this.commentField.m_94194_(true);
                    this.commentField.m_94178_(true);
                    this.commentField.m_94186_(true);
                    this.spellNameField.m_94186_(false);
                    this.commentField.m_94144_(piece.comment);
                    this.commentField.m_94178_(true);
                    this.m_94718_((GuiEventListener)this.commentField);
                    this.commentEnabled = true;
                    return true;
                }
                case 71: {
                    if (!GuiProgrammer.m_96637_()) break;
                    this.shareToReddit = false;
                    if (GuiProgrammer.m_96638_() && GuiProgrammer.m_96639_()) {
                        this.takingScreenshot = true;
                    }
                    return true;
                }
                case 82: {
                    if (!GuiProgrammer.m_96637_()) break;
                    this.shareToReddit = true;
                    if (GuiProgrammer.m_96638_() && GuiProgrammer.m_96639_()) {
                        this.takingScreenshot = true;
                    }
                    return true;
                }
                case 257: {
                    this.panelWidget.openPanel();
                    return true;
                }
            }
        }
        if (this.panelWidget.panelEnabled) {
            this.panelWidget.m_7933_(keyCode, scanCode, modifiers);
        }
        if (this.commentField.m_93696_()) {
            this.commentField.m_7933_(keyCode, scanCode, modifiers);
        }
        if (this.spellNameField.m_93696_()) {
            this.spellNameField.m_7933_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean onSideButtonKeybind(SpellPiece piece, int param, SpellParam.Side side) {
        if (param > -1 && piece != null && piece.params.size() >= param) {
            for (Button button : this.configWidget.configButtons) {
                GuiButtonSideConfig config = (GuiButtonSideConfig)button;
                if (!config.matches(param, side)) continue;
                if (side != SpellParam.Side.OFF && piece.paramSides.get(piece.params.get(config.paramName)) == side) {
                    side = SpellParam.Side.OFF;
                    continue;
                }
                config.m_5691_();
                return true;
            }
        }
        return side == SpellParam.Side.OFF;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        if (!this.commentEnabled) {
            this.spellNameField.m_6375_(mouseX, mouseY, mouseButton);
            if (this.commentField.m_94213_()) {
                this.commentField.m_6375_(mouseX, mouseY, mouseButton);
            }
            if (this.cursorX != -1 && this.cursorY != -1) {
                selectedX = this.cursorX;
                selectedY = this.cursorY;
                if (mouseButton == 1 && !this.spectator && GuiProgrammer.m_96638_()) {
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                    this.onSpellChanged(false);
                    return true;
                }
                this.onSelectedChanged();
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean isSpectator() {
        return this.spectator;
    }

    private void closeComment(boolean save) {
        SpellPiece piece = null;
        if (selectedX != -1 && selectedY != -1) {
            piece = this.spell.grid.gridData[selectedX][selectedY];
        }
        if (save && piece != null) {
            String text = this.commentField.m_94155_();
            this.pushState(true);
            piece.comment = text;
            this.onSpellChanged(false);
        }
        this.spellNameField.m_94186_(!this.spectator && (piece == null || !piece.interceptKeystrokes()));
        this.commentField.m_94178_(false);
        this.commentField.m_94194_(false);
        this.commentField.m_94186_(false);
        this.commentField.m_94144_("");
        this.commentEnabled = false;
    }

    public boolean m_6913_() {
        return !this.panelWidget.panelEnabled && !this.commentEnabled;
    }

    public List<Widget> getButtons() {
        return this.f_169369_;
    }

    public boolean m_7043_() {
        return (Boolean)ConfigHandler.CLIENT.pauseGameInProgrammer.get();
    }

    public static String convertIntToLetter(int i) {
        if (!((Boolean)ConfigHandler.CLIENT.changeGridCoordinatesToLetterNumber.get()).booleanValue()) {
            return String.valueOf(i);
        }
        return String.valueOf((char)(i % 27 + 64));
    }

    static {
        RenderStateShard.TransparencyStateShard translucent = AccessorRenderState.getTranslucentTransprency();
        RenderType.CompositeState glState = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172814_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110671_(new RenderStateShard.LightmapStateShard(true)).m_110661_(new RenderStateShard.CullStateShard(false)).m_110685_(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> {
            RenderSystem.m_69461_();
            RenderSystem.m_69453_();
        })).m_110685_(translucent).m_110691_(false);
        LAYER = RenderType.m_173209_((String)"psi:programmer", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)128, (RenderType.CompositeState)glState);
        clipboard = null;
    }
}

