/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.render.entity;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.client.model.ArmorModels;
import vazkii.psi.common.Psi;
import vazkii.psi.common.entity.EntitySpellCircle;
import vazkii.psi.mixin.client.AccessorRenderType;

public class RenderSpellCircle
extends EntityRenderer<EntitySpellCircle> {
    private static final RenderType[] LAYERS = new RenderType[3];
    private static final float BRIGHTNESS_FACTOR = 0.7f;

    public RenderSpellCircle(EntityRendererProvider.Context ctx) {
        super(ctx);
        ArmorModels.init(ctx);
    }

    public void render(EntitySpellCircle entity, float entityYaw, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light) {
        ms.m_85836_();
        ItemStack colorizer = (ItemStack)entity.m_20088_().m_135370_(EntitySpellCircle.COLORIZER_DATA);
        int color = Psi.proxy.getColorForColorizer(colorizer);
        float alive = (float)entity.getTimeAlive() + partialTicks;
        float scale = Math.min(1.0f, alive / 5.0f);
        if (alive > 105.0f) {
            scale = 1.0f - Math.min(1.0f, Math.max(0.0f, alive - 105.0f) / 5.0f);
        }
        RenderSpellCircle.renderSpellCircle(alive, scale, 1.0f, 0.0f, 1.0f, 0.0f, color, ms, buffers);
        ms.m_85849_();
    }

    public static void renderSpellCircle(float alive, float scale, float horizontalScale, float xDir, float yDir, float zDir, int color, PoseStack ms, MultiBufferSource buffers) {
        ms.m_85836_();
        double ratio = 0.0625 * (double)horizontalScale;
        float mag = xDir * xDir + yDir * yDir + zDir * zDir;
        if ((zDir /= mag) == -1.0f) {
            ms.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        } else if (zDir != 1.0f) {
            ms.m_85845_(new Vector3f(-yDir / mag, xDir / mag, 0.0f).m_122240_((float)(Math.acos(zDir) * 180.0 / Math.PI)));
        }
        ms.m_85837_(0.0, 0.0, 0.1);
        ms.m_85841_((float)ratio * scale, (float)ratio * scale, (float)ratio);
        int r = PsiRenderHelper.r(color);
        int g = PsiRenderHelper.g(color);
        int b = PsiRenderHelper.b(color);
        for (int i = 0; i < LAYERS.length; ++i) {
            int rValue = r;
            int gValue = g;
            int bValue = b;
            if (i == 1) {
                bValue = 255;
                gValue = 255;
                rValue = 255;
            } else if (i == 2) {
                int minBrightness = 3;
                if (rValue == 0 && gValue == 0 && bValue == 0) {
                    gValue = bValue = minBrightness;
                    rValue = bValue;
                }
                if (rValue > 0 && rValue < minBrightness) {
                    rValue = minBrightness;
                }
                if (gValue > 0 && gValue < minBrightness) {
                    gValue = minBrightness;
                }
                if (bValue > 0 && bValue < minBrightness) {
                    bValue = minBrightness;
                }
                rValue = (int)Math.min((float)rValue / 0.7f, 255.0f);
                gValue = (int)Math.min((float)gValue / 0.7f, 255.0f);
                bValue = (int)Math.min((float)bValue / 0.7f, 255.0f);
            }
            ms.m_85836_();
            ms.m_85845_(Vector3f.f_122227_.m_122240_(i == 0 ? -alive : alive));
            VertexConsumer buffer = buffers.m_6299_(LAYERS[i]);
            Matrix4f mat = ms.m_85850_().m_85861_();
            int fullbright = 0xF000F0;
            buffer.m_85982_(mat, -32.0f, 32.0f, 0.0f).m_6122_(rValue, gValue, bValue, 255).m_7421_(0.0f, 1.0f).m_85969_(fullbright).m_5752_();
            buffer.m_85982_(mat, 32.0f, 32.0f, 0.0f).m_6122_(rValue, gValue, bValue, 255).m_7421_(1.0f, 1.0f).m_85969_(fullbright).m_5752_();
            buffer.m_85982_(mat, 32.0f, -32.0f, 0.0f).m_6122_(rValue, gValue, bValue, 255).m_7421_(1.0f, 0.0f).m_85969_(fullbright).m_5752_();
            buffer.m_85982_(mat, -32.0f, -32.0f, 0.0f).m_6122_(rValue, gValue, bValue, 255).m_7421_(0.0f, 0.0f).m_85969_(fullbright).m_5752_();
            ms.m_85849_();
            ms.m_85837_(0.0, 0.0, -0.5);
        }
        ms.m_85849_();
    }

    public ResourceLocation getTextureLocation(EntitySpellCircle entitySpellCircle) {
        return null;
    }

    static {
        for (int i = 0; i < LAYERS.length; ++i) {
            ResourceLocation texture = new ResourceLocation(String.format("psi:textures/misc/spell_circle%d.png", i));
            RenderType.CompositeState glState = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110661_(new RenderStateShard.CullStateShard(false)).m_173292_(RenderStateShard.f_173101_).m_110671_(new RenderStateShard.LightmapStateShard(true)).m_110691_(true);
            RenderSpellCircle.LAYERS[i] = AccessorRenderType.create("psi:spell_circle_" + i, DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, 64, false, false, glState);
        }
    }
}

