/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile.container;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.inventory.InventorySocketable;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.common.block.tile.TileCADAssembler;
import vazkii.psi.common.block.tile.container.slot.InventoryAssemblerOutput;
import vazkii.psi.common.block.tile.container.slot.SlotCADOutput;
import vazkii.psi.common.block.tile.container.slot.SlotSocketable;
import vazkii.psi.common.block.tile.container.slot.ValidatorSlot;

public class ContainerCADAssembler
extends AbstractContainerMenu {
    @ObjectHolder(registryName="minecraft:menu", value="psi:cad_assembler")
    public static MenuType<ContainerCADAssembler> TYPE;
    private static final EquipmentSlot[] equipmentSlots;
    public final TileCADAssembler assembler;
    private final int cadComponentStart;
    private final int socketableStart;
    private final int socketableEnd;
    private final int bulletStart;
    private final int bulletEnd;
    private final int playerStart;
    private final int playerEnd;
    private final int hotbarStart;
    private final int hotbarEnd;
    private final int armorStart;

    public static ContainerCADAssembler fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        return new ContainerCADAssembler(windowId, playerInventory, (TileCADAssembler)playerInventory.f_35978_.f_19853_.m_7702_(pos));
    }

    public ContainerCADAssembler(int windowId, Inventory playerInventory, TileCADAssembler assembler) {
        super(TYPE, windowId);
        final Player player = playerInventory.f_35978_;
        int playerSize = playerInventory.m_6643_();
        this.assembler = assembler;
        IItemHandlerModifiable assemblerInv = assembler.getInventory();
        assembler.clearCachedCAD();
        InventoryAssemblerOutput output = new InventoryAssemblerOutput(player, assembler);
        InventorySocketable bullets = new InventorySocketable(assembler.getSocketableStack());
        this.m_38897_(new SlotCADOutput(output, assembler, 120, 35));
        this.cadComponentStart = this.f_38839_.size();
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)assemblerInv, assembler.getComponentSlot(EnumCADComponent.ASSEMBLY), 120, 91));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)assemblerInv, assembler.getComponentSlot(EnumCADComponent.CORE), 100, 91));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)assemblerInv, assembler.getComponentSlot(EnumCADComponent.SOCKET), 140, 91));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)assemblerInv, assembler.getComponentSlot(EnumCADComponent.BATTERY), 110, 111));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)assemblerInv, assembler.getComponentSlot(EnumCADComponent.DYE), 130, 111));
        this.socketableStart = this.f_38839_.size();
        this.m_38897_((Slot)new SlotSocketable(assemblerInv, bullets, 0, 35, 21));
        this.socketableEnd = this.f_38839_.size();
        this.bulletStart = this.f_38839_.size();
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.m_38897_(new ValidatorSlot(bullets, col + row * 3, 17 + col * 18, 57 + row * 18));
            }
        }
        this.bulletEnd = this.f_38839_.size();
        int xs = 48;
        int ys = 143;
        this.playerStart = this.f_38839_.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, xs + col * 18, ys + row * 18));
            }
        }
        this.playerEnd = this.f_38839_.size();
        this.hotbarStart = this.f_38839_.size();
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, xs + col * 18, ys + 58));
        }
        this.hotbarEnd = this.f_38839_.size();
        this.armorStart = this.f_38839_.size();
        for (int armorSlot = 0; armorSlot < 4; ++armorSlot) {
            final EquipmentSlot slot = equipmentSlots[armorSlot];
            this.m_38897_(new Slot((Container)playerInventory, playerSize - 2 - armorSlot, xs - 27, ys + 18 * armorSlot){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack stack) {
                    return !stack.m_41619_() && stack.m_41720_().canEquip(stack, slot, (Entity)player);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39699_[slot.m_20749_()]);
                }
            });
        }
        this.m_38897_(new Slot((Container)playerInventory, playerSize - 1, 219, 143){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return !playerIn.m_213877_() && this.assembler.m_58899_().m_203193_((Position)playerIn.m_20182_()) <= 64.0;
    }

    @Nonnull
    public ItemStack m_7648_(Player playerIn, int from) {
        ItemStack mergeStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(from);
        if (slot != null && slot.m_6657_()) {
            ArmorItem armor;
            int armorSlot;
            EnumCADComponent componentType;
            int componentSlot;
            ItemStack stackInSlot = slot.m_7993_();
            mergeStack = stackInSlot.m_41777_();
            if (from >= this.playerStart ? (stackInSlot.m_41720_() instanceof ICADComponent ? !this.m_38903_(stackInSlot, componentSlot = this.cadComponentStart + (componentType = ((ICADComponent)stackInSlot.m_41720_()).getComponentType(stackInSlot)).ordinal(), componentSlot + 1, false) : (ISocketable.isSocketable(stackInSlot) ? !this.m_38903_(stackInSlot, this.socketableStart, this.socketableEnd, false) : (ISpellAcceptor.isContainer(stackInSlot) ? !this.m_38903_(stackInSlot, this.bulletStart, this.bulletEnd, false) : (from < this.hotbarStart ? !this.m_38903_(stackInSlot, this.hotbarStart, this.hotbarEnd, true) : !this.m_38903_(stackInSlot, this.playerStart, this.playerEnd, false))))) : (stackInSlot.m_41720_() instanceof ArmorItem ? !this.m_38903_(stackInSlot, armorSlot = this.armorStart + (armor = (ArmorItem)stackInSlot.m_41720_()).m_40402_().m_20750_() - 1, armorSlot + 1, true) && !this.m_38903_(stackInSlot, this.playerStart, this.hotbarEnd, true) : !this.m_38903_(stackInSlot, this.playerStart, this.hotbarEnd, true))) {
                return ItemStack.f_41583_;
            }
            slot.m_6654_();
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else if (stackInSlot.m_41613_() == mergeStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, stackInSlot);
        }
        return mergeStack;
    }

    public void m_6877_(Player playerIn) {
        this.assembler.clearCachedCAD();
    }

    static {
        equipmentSlots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    }
}

