/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.RegenPsiEvent;
import vazkii.psi.api.exosuit.IPsiEventArmor;
import vazkii.psi.api.exosuit.PsiArmorEvent;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.LoopcastEndEvent;
import vazkii.psi.api.spell.PieceExecutedEvent;
import vazkii.psi.api.spell.PieceGroupAdvancementComplete;
import vazkii.psi.api.spell.PieceKnowledgeEvent;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.core.handler.ClientTickHandler;
import vazkii.psi.client.render.entity.RenderSpellCircle;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.LoopcastTrackingHandler;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageDataSync;
import vazkii.psi.common.network.message.MessageDeductPsi;
import vazkii.psi.common.network.message.MessageTriggerJumpSpell;

public class PlayerDataHandler {
    private static final WeakHashMap<Player, PlayerData> remotePlayerData = new WeakHashMap();
    private static final WeakHashMap<Player, PlayerData> playerData = new WeakHashMap();
    public static final Set<SpellContext> delayedContexts = new LinkedHashSet<SpellContext>();
    private static final String DATA_TAG = "PsiData";
    public static final DamageSource damageSourceOverload = new DamageSource("psi-overload").m_19380_().m_19382_();

    @Nonnull
    public static PlayerData get(Player player) {
        if (player == null) {
            return new PlayerData();
        }
        WeakHashMap<Player, PlayerData> dataMap = player.f_19853_.f_46443_ ? remotePlayerData : playerData;
        PlayerData data = dataMap.computeIfAbsent(player, PlayerData::new);
        if (data.playerWR != null && data.playerWR.get() != player) {
            CompoundTag cmp = new CompoundTag();
            data.writeToNBT(cmp);
            dataMap.remove(player);
            data = PlayerDataHandler.get(player);
            data.readFromNBT(cmp);
        }
        return data;
    }

    public static CompoundTag getDataCompoundForPlayer(Player player) {
        CompoundTag persistentData;
        CompoundTag forgeData = player.getPersistentData();
        if (!forgeData.m_128441_("PlayerPersisted")) {
            forgeData.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
        }
        if (!(persistentData = forgeData.m_128469_("PlayerPersisted")).m_128441_(DATA_TAG)) {
            persistentData.m_128365_(DATA_TAG, (Tag)new CompoundTag());
        }
        return persistentData.m_128469_(DATA_TAG);
    }

    public static class PlayerData
    implements IPlayerData {
        private static final String TAG_AVAILABLE_PSI = "availablePsi";
        private static final String TAG_REGEN_CD = "regenCd";
        private static final String TAG_OVERFLOWED = "overflowed";
        private static final String TAG_EIDOS_ANCHOR_X = "eidosAnchorX";
        private static final String TAG_EIDOS_ANCHOR_Y = "eidosAnchorY";
        private static final String TAG_EIDOS_ANCHOR_Z = "eidosAnchorZ";
        private static final String TAG_EIDOS_ANCHOR_PITCH = "eidosAnchorPitch";
        private static final String TAG_EIDOS_ANCHOR_YAW = "eidosAnchorYaw";
        private static final String TAG_EIDOS_ANCHOR_TIME = "eidosAnchorTime";
        private static final String TAG_CUSTOM_DATA = "customData";
        public int totalPsi = 5000;
        public int regen = 25;
        public int availablePsi;
        public int lastAvailablePsi;
        public int regenCooldown;
        public boolean loopcasting = false;
        public InteractionHand loopcastHand = null;
        public ItemStack lastTickLoopcastStack;
        public int loopcastTime = 1;
        public int loopcastAmount = 0;
        public int loopcastFadeTime = 0;
        public boolean overflowed = false;
        public final Stack<Vector3> eidosChangelog = new Stack();
        public Vector3 eidosAnchor = new Vector3(0.0, 0.0, 0.0);
        public double eidosAnchorPitch;
        public double eidosAnchorYaw;
        public boolean isAnchored;
        public boolean isReverting;
        public int eidosAnchorTime;
        public int postAnchorRecallTime;
        public int eidosReversionTime;
        public DimensionType lastDimension;
        private boolean lowLight;
        private boolean underwater;
        private boolean lowHp;
        public boolean deductTick;
        public final List<Deduction> deductions = new ArrayList<Deduction>();
        public final WeakReference<Player> playerWR;
        private final boolean client;
        private CompoundTag customData;

        private PlayerData() {
            this.playerWR = new WeakReference<Object>(null);
            this.client = true;
        }

        public PlayerData(Player player) {
            this.playerWR = new WeakReference<Player>(player);
            this.client = player.m_20193_().f_46443_;
            this.load();
        }

        /*
         * Unable to fully structure code
         */
        public void tick() {
            block45: {
                block43: {
                    block49: {
                        block46: {
                            block48: {
                                block47: {
                                    block44: {
                                        player = (Player)this.playerWR.get();
                                        if (player == null) {
                                            return;
                                        }
                                        dimension = player.m_20193_().m_6042_();
                                        if (this.deductTick) {
                                            this.deductTick = false;
                                        } else {
                                            this.lastAvailablePsi = this.availablePsi;
                                        }
                                        max = this.getTotalPsi();
                                        if (this.availablePsi > max) {
                                            this.availablePsi = max;
                                        }
                                        if (!(cadStack = this.getCAD()).m_41619_()) {
                                            cad = (ICAD)cadStack.m_41720_();
                                            overflow = cad.getStatValue(cadStack, EnumCADStat.OVERFLOW);
                                            if (overflow == -1) {
                                                this.availablePsi = max;
                                            } else {
                                                this.applyRegen(player, max, cadStack);
                                            }
                                        } else {
                                            this.applyRegen(player, max, cadStack);
                                        }
                                        color = 1295871;
                                        if (!cadStack.m_41619_()) {
                                            color = Psi.proxy.getColorForCAD(cadStack);
                                        }
                                        r = (float)PsiRenderHelper.r(color) / 255.0f;
                                        g = (float)PsiRenderHelper.g(color) / 255.0f;
                                        b = (float)PsiRenderHelper.b(color) / 255.0f;
                                        if (player.m_5833_()) {
                                            this.stopLoopcast();
                                        }
                                        if (this.overflowed) {
                                            this.stopLoopcast();
                                        }
                                        if (!this.loopcasting || this.loopcastHand == null) break block43;
                                        stackInHand = player.m_21120_(this.loopcastHand);
                                        if (!stackInHand.m_41619_() && ISocketable.isSocketable(stackInHand) && ISocketable.socketable(stackInHand).canLoopcast()) break block44;
                                        this.stopLoopcast();
                                        break block45;
                                    }
                                    if (this.lastTickLoopcastStack == null) break block46;
                                    if (ItemStack.m_41746_((ItemStack)this.lastTickLoopcastStack, (ItemStack)stackInHand) && ISocketable.isSocketable(this.lastTickLoopcastStack)) break block47;
                                    this.stopLoopcast();
                                    break block45;
                                }
                                lastTickItem = ISocketable.socketable(this.lastTickLoopcastStack);
                                thisTickItem = ISocketable.socketable(stackInHand);
                                lastSlot = lastTickItem.getSelectedSlot();
                                if (lastSlot == (thisSlot = thisTickItem.getSelectedSlot())) break block48;
                                this.stopLoopcast();
                                break block45;
                            }
                            lastTick = lastTickItem.getBulletInSocket(lastSlot);
                            if (ItemStack.m_41728_((ItemStack)lastTick, (ItemStack)(thisTick = thisTickItem.getBulletInSocket(thisSlot)))) break block46;
                            this.stopLoopcast();
                            break block45;
                        }
                        this.lastTickLoopcastStack = stackInHand.m_41777_();
                        socketable = ISocketable.socketable(stackInHand);
                        for (i = 0; i < 5; ++i) {
                            x = player.m_20185_() + (Math.random() - 0.5) * 2.1 * (double)player.m_20205_();
                            y = player.m_20186_() - player.m_6049_();
                            z = player.m_20189_() + (Math.random() - 0.5) * 2.1 * (double)player.m_20205_();
                            grav = -0.15f - (float)Math.random() * 0.03f;
                            Psi.proxy.sparkleFX(x, y, z, r, g, b, grav, 0.25f, 15);
                        }
                        if (this.loopcastTime <= 0 || this.loopcastTime % 5 != 0) ** GOTO lbl84
                        bullet = socketable.getSelectedBullet();
                        if (!bullet.m_41619_() && ISpellAcceptor.hasSpell(bullet)) break block49;
                        this.stopLoopcast();
                        break block45;
                    }
                    spellContainer = ISpellAcceptor.acceptor(bullet);
                    spell = spellContainer.getSpell();
                    context = new SpellContext().setPlayer(player).setSpell(spell).setLoopcastIndex(this.loopcastAmount + 1);
                    context.castFrom = this.loopcastHand;
                    if (!context.isValid() || !context.cspell.metadata.evaluateAgainst(cadStack)) ** GOTO lbl84
                    cost = ItemCAD.getRealCost(cadStack, bullet, context.cspell.metadata.getStat(EnumSpellStat.COST));
                    if (cost > 0 || cost == -1) {
                        if (cost != -1) {
                            this.deductPsi(cost, 0, true);
                        }
                        if (!player.m_20193_().f_46443_ && this.loopcastTime % 10 == 0) {
                            player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), PsiSoundHandler.loopcast, SoundSource.PLAYERS, 0.1f, (float)(0.15 + Math.random() * 0.85));
                        }
                    }
                    if (!player.m_20193_().f_46443_ && !spellContainer.loopcastSpell(context)) {
                        this.stopLoopcast();
                    } else {
                        ++this.loopcastAmount;
lbl84:
                        // 3 sources

                        ++this.loopcastTime;
                    }
                    break block45;
                }
                if (this.loopcastFadeTime > 0) {
                    --this.loopcastFadeTime;
                }
            }
            if (!player.m_6084_() || dimension != this.lastDimension) {
                this.eidosAnchorTime = 0;
                this.eidosReversionTime = 0;
                this.eidosChangelog.clear();
                this.isAnchored = false;
                this.isReverting = false;
            }
            if (this.eidosAnchorTime > 0) {
                if (this.eidosAnchorTime == 1) {
                    if (player instanceof ServerPlayer) {
                        pmp = (ServerPlayer)player;
                        pmp.f_8906_.m_9774_(this.eidosAnchor.x, this.eidosAnchor.y, this.eidosAnchor.z, (float)this.eidosAnchorYaw, (float)this.eidosAnchorPitch);
                        for (riding = player.m_20202_(); riding != null; riding = riding.m_20202_()) {
                            riding.m_6034_(this.eidosAnchor.x, this.eidosAnchor.y, this.eidosAnchor.z);
                        }
                    }
                    this.postAnchorRecallTime = 0;
                }
                --this.eidosAnchorTime;
            } else if (this.postAnchorRecallTime < 5) {
                --this.postAnchorRecallTime;
                this.isAnchored = false;
            }
            if (this.eidosReversionTime > 0) {
                if (this.eidosChangelog.isEmpty()) {
                    this.eidosReversionTime = 0;
                    this.isReverting = false;
                } else {
                    this.eidosChangelog.pop();
                    if (this.eidosChangelog.isEmpty()) {
                        this.eidosReversionTime = 0;
                        this.isReverting = false;
                    } else {
                        vec = this.eidosChangelog.pop();
                        if (player instanceof ServerPlayer) {
                            pmp = (ServerPlayer)player;
                            pmp.f_8906_.m_9780_(vec.x, vec.y, vec.z, 0.0f, 0.0f, (Set)ImmutableSet.of((Object)ClientboundPlayerPositionPacket.RelativeArgument.X_ROT, (Object)ClientboundPlayerPositionPacket.RelativeArgument.Y_ROT));
                            pmp.f_8906_.m_9953_();
                        } else {
                            player.m_6034_(vec.x, vec.y, vec.z);
                        }
                        for (riding = player.m_20202_(); riding != null; riding = riding.m_20202_()) {
                            riding.m_6034_(vec.x, vec.y, vec.z);
                        }
                        if (player.f_19853_.f_46443_) {
                            for (i = 0; i < 5; ++i) {
                                spread = 0.6;
                                x = player.m_20185_() + (Math.random() - 0.5) * spread;
                                y = player.m_20186_() + (Math.random() - 0.5) * spread;
                                z = player.m_20189_() + (Math.random() - 0.5) * spread;
                                Psi.proxy.sparkleFX(x, y, z, r, g, b, 0.0f, 0.0f, 0.0f, 1.2f, 12);
                            }
                        }
                        player.m_20334_(0.0, 0.0, 0.0);
                        player.f_19789_ = 0.0f;
                    }
                }
                --this.eidosReversionTime;
                if (this.eidosReversionTime == 0 || player.m_6144_()) {
                    this.eidosChangelog.clear();
                    this.isReverting = false;
                }
            } else {
                if (this.eidosChangelog.size() > 600) {
                    this.eidosChangelog.remove(0);
                }
                this.eidosChangelog.push(Vector3.fromEntity((Entity)player));
            }
            pos = player.m_20183_();
            light = player.m_20193_().m_5518_().m_75831_(pos, 0);
            v0 = lowLight = light == 0;
            if (!this.lowLight && lowLight) {
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.low_light"));
            }
            this.lowLight = lowLight;
            underwater = player.m_20069_();
            if (!this.underwater && underwater) {
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.underwater"));
            }
            this.underwater = underwater;
            v1 = lowHp = player.m_21223_() <= 6.0f;
            if (!this.lowHp && lowHp) {
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.low_hp"));
            }
            this.lowHp = lowHp;
            remove = new ArrayList<Deduction>();
            for (Deduction d : this.deductions) {
                if (d.invalid) {
                    remove.add(d);
                    continue;
                }
                d.tick();
            }
            this.deductions.removeAll(remove);
            this.lastDimension = dimension;
        }

        private void applyRegen(Player player, int max, ItemStack cadStack) {
            RegenPsiEvent event = new RegenPsiEvent(player, this, cadStack);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (!cadStack.m_41619_()) {
                    ICAD cad = (ICAD)cadStack.m_41720_();
                    cad.regenPsi(cadStack, event.getCadRegen());
                }
                boolean anyChange = false;
                if (this.availablePsi != max && event.getPlayerRegen() > 0) {
                    anyChange = true;
                }
                int prevPsi = this.availablePsi;
                this.availablePsi = Math.min(max, this.availablePsi + event.getPlayerRegen());
                if (this.overflowed && event.willHealOverflow()) {
                    anyChange = true;
                    this.overflowed = false;
                }
                if (this.regenCooldown != event.getRegenCooldown()) {
                    anyChange = true;
                }
                this.regenCooldown = event.getRegenCooldown();
                if (anyChange) {
                    if (player instanceof ServerPlayer) {
                        MessageDeductPsi message = new MessageDeductPsi(prevPsi, this.availablePsi, this.regenCooldown, false);
                        MessageRegister.sendToPlayer(message, player);
                    }
                    this.save();
                }
            }
        }

        public void stopLoopcast() {
            Player player = (Player)this.playerWR.get();
            if (this.loopcasting) {
                this.loopcastFadeTime = 5;
                MinecraftForge.EVENT_BUS.post((Event)new LoopcastEndEvent(player, this, this.loopcastHand, this.loopcastAmount));
            }
            this.loopcasting = false;
            this.lastTickLoopcastStack = null;
            this.loopcastHand = null;
            this.loopcastTime = 1;
            this.loopcastAmount = 0;
            if (player instanceof ServerPlayer) {
                LoopcastTrackingHandler.syncForTrackersAndSelf((ServerPlayer)player);
            }
        }

        public int calculateDamageDeduction(float amount) {
            return (int)((double)this.getTotalPsi() * 0.02 * (double)amount);
        }

        public void damage(float amount) {
            int psi = this.calculateDamageDeduction(amount);
            if (psi > 0 && this.availablePsi > 0) {
                psi = Math.min(psi, this.availablePsi);
                this.deductPsi(psi, 20, true, true);
            }
        }

        public ItemStack getCAD() {
            return PsiAPI.getPlayerCAD((Player)this.playerWR.get());
        }

        public void deductPsi(int psi, int cd, boolean sync) {
            this.deductPsi(psi, cd, sync, false);
        }

        @Override
        public void deductPsi(int psi, int cd, boolean sync, boolean shatter) {
            ICAD cad;
            int storedPsi;
            int currentPsi = this.availablePsi;
            Player player = (Player)this.playerWR.get();
            if (player == null) {
                return;
            }
            ItemStack cadStack = this.getCAD();
            if (!cadStack.m_41619_() && (storedPsi = (cad = (ICAD)cadStack.m_41720_()).getStoredPsi(cadStack)) == -1) {
                return;
            }
            this.availablePsi -= psi;
            if (this.regenCooldown < cd) {
                this.regenCooldown = cd;
            }
            if (this.availablePsi < 0) {
                int overflow = -this.availablePsi;
                this.availablePsi = 0;
                if (!cadStack.m_41619_()) {
                    ICAD cad2 = (ICAD)cadStack.m_41720_();
                    overflow = cad2.consumePsi(cadStack, overflow);
                }
                if (!shatter && overflow > 0) {
                    float dmg = (float)overflow / (float)(this.loopcasting ? 50 : 125);
                    if (!this.client) {
                        player.m_6469_(damageSourceOverload, dmg);
                    }
                    this.overflowed = true;
                }
            }
            if (sync && player instanceof ServerPlayer) {
                MessageDeductPsi message = new MessageDeductPsi(currentPsi, this.availablePsi, this.regenCooldown, shatter);
                MessageRegister.sendToPlayer(message, player);
            }
            this.save();
        }

        public void addDeduction(int current, int deduct, boolean shatter) {
            if (deduct > current) {
                deduct = current;
            }
            if (deduct < 0) {
                deduct = 0;
            }
            if (deduct == 0) {
                return;
            }
            this.deductions.add(new Deduction(current, deduct, 20, shatter));
        }

        @Override
        public int getAvailablePsi() {
            return this.availablePsi;
        }

        @Override
        public int getLastAvailablePsi() {
            return this.lastAvailablePsi;
        }

        @Override
        public int getTotalPsi() {
            return this.totalPsi;
        }

        @Override
        public int getRegenPerTick() {
            return this.regen;
        }

        @Override
        public boolean isOverflowed() {
            return this.overflowed;
        }

        @Override
        public int getRegenCooldown() {
            return this.regenCooldown;
        }

        public boolean hasAdvancement(ResourceLocation group) {
            Player player = (Player)this.playerWR.get();
            return Psi.proxy.hasAdvancement(group, player);
        }

        @Override
        public boolean isPieceGroupUnlocked(ResourceLocation group, @Nullable ResourceLocation name) {
            Player player = (Player)this.playerWR.get();
            if (player == null) {
                return false;
            }
            if (player.m_7500_()) {
                return true;
            }
            boolean hasAdvancement = this.hasAdvancement(group);
            PieceKnowledgeEvent event = new PieceKnowledgeEvent(group, name, player, this, hasAdvancement);
            MinecraftForge.EVENT_BUS.post((Event)event);
            switch (event.getResult()) {
                case DENY: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void unlockPieceGroup(ResourceLocation resourceLocation) {
            ServerPlayer serverPlayer;
            Advancement advancement;
            Player player = (Player)this.playerWR.get();
            if (player instanceof ServerPlayer && (advancement = (serverPlayer = (ServerPlayer)player).m_20194_().m_129889_().m_136041_(resourceLocation)) != null && !serverPlayer.m_8960_().m_135996_(advancement).m_8193_()) {
                for (String s : serverPlayer.m_8960_().m_135996_(advancement).m_8219_()) {
                    serverPlayer.m_8960_().m_135996_(advancement).m_8196_(s);
                }
            }
        }

        @Override
        public void markPieceExecuted(SpellPiece piece) {
            PieceExecutedEvent event = new PieceExecutedEvent(piece, (Player)this.playerWR.get());
            MinecraftForge.EVENT_BUS.post((Event)event);
            ResourceLocation advancement = PsiAPI.getGroupForPiece(piece.getClass());
            if (advancement != null && PsiAPI.getMainPieceForGroup(advancement) == piece.getClass() && !this.hasAdvancement(advancement)) {
                MinecraftForge.EVENT_BUS.post((Event)new PieceGroupAdvancementComplete(piece, (Player)this.playerWR.get(), advancement));
            }
        }

        @Override
        public CompoundTag getCustomData() {
            if (this.customData == null) {
                this.customData = new CompoundTag();
                return this.customData;
            }
            return this.customData;
        }

        @Override
        public void save() {
            Player player;
            if (!this.client && (player = (Player)this.playerWR.get()) != null) {
                CompoundTag cmp = PlayerDataHandler.getDataCompoundForPlayer(player);
                this.writeToNBT(cmp);
            }
        }

        public void writeToNBT(CompoundTag cmp) {
            cmp.m_128405_(TAG_AVAILABLE_PSI, this.availablePsi);
            cmp.m_128405_(TAG_REGEN_CD, this.regenCooldown);
            cmp.m_128379_(TAG_OVERFLOWED, this.overflowed);
            cmp.m_128347_(TAG_EIDOS_ANCHOR_X, this.eidosAnchor.x);
            cmp.m_128347_(TAG_EIDOS_ANCHOR_Y, this.eidosAnchor.y);
            cmp.m_128347_(TAG_EIDOS_ANCHOR_Z, this.eidosAnchor.z);
            cmp.m_128347_(TAG_EIDOS_ANCHOR_PITCH, this.eidosAnchorPitch);
            cmp.m_128347_(TAG_EIDOS_ANCHOR_YAW, this.eidosAnchorYaw);
            cmp.m_128405_(TAG_EIDOS_ANCHOR_TIME, this.eidosAnchorTime);
            if (this.customData != null) {
                cmp.m_128365_(TAG_CUSTOM_DATA, (Tag)this.customData);
            }
        }

        public void load() {
            Player player;
            if (!this.client && (player = (Player)this.playerWR.get()) != null) {
                CompoundTag cmp = PlayerDataHandler.getDataCompoundForPlayer(player);
                this.readFromNBT(cmp);
            }
        }

        public void readFromNBT(CompoundTag cmp) {
            this.availablePsi = cmp.m_128451_(TAG_AVAILABLE_PSI);
            this.regenCooldown = cmp.m_128451_(TAG_REGEN_CD);
            this.overflowed = cmp.m_128471_(TAG_OVERFLOWED);
            double x = cmp.m_128459_(TAG_EIDOS_ANCHOR_X);
            double y = cmp.m_128459_(TAG_EIDOS_ANCHOR_X);
            double z = cmp.m_128459_(TAG_EIDOS_ANCHOR_X);
            this.eidosAnchor.set(x, y, z);
            this.eidosAnchorPitch = cmp.m_128459_(TAG_EIDOS_ANCHOR_PITCH);
            this.eidosAnchorYaw = cmp.m_128459_(TAG_EIDOS_ANCHOR_YAW);
            this.eidosAnchorTime = cmp.m_128451_(TAG_EIDOS_ANCHOR_TIME);
            this.customData = cmp.m_128469_(TAG_CUSTOM_DATA);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(Player player, float partTicks, PoseStack ms) {
            EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
            double x = player.f_19790_ + (player.m_20185_() - player.f_19790_) * (double)partTicks - renderManager.f_114358_.m_90583_().f_82479_;
            double y = player.f_19791_ + (player.m_20186_() - player.f_19791_) * (double)partTicks - renderManager.f_114358_.m_90583_().f_82480_;
            double z = player.f_19792_ + (player.m_20189_() - player.f_19792_) * (double)partTicks - renderManager.f_114358_.m_90583_().f_82481_;
            float scale = 0.75f;
            if (this.loopcasting) {
                mul = Math.min(5.0f, (float)this.loopcastTime + partTicks) / 5.0f;
                scale *= mul;
            } else if (this.loopcastFadeTime > 0) {
                mul = Math.min(5.0f, (float)this.loopcastFadeTime - partTicks) / 5.0f;
                scale *= mul;
            } else {
                return;
            }
            int color = 1295871;
            ItemStack cad = PsiAPI.getPlayerCAD((Player)this.playerWR.get());
            if (!cad.m_41619_() && cad.m_41720_() instanceof ICAD) {
                ICAD icad = (ICAD)cad.m_41720_();
                color = icad.getSpellColor(cad);
            }
            ms.m_85836_();
            ms.m_85837_(x, y + 0.15, z);
            MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
            RenderSpellCircle.renderSpellCircle((float)ClientTickHandler.ticksInGame + partTicks, scale, 1.0f, 0.0f, -1.0f, 0.0f, color, ms, (MultiBufferSource)buffers);
            buffers.m_109911_();
            ms.m_85849_();
        }

        public static class Deduction {
            public final int current;
            public final int deduct;
            public final int cd;
            public final boolean shatter;
            public int elapsed;
            public boolean invalid;

            public Deduction(int current, int deduct, int cd, boolean shatter) {
                this.current = current;
                this.deduct = deduct;
                this.cd = cd;
                this.shatter = shatter;
            }

            public void tick() {
                ++this.elapsed;
                if (this.elapsed >= this.cd) {
                    this.invalid = true;
                }
            }

            public float getPercentile(float partTicks) {
                return 1.0f - Math.min(1.0f, ((float)this.elapsed + partTicks) / (float)this.cd);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="psi")
    public static class EventHandler {
        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                ArrayList<SpellContext> delayedContextsCopy = new ArrayList<SpellContext>(delayedContexts);
                for (SpellContext context : delayedContextsCopy) {
                    --context.delay;
                    if (context.delay > 0) continue;
                    delayedContexts.remove(context);
                    context.delay = 0;
                    context.cspell.safeExecute(context);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(LivingEvent.LivingTickEvent event) {
            if (event.getEntity() instanceof Player && !event.getEntity().m_5833_()) {
                Player player = (Player)event.getEntity();
                ItemStack cadStack = PsiAPI.getPlayerCAD(player);
                if (!cadStack.m_41619_() && cadStack.m_41720_() instanceof ICAD && PsiAPI.canCADBeUpdated(player)) {
                    ((ICAD)cadStack.m_41720_()).incrementTime(cadStack);
                }
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.tick"));
                PlayerDataHandler.get(player).tick();
            }
        }

        @SubscribeEvent
        public static void onEntityDamage(LivingHurtEvent event) {
            if (event.getEntity() instanceof Player) {
                Player player = (Player)event.getEntity();
                PlayerDataHandler.get(player).damage(event.getAmount());
                LivingEntity attacker = null;
                if (event.getSource().m_7639_() != null && event.getSource().m_7639_() instanceof LivingEntity) {
                    attacker = (LivingEntity)event.getSource().m_7639_();
                }
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.damage", event.getAmount(), attacker));
                if (event.getSource().m_19384_()) {
                    PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.on_fire"));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.getEntity() instanceof ServerPlayer) {
                MessageDataSync message = new MessageDataSync(PlayerDataHandler.get(event.getEntity()));
                MessageRegister.sendToPlayer(message, event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onEntityJump(LivingEvent.LivingJumpEvent event) {
            if (event.getEntity() instanceof Player && event.getEntity().f_19853_.f_46443_ && !event.getEntity().m_5833_()) {
                Player player = (Player)event.getEntity();
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.jump"));
                MessageRegister.HANDLER.sendToServer((Object)new MessageTriggerJumpSpell());
            }
        }

        @SubscribeEvent
        public static void onPsiArmorEvent(PsiArmorEvent event) {
            if (event.getEntity().m_5833_()) {
                return;
            }
            for (int i = 0; i < 4; ++i) {
                ItemStack armor = (ItemStack)event.getEntity().m_150109_().f_35975_.get(i);
                if (armor.m_41619_() || !(armor.m_41720_() instanceof IPsiEventArmor)) continue;
                IPsiEventArmor handler = (IPsiEventArmor)armor.m_41720_();
                handler.onEvent(armor, event);
            }
        }

        @SubscribeEvent
        public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            PlayerDataHandler.get((Player)event.getEntity()).eidosChangelog.clear();
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onRenderWorldLast(RenderLevelStageEvent event) {
            Minecraft mc;
            Entity cameraEntity;
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && (cameraEntity = (mc = Minecraft.m_91087_()).m_91288_()) != null) {
                float partialTicks = event.getPartialTick();
                for (Player player : mc.f_91073_.m_6907_()) {
                    PlayerDataHandler.get(player).render(player, partialTicks, event.getPoseStack());
                }
            }
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onFOVUpdate(ComputeFovModifierEvent event) {
            PlayerData data = PlayerDataHandler.get((Player)Minecraft.m_91087_().f_91074_);
            if (data.isAnchored) {
                float fov = event.getNewFovModifier();
                fov = data.eidosAnchorTime > 0 ? (fov *= Math.min(5.0f, (float)data.eidosAnchorTime - ClientTickHandler.partialTicks) / 5.0f) : (fov *= (10.0f - Math.min(10.0f, (float)data.postAnchorRecallTime + ClientTickHandler.partialTicks)) / 10.0f);
                event.setNewFovModifier(fov);
            }
        }
    }
}

