/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.recipe.ITrickRecipe;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.piece.PieceCraftingTrick;
import vazkii.psi.common.crafting.ModCraftingRecipes;
import vazkii.psi.common.item.base.ModItems;

public class TrickRecipe
implements ITrickRecipe {
    public static final RecipeSerializer<TrickRecipe> SERIALIZER = new Serializer();
    private static final Spell dummySpell = new Spell();
    @Nullable
    private final PieceCraftingTrick piece;
    private final Ingredient input;
    private final ItemStack output;
    private final ItemStack cad;
    private final ResourceLocation id;

    public TrickRecipe(ResourceLocation id, @Nullable PieceCraftingTrick piece, Ingredient input, ItemStack output, ItemStack cad) {
        this.id = id;
        this.piece = piece;
        this.input = input;
        this.output = output;
        this.cad = cad;
    }

    @Override
    @Nullable
    public PieceCraftingTrick getPiece() {
        return this.piece;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public ItemStack m_8043_() {
        return this.output;
    }

    @Override
    public ItemStack getAssembly() {
        return this.cad;
    }

    public boolean matches(RecipeWrapper inv, Level world) {
        return this.getInput().test(inv.m_8020_(0));
    }

    public ItemStack assemble(RecipeWrapper inv) {
        return this.m_8043_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModItems.cad);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return ModCraftingRecipes.TRICK_RECIPE_TYPE;
    }

    public boolean m_5598_() {
        return true;
    }

    static class Serializer
    implements RecipeSerializer<TrickRecipe> {
        Serializer() {
        }

        public TrickRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"), (boolean)true);
            ItemStack cadAssembly = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"cad"), (boolean)true);
            PieceCraftingTrick trick = null;
            if (json.has("trick")) {
                trick = PsiAPI.getSpellPieceRegistry().m_6612_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"trick"))).filter(PieceCraftingTrick.class::isAssignableFrom).map(clazz -> (PieceCraftingTrick)SpellPiece.create(clazz, dummySpell)).orElse(null);
            }
            return new TrickRecipe(id, trick, ingredient, output, cadAssembly);
        }

        @Nullable
        public TrickRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack output = buf.m_130267_();
            ItemStack cadAssembly = buf.m_130267_();
            PieceCraftingTrick trick = null;
            if (buf.readBoolean()) {
                trick = PsiAPI.getSpellPieceRegistry().m_6612_(buf.m_130281_()).map(clazz -> (PieceCraftingTrick)SpellPiece.create(clazz, dummySpell)).orElse(null);
            }
            return new TrickRecipe(id, trick, ingredient, output, cadAssembly);
        }

        public void toNetwork(FriendlyByteBuf buf, TrickRecipe recipe) {
            recipe.input.m_43923_(buf);
            buf.m_130055_(recipe.output);
            buf.m_130055_(recipe.cad);
            if (recipe.piece != null) {
                buf.writeBoolean(true);
                buf.m_130085_(recipe.piece.registryKey);
            } else {
                buf.writeBoolean(false);
            }
        }
    }
}

