/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.tool;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.item.tool.ToolSocketable;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public interface IPsimetalTool {
    public static final String TAG_REGEN_TIME = "regenTime";
    public static final String TAG_BULLET_PREFIX = "bullet";
    public static final String TAG_SELECTED_SLOT = "selectedSlot";

    default public void castOnBlockBreak(ItemStack itemstack, Player player) {
        if (!this.isEnabled(itemstack) || PieceTrickBreakBlock.doingHarvestCheck.get().booleanValue()) {
            return;
        }
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        ItemStack playerCad = PsiAPI.getPlayerCAD(player);
        if (!playerCad.m_41619_()) {
            ISocketable sockets = ISocketable.socketable(itemstack);
            ItemStack bullet = sockets.getSelectedBullet();
            ItemCAD.cast(player.m_20193_(), player, data, bullet, playerCad, 5, 10, 0.05f, context -> {
                context.tool = itemstack;
                context.positionBroken = IPsimetalTool.raytraceFromEntity(player.m_20193_(), player, ClipContext.Fluid.NONE, player.m_21204_().m_22181_((Attribute)ForgeMod.REACH_DISTANCE.get()));
            });
        }
    }

    @Deprecated
    public static boolean isRepairableBy(ItemStack stack) {
        return stack.m_41720_() == ModItems.psimetal;
    }

    public static BlockHitResult raytraceFromEntity(Level worldIn, Player player, ClipContext.Fluid fluidMode, double range) {
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vec3d = player.m_20299_(1.0f);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = range;
        Vec3 vec3d1 = vec3d.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }

    public static void regen(ItemStack stack, Entity entityIn) {
        if (IPsimetalTool.isItemValidForRegen(stack, entityIn)) {
            Player player = (Player)entityIn;
            PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
            int regenTime = stack.m_41784_().m_128451_(TAG_REGEN_TIME);
            if (!data.overflowed && regenTime % 16 == 0 && (float)data.getAvailablePsi() / (float)data.getTotalPsi() > 0.5f) {
                data.deductPsi(150, 0, true);
                stack.m_41721_(stack.m_41773_() - 1);
            }
            stack.m_41784_().m_128405_(TAG_REGEN_TIME, regenTime + 1);
        }
    }

    public static boolean isItemValidForRegen(ItemStack stack, Entity entityIn) {
        if (!(entityIn instanceof Player)) {
            return false;
        }
        Player player = (Player)entityIn;
        return player.m_21206_() != stack && player.m_21205_() != stack && stack.m_41773_() > 0;
    }

    default public boolean isEnabled(ItemStack stack) {
        return stack.m_41773_() < stack.m_41776_();
    }

    default public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ToolSocketable(stack, 3);
    }
}

