/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellHelpers;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickTorrent
extends PieceTrick {
    SpellParam<Vector3> position;

    public PieceTrickTorrent(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel(20.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel(80.0));
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 20);
        meta.addStat(EnumSpellStat.COST, 80);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        if (context.focalPoint.m_20193_().m_6042_().f_63857_()) {
            return null;
        }
        BlockPos pos = SpellHelpers.getBlockPos(this, context, this.position, true, false);
        BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)context.focalPoint.m_20193_().m_46472_(), (LevelAccessor)context.focalPoint.m_20193_(), (BlockPos)pos), context.focalPoint.m_20193_().m_8055_(pos.m_121945_(Direction.UP)), (Entity)context.caster);
        MinecraftForge.EVENT_BUS.post((Event)placeEvent);
        if (placeEvent.isCanceled()) {
            return null;
        }
        return PieceTrickTorrent.placeWater(context.caster, context.focalPoint.f_19853_, pos);
    }

    public static boolean placeWater(@Nullable Player playerIn, Level worldIn, BlockPos pos) {
        if (playerIn == null || !worldIn.m_46805_(pos) || !worldIn.m_7966_(playerIn, pos)) {
            return false;
        }
        BlockState blockstate = worldIn.m_8055_(pos);
        Material material = blockstate.m_60767_();
        boolean flag = blockstate.m_60722_((Fluid)Fluids.f_76193_);
        if (blockstate.m_60795_() || flag || blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, pos, blockstate, (Fluid)Fluids.f_76193_)) {
            if (worldIn.m_6042_().f_63857_()) {
                int i = pos.m_123341_();
                int j = pos.m_123342_();
                int k = pos.m_123343_();
                worldIn.m_5594_(playerIn, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (worldIn.f_46441_.m_188501_() - worldIn.f_46441_.m_188501_()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (blockstate.m_60734_() instanceof LiquidBlockContainer) {
                if (((LiquidBlockContainer)blockstate.m_60734_()).m_7361_((LevelAccessor)worldIn, pos, blockstate, Fluids.f_76193_.m_76068_(false))) {
                    worldIn.m_5594_(playerIn, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                if (!worldIn.f_46443_ && flag && !material.m_76332_()) {
                    worldIn.m_46961_(pos, true);
                }
                worldIn.m_5594_(playerIn, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                worldIn.m_7731_(pos, Fluids.f_76193_.m_76145_().m_76188_(), 11);
            }
            return true;
        }
        return false;
    }
}

