/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.selector.entity.PieceSelectorNearbySmeltables;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class PieceTrickSmeltBlockSequence
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Vector3> target;
    SpellParam<Number> maxBlocks;

    public PieceTrickSmeltBlockSequence(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel("psi.spellparam.max", true).mul(20.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel("psi.spellparam.max", true).sub(1.0).parenthesize().mul(64.0).add(96.0));
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.GREEN, false, false);
        this.addParam(this.target);
        this.maxBlocks = new ParamNumber("psi.spellparam.max", SpellParam.RED, false, true);
        this.addParam(this.maxBlocks);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double maxBlocksVal = (Double)this.getParamEvaluation(this.maxBlocks);
        if (maxBlocksVal == null || maxBlocksVal <= 0.0) {
            throw new SpellCompilationException("psi.spellerror.nonpositivevalue", this.x, this.y);
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(maxBlocksVal * 20.0));
        meta.addStat(EnumSpellStat.COST, (int)(96.0 + (maxBlocksVal - 1.0) * 64.0));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = this.getParamValue(context, this.position);
        Vector3 targetVal = this.getParamValue(context, this.target);
        int maxBlocksInt = this.getParamValue(context, this.maxBlocks).intValue();
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        ItemStack tool = context.tool;
        if (tool.m_41619_()) {
            tool = PsiAPI.getPlayerCAD(context.caster);
        }
        Vector3 targetNorm = targetVal.copy().normalize();
        for (BlockPos blockPos : MathHelper.getBlocksAlongRay(positionVal.toVec3D(), positionVal.copy().add(targetNorm.copy().multiply(maxBlocksInt)).toVec3D(), maxBlocksInt)) {
            Item item;
            Block block1;
            if (!context.isInRadius(Vector3.fromBlockPos(blockPos))) {
                throw new SpellRuntimeException("psi.spellerror.outsideradius");
            }
            if (!context.focalPoint.m_20193_().m_7966_(context.caster, blockPos)) {
                return null;
            }
            BlockState state = context.focalPoint.m_20193_().m_8055_(blockPos);
            Block block = state.m_60734_();
            ItemStack stack = new ItemStack((ItemLike)block);
            BlockEvent.BreakEvent event = PieceTrickBreakBlock.createBreakEvent(state, context.caster, context.focalPoint.f_19853_, blockPos, tool);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return null;
            }
            ItemStack result = PieceSelectorNearbySmeltables.simulateSmelt(context.focalPoint.m_20193_(), stack);
            if (result.m_41619_() || (block1 = Block.m_49814_((Item)(item = result.m_41720_()))) == Blocks.f_50016_) continue;
            context.focalPoint.m_20193_().m_46597_(blockPos, block1.m_49966_());
            context.focalPoint.m_20193_().m_46796_(2001, blockPos, Block.m_49956_((BlockState)block1.m_49966_()));
        }
        return null;
    }
}

