/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import mrtjp.projectred.lib.InventoryLib;
import net.covers1624.quack.util.LazyValue;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public class CraftingHelper {
    private final CraftingContainer craftingInventory = new CraftingContainer(new AbstractContainerMenu(null, -1){

        public boolean m_6875_(Player p_75145_1_) {
            return false;
        }

        public ItemStack m_7648_(Player pPlayer, int pIndex) {
            return ItemStack.f_41583_;
        }
    }, 3, 3);
    private final ResultContainer craftResultInventory = new ResultContainer();
    private final InventorySource inputSource;
    @Nullable
    private CraftingRecipe recipe = null;
    private CraftingResult result = CraftingResult.EMPTY;

    public CraftingHelper(InventorySource inputSource) {
        this.inputSource = inputSource;
    }

    public void clear() {
        this.recipe = null;
        this.craftingInventory.m_6211_();
    }

    public void onInventoryChanged() {
        this.loadInputs();
        this.loadRecipe();
        this.loadOutput();
    }

    public CraftingContainer getCraftingInventory() {
        return this.craftingInventory;
    }

    public ResultContainer getCraftResultInventory() {
        return this.craftResultInventory;
    }

    public void loadInputs() {
        Container craftingMatrix = this.inputSource.getCraftingMatrix();
        for (int i = 0; i < 9; ++i) {
            this.craftingInventory.m_6836_(i, craftingMatrix.m_8020_(i).m_41777_());
        }
    }

    public void loadRecipe() {
        this.recipe = this.inputSource.getWorld().m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.craftingInventory, this.inputSource.getWorld()).orElse(null);
        this.craftResultInventory.m_6836_(0, this.recipe == null ? ItemStack.f_41583_ : this.recipe.m_5874_((Container)this.craftingInventory));
    }

    public void loadOutput() {
        this.result = this.craftFromStorageOrMatrix(true);
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public ItemStack getRecipeOutout() {
        return this.craftResultInventory.m_8020_(0);
    }

    public boolean canTake() {
        return this.result.isCraftable();
    }

    public boolean canTakeIntoStorage() {
        return this.canTake() && this.result.canStorageAcceptResults();
    }

    public int getMissingIngredientMask() {
        return this.result.missingIngredientMask;
    }

    public boolean onCraftedByPlayer(Player player, boolean leaveRemainingInGrid) {
        if (this.recipe == null) {
            return false;
        }
        CraftingResult result = this.craftFromStorageOrMatrix(false);
        if (!result.isCraftable()) {
            return false;
        }
        ForgeHooks.setCraftingPlayer((Player)player);
        NonNullList remainingStacks = this.recipe.m_7457_((Container)this.craftingInventory);
        ForgeHooks.setCraftingPlayer(null);
        Container craftingGird = this.inputSource.getCraftingMatrix();
        Container storage = this.inputSource.getStorage();
        for (int i = 0; i < 9; ++i) {
            ItemStack remaining = (ItemStack)remainingStacks.get(i);
            if (remaining.m_41619_()) continue;
            if (leaveRemainingInGrid && craftingGird.m_8020_(i).m_41619_()) {
                craftingGird.m_6836_(i, remaining.m_41620_(remaining.m_41613_()));
                continue;
            }
            InventoryLib.injectItemStack((Container)storage, (ItemStack)remaining, (boolean)true);
            if (!remaining.m_41619_()) {
                player.m_36356_(remaining);
            }
            if (remaining.m_41619_()) continue;
            player.m_36176_(remaining, false);
        }
        return true;
    }

    public boolean onCraftedIntoStorage() {
        CraftingResult result = this.craftFromStorage(false);
        if (!result.isCraftable() || !result.canFitResultsIntoStorage()) {
            return false;
        }
        NonNullList<ItemStack> allResults = result.getCopyOfAllResults();
        InventoryLib.injectAllItemStacks((Container)this.inputSource.getStorage(), allResults, (boolean)true);
        return true;
    }

    private CraftingResult craftFromStorageOrMatrix(boolean simulate) {
        CraftingResult result = this.craftFromStorage(simulate);
        if (!result.isCraftable() && this.inputSource.canConsumeFromCraftingMatrix()) {
            result = this.craftFromSource(this.inputSource.getCraftingMatrix(), simulate);
        }
        return result;
    }

    private CraftingResult craftFromStorage(boolean simulate) {
        return this.craftFromSource(this.inputSource.getStorage(), simulate);
    }

    private CraftingResult craftFromSource(Container source, boolean simulate) {
        if (this.recipe == null) {
            return CraftingResult.EMPTY;
        }
        if (!this.recipe.m_5818_((Container)this.craftingInventory, this.inputSource.getWorld())) {
            return CraftingResult.EMPTY;
        }
        ItemStack result = this.recipe.m_5874_((Container)this.craftingInventory);
        if (result.m_41619_()) {
            return CraftingResult.EMPTY;
        }
        if (simulate) {
            source = CraftingHelper.copyInventory(source);
        }
        int missingIngredientMask = 0;
        for (int i = 0; i < 9; ++i) {
            boolean isPresent;
            int slot = i;
            ItemStack previousInput = this.craftingInventory.m_8020_(slot);
            if (previousInput.m_41619_() || (isPresent = this.consumeIngredient(source, 0, input -> {
                if (!input.m_41726_(previousInput)) {
                    return false;
                }
                this.craftingInventory.m_6836_(slot, input);
                boolean canStillCraft = this.recipe.m_5818_((Container)this.craftingInventory, this.inputSource.getWorld()) && ItemStack.m_41746_((ItemStack)result, (ItemStack)this.recipe.m_5874_((Container)this.craftingInventory));
                this.craftingInventory.m_6836_(slot, previousInput);
                return canStillCraft;
            }))) continue;
            missingIngredientMask |= 1 << i;
        }
        if (missingIngredientMask != 0) {
            return CraftingResult.missingIngredients(missingIngredientMask);
        }
        return new CraftingResult(result, (NonNullList<ItemStack>)this.recipe.m_7457_((Container)this.craftingInventory), 0, simulate ? source : CraftingHelper.copyInventory(source));
    }

    private boolean consumeIngredient(Container storage, int startIndex, Predicate<ItemStack> matchFunc) {
        int i = startIndex;
        do {
            ItemStack taken;
            ItemStack stack;
            if ((stack = storage.m_8020_(i)).m_41619_() || !matchFunc.test(stack) || (taken = storage.m_7407_(i, 1)).m_41619_()) continue;
            return true;
        } while ((i = (i + 1) % storage.m_6643_()) != startIndex);
        return false;
    }

    private static Container copyInventory(Container inventory) {
        SimpleContainer copy = new SimpleContainer(inventory.m_6643_());
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            copy.m_6836_(i, inventory.m_8020_(i).m_41777_());
        }
        return copy;
    }

    private static final class CraftingResult {
        private static final CraftingResult EMPTY = new CraftingResult(ItemStack.f_41583_, (NonNullList<ItemStack>)NonNullList.m_122779_(), 0, null);
        public final ItemStack outputStack;
        public final NonNullList<ItemStack> remainingItems;
        public final int missingIngredientMask;
        @Nullable
        public final Container remainingStorage;
        private final LazyValue<Boolean> canStorageAcceptResults = new LazyValue(this::canFitResultsIntoStorage);

        public CraftingResult(ItemStack outputStack, NonNullList<ItemStack> remainingItems, int missingIngredientMask, @Nullable Container remainingStorage) {
            this.outputStack = outputStack;
            this.remainingItems = remainingItems;
            this.missingIngredientMask = missingIngredientMask;
            this.remainingStorage = remainingStorage;
        }

        public boolean isCraftable() {
            return !this.outputStack.m_41619_() && this.missingIngredientMask == 0;
        }

        public boolean canStorageAcceptResults() {
            return (Boolean)this.canStorageAcceptResults.get();
        }

        public NonNullList<ItemStack> getCopyOfAllResults() {
            NonNullList allResults = NonNullList.m_122780_((int)(this.remainingItems.size() + 1), (Object)ItemStack.f_41583_);
            int i = 0;
            allResults.set(i++, (Object)this.outputStack.m_41777_());
            for (ItemStack stack : this.remainingItems) {
                allResults.set(i++, (Object)stack.m_41777_());
            }
            return allResults;
        }

        private boolean canFitResultsIntoStorage() {
            assert (this.remainingStorage != null);
            Container storage = CraftingHelper.copyInventory(this.remainingStorage);
            return InventoryLib.injectAllItemStacks((Container)storage, this.getCopyOfAllResults(), (boolean)true);
        }

        public static CraftingResult missingIngredients(int missingIngredientMask) {
            return new CraftingResult(ItemStack.f_41583_, (NonNullList<ItemStack>)NonNullList.m_122779_(), missingIngredientMask, null);
        }
    }

    public static interface InventorySource {
        public Container getCraftingMatrix();

        public Container getStorage();

        default public boolean canConsumeFromCraftingMatrix() {
            return false;
        }

        public Level getWorld();
    }
}

