/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.init.CBMultipartModContent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mrtjp.projectred.api.BlockMover;
import mrtjp.projectred.api.Frame;
import mrtjp.projectred.api.FrameInteraction;
import mrtjp.projectred.api.IExpansionAPI;
import mrtjp.projectred.api.MovementController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.util.LazyOptional;

public class MovementRegistry {
    private static final List<FrameInteraction> frameInteractions = new LinkedList<FrameInteraction>();
    private static final Map<Block, BlockMover> blockMovers = new HashMap<Block, BlockMover>();

    public static void init() {
        blockMovers.put((Block)CBMultipartModContent.MULTIPART_BLOCK.get(), MultipartTileMover.INSTANCE);
    }

    public static void registerBlockMover(Block block, BlockMover mover) {
        blockMovers.put(block, mover);
    }

    public static void registerFrameInteraction(FrameInteraction interaction) {
        frameInteractions.add(interaction);
    }

    @Nullable
    public static Frame getFrame(Level level, BlockPos pos) {
        LazyOptional cap;
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof Frame) {
            Frame f = (Frame)block;
            return f;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof Frame) {
            Frame f = (Frame)be;
            return f;
        }
        if (be != null && (cap = be.getCapability(IExpansionAPI.FRAME_CAPABILITY)).isPresent()) {
            return (Frame)cap.orElseThrow(() -> new RuntimeException("??"));
        }
        for (FrameInteraction interaction : frameInteractions) {
            if (!interaction.canInteract(level, pos)) continue;
            return interaction;
        }
        return null;
    }

    @Nullable
    public static MovementController getMovementController(Level level, BlockPos pos) {
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof MovementController) {
            MovementController mhb = (MovementController)block;
            return mhb;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MovementController) {
            MovementController mbe = (MovementController)be;
            return mbe;
        }
        return null;
    }

    public static BlockMover getMover(Level level, BlockPos pos) {
        Block block = level.m_8055_(pos).m_60734_();
        if (blockMovers.containsKey(block)) {
            return blockMovers.get(block);
        }
        return SaveLoadTileMover.INSTANCE;
    }

    private static void silentSetBlockState(LevelChunk chunk, BlockPos pos, BlockState state) {
        int l;
        int k;
        int y = pos.m_123342_();
        LevelChunkSection section = chunk.m_183278_(chunk.m_151564_(y));
        boolean hasOnlyAir = section.m_188008_();
        if (hasOnlyAir && state.m_60795_()) {
            return;
        }
        int j = pos.m_123341_() & 0xF;
        BlockState oldState = section.m_62986_(j, k = y & 0xF, l = pos.m_123343_() & 0xF, state);
        if (oldState == state) {
            return;
        }
        chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING).m_64249_(j, y, l, state);
        chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES).m_64249_(j, y, l, state);
        chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR).m_64249_(j, y, l, state);
        chunk.m_6005_(Heightmap.Types.WORLD_SURFACE).m_64249_(j, y, l, state);
    }

    private static class MultipartTileMover
    implements BlockMover {
        public static final MultipartTileMover INSTANCE = new MultipartTileMover();

        private MultipartTileMover() {
        }

        public boolean canMove(Level w, BlockPos pos) {
            return w.m_7702_(pos) instanceof TileMultipart;
        }

        public void move(Level w, BlockPos pos, Direction dir) {
            BlockEntity be = w.m_7702_(pos);
            if (!(be instanceof TileMultipart)) {
                return;
            }
            TileMultipart tmp = (TileMultipart)be;
            LevelChunk chunk = w.m_46745_(pos);
            BlockState state = w.m_8055_(pos);
            BlockPos pos2 = pos.m_121945_(dir);
            LevelChunk chunk2 = w.m_46745_(pos2);
            MovementRegistry.silentSetBlockState(chunk, pos, Blocks.f_50016_.m_49966_());
            chunk.m_8114_(pos);
            MovementRegistry.silentSetBlockState(chunk2, pos2, state);
            tmp.f_58858_ = pos2;
            chunk2.m_142170_((BlockEntity)tmp);
        }

        public void postMove(Level w, BlockPos pos) {
            BlockEntity be = w.m_7702_(pos);
            if (be instanceof TileMultipart) {
                TileMultipart tmp = (TileMultipart)be;
                tmp.onMoved();
            }
        }
    }

    private static class SaveLoadTileMover
    implements BlockMover {
        public static final SaveLoadTileMover INSTANCE = new SaveLoadTileMover();

        private SaveLoadTileMover() {
        }

        public boolean canMove(Level w, BlockPos pos) {
            return true;
        }

        public void move(Level w, BlockPos pos, Direction dir) {
            LevelChunk chunk = w.m_46745_(pos);
            BlockPos pos2 = pos.m_121945_(dir);
            LevelChunk chunk2 = w.m_46745_(pos2);
            BlockState state = w.m_8055_(pos);
            CompoundTag tag = chunk.m_8051_(pos);
            MovementRegistry.silentSetBlockState(chunk, pos, Blocks.f_50016_.m_49966_());
            chunk.m_8114_(pos);
            MovementRegistry.silentSetBlockState(chunk2, pos2, state);
            if (tag != null) {
                tag.m_128405_("x", pos2.m_123341_());
                tag.m_128405_("y", pos2.m_123342_());
                tag.m_128405_("z", pos2.m_123343_());
                chunk2.m_5604_(tag);
            }
        }

        public void postMove(Level w, BlockPos pos) {
            LevelChunk chunk = w.m_46745_(pos);
            chunk.m_7702_(pos);
        }
    }
}

