/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import codechicken.lib.gui.SimpleCreativeTab;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.PartConverter;
import codechicken.multipart.util.MultipartGenerator;
import mrtjp.projectred.api.ProjectRedAPI;
import mrtjp.projectred.expansion.ExpansionAPI;
import mrtjp.projectred.expansion.ExpansionNetwork;
import mrtjp.projectred.expansion.MovementManager;
import mrtjp.projectred.expansion.MovementRegistry;
import mrtjp.projectred.expansion.data.ExpansionBlockStateModelProvider;
import mrtjp.projectred.expansion.data.ExpansionBlockTagsProvider;
import mrtjp.projectred.expansion.data.ExpansionItemModelProvider;
import mrtjp.projectred.expansion.data.ExpansionLanguageProvider;
import mrtjp.projectred.expansion.data.ExpansionLootTableProvider;
import mrtjp.projectred.expansion.data.ExpansionRecipeProvider;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.init.ExpansionClientInit;
import mrtjp.projectred.expansion.init.ExpansionItems;
import mrtjp.projectred.expansion.init.ExpansionMenus;
import mrtjp.projectred.expansion.init.ExpansionParts;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="projectred_expansion")
public class ProjectRedExpansion {
    public static final String MOD_ID = "projectred_expansion";
    public static final Logger LOGGER = LogManager.getLogger((String)"projectred_expansion");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"projectred_expansion");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"projectred_expansion");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"projectred_expansion");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"projectred_expansion");
    public static final DeferredRegister<MultipartType<?>> PART_TYPES = DeferredRegister.create((ResourceLocation)MultipartType.MULTIPART_TYPES, (String)"projectred_expansion");
    public static final DeferredRegister<PartConverter> PART_CONVERTERS = DeferredRegister.create((ResourceLocation)PartConverter.PART_CONVERTERS, (String)"projectred_expansion");
    public static final SimpleCreativeTab EXPANSION_GROUP = new SimpleCreativeTab("projectred_expansion", () -> new ItemStack((ItemLike)ExpansionBlocks.PROJECT_BENCH_BLOCK.get()));

    public ProjectRedExpansion() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ExpansionClientInit::init);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        PART_TYPES.register(modEventBus);
        PART_CONVERTERS.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(MovementManager::onChunkWatchEvent);
        MinecraftForge.EVENT_BUS.addListener(MovementManager::onChunkUnwatchEvent);
        MinecraftForge.EVENT_BUS.addListener(MovementManager::onChunkUnloadEvent);
        MinecraftForge.EVENT_BUS.addListener(MovementManager::onLevelTick);
        MinecraftForge.EVENT_BUS.addListener(MovementManager::onLevelLoad);
        MinecraftForge.EVENT_BUS.addListener(MovementManager::onLevelUnload);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ExpansionNetwork.init();
        MultipartGenerator.INSTANCE.registerPassThroughInterface("mrtjp.projectred.api.Frame");
        MovementRegistry.init();
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.m_236039_(event.includeClient(), (DataProvider)new ExpansionBlockStateModelProvider(generator, fileHelper));
        generator.m_236039_(event.includeClient(), (DataProvider)new ExpansionItemModelProvider(generator, fileHelper));
        generator.m_236039_(event.includeClient(), (DataProvider)new ExpansionLanguageProvider(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new ExpansionBlockTagsProvider(generator, fileHelper));
        generator.m_236039_(event.includeServer(), (DataProvider)new ExpansionRecipeProvider(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new ExpansionLootTableProvider(generator));
    }

    static {
        ProjectRedAPI.expansionAPI = ExpansionAPI.INSTANCE;
        ExpansionBlocks.register();
        ExpansionMenus.register();
        ExpansionItems.register();
        ExpansionParts.register();
    }
}

