/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.block;

import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.render.particle.CustomParticleHandler;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import mrtjp.projectred.api.Frame;
import mrtjp.projectred.expansion.client.FrameModelRenderer;
import mrtjp.projectred.expansion.client.FrameModelVerts;
import mrtjp.projectred.lib.ModelVoxelShape;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.fml.DistExecutor;

public class FrameBlock
extends Block
implements Frame {
    private static final VoxelShape[] shapes = new VoxelShape[64];

    public FrameBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60988_());
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level level, HitResult hit, ParticleEngine engine) {
                if (!(hit instanceof BlockHitResult)) {
                    return false;
                }
                BlockHitResult blockHit = (BlockHitResult)hit;
                CustomParticleHandler.addBlockHitEffects((Level)level, (Cuboid6)Cuboid6.full.copy().add(blockHit.m_82425_()), (Direction)blockHit.m_82434_(), (TextureAtlasSprite)FrameModelRenderer.getFrameIcon(), (ParticleEngine)engine);
                return true;
            }

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine engine) {
                CustomParticleHandler.addBlockDestroyEffects((Level)level, (Cuboid6)Cuboid6.full.copy().add(pos), Collections.singletonList(FrameModelRenderer.getFrameIcon()), (ParticleEngine)engine);
                return true;
            }
        });
    }

    public boolean canGrab(Level w, BlockPos pos, Direction side) {
        return true;
    }

    public boolean canBeGrabbed(Level w, BlockPos pos, Direction side) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return FrameBlock.getOrGenerateShape(0);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, level, pos, context);
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.m_5940_(state, level, pos, CollisionContext.m_82749_());
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public static VoxelShape getOrGenerateShape(int mask) {
        VoxelShape s = shapes[mask & 0x3F];
        if (s == null) {
            FrameBlock.shapes[mask & 0x3F] = s = FrameBlock.generateShape(mask);
        }
        return s;
    }

    private static VoxelShape generateShape(int mask) {
        double th = 0.125;
        Cuboid6 e0 = new Cuboid6(0.0, 0.0, 0.0, 1.0, th, th);
        Cuboid6 e1 = e0.copy().apply(Rotation.quarterRotations[1].at(Vector3.CENTER));
        Cuboid6 e2 = e0.copy().apply(Rotation.quarterRotations[2].at(Vector3.CENTER));
        Cuboid6 e3 = e0.copy().apply(Rotation.quarterRotations[3].at(Vector3.CENTER));
        LinkedList<VoxelShape> faceShapes = new LinkedList<VoxelShape>();
        for (int s = 0; s < 6; ++s) {
            Transformation t = Rotation.sideOrientation((int)s, (int)0).at(Vector3.CENTER);
            ImmutableSet.Builder fb = ImmutableSet.builder();
            fb.add((Object)VoxelShapeCache.getShape((Cuboid6)e0.copy().apply(t)));
            fb.add((Object)VoxelShapeCache.getShape((Cuboid6)e2.copy().apply(t)));
            fb.add((Object)VoxelShapeCache.getShape((Cuboid6)e1.copy().apply(t)));
            fb.add((Object)VoxelShapeCache.getShape((Cuboid6)e3.copy().apply(t)));
            faceShapes.add(VoxelShapeCache.merge((ImmutableSet)fb.build()));
        }
        Vertex5[] verts = (Vertex5[])DistExecutor.unsafeRunForDist(() -> () -> FrameModelRenderer.getQuadsForMask(mask), () -> () -> FrameBlock.getQuadsForMask(mask));
        VoxelShape parent = VoxelShapeCache.merge((ImmutableSet)ImmutableSet.copyOf(faceShapes));
        return ModelVoxelShape.fromQuads((VoxelShape)parent, (Vertex5[])verts);
    }

    private static Vertex5[] getQuadsForMask(int mask) {
        LinkedList<Vertex5> verts = new LinkedList<Vertex5>();
        verts.addAll(List.of(FrameModelVerts.verts.get("frame")));
        for (int i = 0; i < 6; ++i) {
            if ((mask & 1 << i) != 0) continue;
            Vertex5[] crossModel = FrameModelVerts.verts.get("cross_" + i);
            verts.addAll(List.of(crossModel));
        }
        return verts.toArray(new Vertex5[0]);
    }
}

