/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.block;

import codechicken.lib.render.particle.CustomParticleHandler;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import java.util.Collections;
import java.util.function.Consumer;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.expansion.client.FrameMotorBlockRenderer;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.tile.FrameMotorTile;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.Nullable;

public class FrameMotorBlock
extends ProjectRedBlock {
    public FrameMotorBlock() {
        super(STONE_PROPERTIES);
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level level, HitResult hit, ParticleEngine engine) {
                if (!(hit instanceof BlockHitResult)) {
                    return false;
                }
                BlockHitResult blockHit = (BlockHitResult)hit;
                CustomParticleHandler.addBlockHitEffects((Level)level, (Cuboid6)Cuboid6.full.copy().add(blockHit.m_82425_()), (Direction)blockHit.m_82434_(), (TextureAtlasSprite)FrameMotorBlockRenderer.getParticleIcon(state, blockHit.m_82434_().ordinal()), (ParticleEngine)engine);
                return true;
            }

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine engine) {
                CustomParticleHandler.addBlockDestroyEffects((Level)level, (Cuboid6)Cuboid6.full.copy().add(pos), Collections.singletonList(FrameMotorBlockRenderer.getParticleIcon(state, 0)), (ParticleEngine)engine);
                return true;
            }
        });
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FrameMotorTile(pos, state);
    }

    protected BlockEntityType<?> getBlockEntityType() {
        return (BlockEntityType)ExpansionBlocks.FRAME_MOTOR_TILE.get();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        int s = context.m_43719_().ordinal() ^ 1;
        int r = context.m_43723_() == null ? 0 : (Rotation.getSidedRotation((Player)context.m_43723_(), (int)context.m_43719_().ordinal()) + 2) % 4;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SIDE, (Comparable)Integer.valueOf(s))).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(r))).m_61124_((Property)CHARGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WORKING, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SIDE, ROTATION, CHARGED, WORKING});
    }
}

