/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.client;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.lighting.LightModel;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.AtlasRegistrar;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.IconTransformation;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class FrameModelRenderer {
    private static final Map<String, CCModel> frameModels = FrameModelRenderer.loadModels("frame");
    private static final CCModel[] models = new CCModel[64];
    private static IconTransformation frameIcon;

    public static TextureAtlasSprite getFrameIcon() {
        return FrameModelRenderer.frameIcon.icon;
    }

    public static void renderStatic(CCRenderState ccrs, int mask) {
        CCModel m = FrameModelRenderer.getOrGenerateModel(mask);
        m.render(ccrs, new IVertexOperation[]{frameIcon});
    }

    public static Vertex5[] getQuadsForMask(int mask) {
        return FrameModelRenderer.getOrGenerateModel((int)mask).verts;
    }

    public static void registerIcons(AtlasRegistrar registrar) {
        registrar.registerSprite(new ResourceLocation("projectred_expansion", "block/frame"), i -> {
            frameIcon = new IconTransformation(i);
        });
    }

    private static Map<String, CCModel> loadModels(String path) {
        ResourceLocation rl = new ResourceLocation("projectred_expansion", "obj/" + path + ".obj");
        Map models = new OBJParser(rl).ignoreMtl().quads().parse();
        models.replaceAll((k, v) -> v.backfacedCopy());
        for (Map.Entry m : models.entrySet()) {
            ((CCModel)m.getValue()).apply((Transformation)new Translation(0.5, 0.0, 0.5));
            ((CCModel)m.getValue()).computeNormals();
            ((CCModel)m.getValue()).shrinkUVs(5.0E-4);
            ((CCModel)m.getValue()).computeLighting(LightModel.standardLightModel);
        }
        if (!FMLEnvironment.production) {
            try {
                String className = path.substring(0, 1).toUpperCase() + path.substring(1) + "ModelVerts";
                String filePath = "./projectred_expansion/" + className + ".java";
                Files.createDirectories(Paths.get(filePath, new String[0]).getParent(), new FileAttribute[0]);
                try (FileWriter writer = new FileWriter(filePath);){
                    writer.write("package mrtjp.projectred.expansion.client;\n\n");
                    writer.write("import codechicken.lib.vec.Vertex5;\n\n");
                    writer.write("import java.util.HashMap;\n");
                    writer.write("import java.util.Map;\n\n");
                    writer.write("/**\n");
                    writer.write(" * Generated by FrameModelRenderer.java. DO NOT EDIT\n");
                    writer.write(" *   Resource: " + rl + "\n");
                    writer.write(" */\n");
                    writer.write("public class " + className + " {\n\n");
                    writer.write("    public static final Map<String, Vertex5[]> verts = new HashMap<>();\n\n");
                    writer.write("    static {\n");
                    for (Map.Entry m : models.entrySet()) {
                        writer.write("        verts.put(\"" + (String)m.getKey() + "\", new Vertex5[] {\n");
                        for (Vertex5 vert : ((CCModel)m.getValue()).verts) {
                            writer.write("            new Vertex5(" + vert.vec.x + ", " + vert.vec.y + ", " + vert.vec.z + ", " + vert.uv.u + ", " + vert.uv.v + "),\n");
                        }
                        writer.write("        });\n\n");
                    }
                    writer.write("    }\n\n");
                    writer.write("}\n");
                    writer.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return models;
    }

    private static CCModel getOrGenerateModel(int mask) {
        CCModel m = models[mask & 0x3F];
        if (m == null) {
            FrameModelRenderer.models[mask & 0x3F] = m = FrameModelRenderer.generateModel(mask);
        }
        return m;
    }

    private static CCModel generateModel(int mask) {
        LinkedList<CCModel> m = new LinkedList<CCModel>();
        m.add(frameModels.get("frame"));
        for (int i = 0; i < 6; ++i) {
            if ((mask & 1 << i) != 0) continue;
            m.add(frameModels.get("cross_" + i));
        }
        return Objects.requireNonNull(CCModel.combine(m));
    }
}

