/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.client;

import codechicken.lib.render.block.ICCBlockRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mrtjp.projectred.expansion.MovementManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class MovingBlockSuppressorRenderer
implements ICCBlockRenderer {
    public static final MovingBlockSuppressorRenderer INSTANCE = new MovingBlockSuppressorRenderer();
    public static boolean allowMovingRenderOnRenderThread = false;
    private static boolean isRendering = false;

    private MovingBlockSuppressorRenderer() {
    }

    public boolean canHandleBlock(BlockAndTintGetter world, BlockPos pos, BlockState blockState, @Nullable RenderType renderType) {
        if (isRendering) {
            return false;
        }
        boolean isMoving = MovingBlockSuppressorRenderer.isMoving(pos);
        if (isMoving) {
            return !RenderSystem.m_69586_() || !allowMovingRenderOnRenderThread;
        }
        return MovingBlockSuppressorRenderer.isAdjacentToMoving(pos);
    }

    public void renderBlock(BlockState state, BlockPos pos, BlockAndTintGetter world, PoseStack mStack, VertexConsumer builder, RandomSource random, ModelData data, @Nullable RenderType renderType) {
        if (MovingBlockSuppressorRenderer.isMoving(pos)) {
            return;
        }
        isRendering = true;
        Minecraft.m_91087_().m_91289_().renderBatched(state, pos, world, mStack, builder, false, random, data, renderType);
        isRendering = false;
    }

    private static boolean isMoving(BlockPos pos) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return false;
        }
        return MovementManager.getInstance((Level)Minecraft.m_91087_().f_91073_).getMovementInfo(pos).isMoving();
    }

    private static boolean isAdjacentToMoving(BlockPos pos) {
        for (int s = 0; s < 6; ++s) {
            if (!MovingBlockSuppressorRenderer.isMoving(pos.m_121945_(Direction.values()[s]))) continue;
            return true;
        }
        return false;
    }
}

