/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.gui.screen.inventory;

import codechicken.lib.colour.EnumColour;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mrtjp.projectred.expansion.inventory.container.AutoCrafterContainer;
import mrtjp.projectred.expansion.item.RecipePlanItem;
import mrtjp.projectred.lib.GuiLib;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractButtonNode;
import mrtjp.projectred.redui.RedUIContainerScreen;
import mrtjp.projectred.redui.RedUINode;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class AutoCrafterScreen
extends RedUIContainerScreen<AutoCrafterContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("projectred_expansion", "textures/gui/auto_crafter.png");
    private boolean isShiftDown = false;

    public AutoCrafterScreen(AutoCrafterContainer container, Inventory playerInventory, Component title) {
        super(176, 212, (AbstractContainerMenu)container, playerInventory, title);
        this.f_97730_ = 8;
        this.f_97731_ = 120;
        this.initSubNodes();
    }

    private void initSubNodes() {
        AbstractButtonNode cyclePlanButton = new AbstractButtonNode(){

            protected void onButtonClicked() {
                ((AutoCrafterContainer)AutoCrafterScreen.this.m_6262_()).getAutoCrafterTile().sendCyclePlan();
            }

            protected void drawButtonBody(PoseStack stack, boolean mouseover) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
                AutoCrafterScreen.this.m_93228_(stack, this.getPosition().x, this.getPosition().y, 176, 0, 14, 14);
            }
        };
        cyclePlanButton.setPosition(126, 23);
        cyclePlanButton.setSize(14, 14);
        this.addChild((RedUINode)cyclePlanButton);
    }

    public void drawBack(PoseStack stack, Point mouse, float partialFrame) {
        super.drawBack(stack, mouse, partialFrame);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int x = this.getFrame().x();
        int y = this.getFrame().y();
        this.m_93228_(stack, x, y, 0, 0, this.getFrame().width(), this.getFrame().height());
        if (((AutoCrafterContainer)this.m_6262_()).canConductorWork()) {
            this.m_93228_(stack, x + 16, y + 16, 177, 18, 7, 9);
        }
        GuiLib.drawVerticalTank((PoseStack)stack, (GuiComponent)this, (int)(x + 16), (int)(y + 26), (int)177, (int)27, (int)7, (int)48, (int)((AutoCrafterContainer)this.m_6262_()).getChargeScaled(48));
        if (((AutoCrafterContainer)this.m_6262_()).isFlowFull()) {
            this.m_93228_(stack, x + 27, y + 16, 185, 18, 7, 9);
        }
        GuiLib.drawVerticalTank((PoseStack)stack, (GuiComponent)this, (int)(x + 27), (int)(y + 26), (int)185, (int)27, (int)7, (int)48, (int)((AutoCrafterContainer)this.m_6262_()).getFlowScaled(48));
        int s = ((AutoCrafterContainer)this.m_6262_()).getProgressScaled(22);
        this.m_93228_(stack, x + 100, y + 41, 193, 23, s + 1, 14);
        ItemStack output = ((AutoCrafterContainer)this.m_6262_()).getPlanOutput();
        if (!output.m_41619_()) {
            this.getItemRenderer().m_115123_(output, x + 125, y + 40);
        }
    }

    public void drawFront(PoseStack stack, Point mouse, float partialFrame) {
        if (this.isShiftDown) {
            this.drawPlanOutputsOverlay(stack, this.getFrame().x(), this.getFrame().y());
        }
        this.drawPlanSlotSelection(stack, this.getFrame().x() + 44, this.getFrame().y() + 22);
    }

    private void drawPlanSlotSelection(PoseStack stack, int xPos, int yPos) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int s = ((AutoCrafterContainer)this.m_6262_()).getPlanSlot();
        int ix = s % 3;
        int iy = s / 3;
        int x = xPos + 18 * ix - 3;
        int y = yPos + 18 * iy - 3;
        this.m_93228_(stack, x, y, 193, 0, 22, 22);
    }

    private void drawPlanOutputsOverlay(PoseStack mStack, int xPos, int yPos) {
        for (Slot slot : ((AutoCrafterContainer)this.m_6262_()).f_38839_) {
            ItemStack stack = slot.m_7993_();
            if (!RecipePlanItem.hasRecipeInside(stack)) continue;
            ItemStack output = RecipePlanItem.loadPlanOutput(stack);
            int colour = EnumColour.LIGHT_BLUE.argb(204);
            this.m_93179_(mStack, xPos + slot.f_40220_, yPos + slot.f_40221_, xPos + slot.f_40220_ + 16, yPos + slot.f_40221_ + 16, colour, colour);
            ItemRenderer renderer = this.getItemRenderer();
            renderer.f_115093_ += 200.0f;
            renderer.m_115123_(output, xPos + slot.f_40220_, yPos + slot.f_40221_);
            renderer.f_115093_ -= 200.0f;
        }
    }

    public boolean onKeyPressed(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        if (!consumed && glfwKeyCode == 340) {
            this.isShiftDown = true;
            return true;
        }
        return false;
    }

    public boolean onKeyReleased(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        if (glfwKeyCode == 340) {
            this.isShiftDown = false;
            return true;
        }
        return false;
    }
}

