/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.gui.screen.inventory;

import codechicken.lib.colour.EnumColour;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mrtjp.projectred.expansion.inventory.container.ProjectBenchContainer;
import mrtjp.projectred.expansion.item.RecipePlanItem;
import mrtjp.projectred.expansion.tile.ProjectBenchTile;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractButtonNode;
import mrtjp.projectred.redui.RedUIContainerScreen;
import mrtjp.projectred.redui.RedUINode;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ProjectBenchScreen
extends RedUIContainerScreen<ProjectBenchContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("projectred_expansion", "textures/gui/project_bench.png");
    private boolean isShiftDown = false;

    public ProjectBenchScreen(ProjectBenchContainer container, Inventory playerInventory, Component title) {
        super(176, 208, (AbstractContainerMenu)container, playerInventory, title);
        this.f_97730_ = 8;
        this.f_97731_ = 116;
        this.initSubNodes();
    }

    private void initSubNodes() {
        AbstractButtonNode writePlanButton = new AbstractButtonNode(){

            protected void onButtonClicked() {
                ((ProjectBenchContainer)ProjectBenchScreen.this.m_6262_()).getProjectBenchTile().sendWriteButtonPressed();
            }

            protected void drawButtonBody(PoseStack stack, boolean mouseover) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
                ProjectBenchScreen.this.m_93228_(stack, this.getPosition().x, this.getPosition().y, 176, 0, 14, 14);
            }
        };
        writePlanButton.setPosition(18, 56);
        writePlanButton.setSize(14, 14);
        this.addChild((RedUINode)writePlanButton);
        AbstractButtonNode clearGridButton = new AbstractButtonNode(){

            protected void onButtonClicked() {
                ((ProjectBenchContainer)ProjectBenchScreen.this.m_6262_()).getProjectBenchTile().sendGridClearButtonPressed();
            }

            protected void drawButtonBody(PoseStack stack, boolean mouseover) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
                ProjectBenchScreen.this.m_93228_(stack, this.getPosition().x, this.getPosition().y, 176, 15, 8, 8);
            }
        };
        clearGridButton.setPosition(37, 17);
        clearGridButton.setSize(8, 8);
        this.addChild((RedUINode)clearGridButton);
    }

    public void drawBack(PoseStack stack, Point mouse, float partialFrame) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int x = this.getFrame().x();
        int y = this.getFrame().y();
        this.m_93228_(stack, x, y, 0, 0, this.getFrame().width(), this.getFrame().height());
        ProjectBenchTile tile = ((ProjectBenchContainer)this.m_6262_()).getProjectBenchTile();
        if (tile.isPlanRecipe()) {
            int missingMask = tile.getCraftingHelper().getMissingIngredientMask();
            CraftingContainer inputs = tile.getCraftingHelper().getCraftingInventory();
            this.drawPlanIngredientsOverlay(stack, (Container)inputs, missingMask, x + 48, y + 18);
        }
    }

    public void drawFront(PoseStack stack, Point mouse, float partialFrame) {
        if (this.isShiftDown) {
            this.drawPlanOutputsOverlay(stack, this.getFrame().x(), this.getFrame().y());
        }
    }

    private void drawPlanIngredientsOverlay(PoseStack mStack, Container ingredients, int missingMask, int xPos, int yPos) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int colour;
                int drawPosX = xPos + x * 18;
                int drawPosY = yPos + y * 18;
                int index = y * 3 + x;
                ItemStack ingredient = ingredients.m_8020_(index);
                int n = colour = (missingMask & 1 << index) != 0 ? EnumColour.RED.argb(119) : EnumColour.GRAY.argb(119);
                if (ingredient.m_41619_()) continue;
                this.m_93179_(mStack, drawPosX, drawPosY, drawPosX + 16, drawPosY + 16, colour, colour);
                this.getItemRenderer().m_115123_(ingredient, drawPosX, drawPosY);
            }
        }
    }

    private void drawPlanOutputsOverlay(PoseStack mStack, int xPos, int yPos) {
        for (Slot slot : ((ProjectBenchContainer)this.m_6262_()).f_38839_) {
            ItemStack stack = slot.m_7993_();
            if (!RecipePlanItem.hasRecipeInside(stack)) continue;
            ItemStack output = RecipePlanItem.loadPlanOutput(stack);
            int colour = EnumColour.LIGHT_BLUE.argb(204);
            this.m_93179_(mStack, xPos + slot.f_40220_, yPos + slot.f_40221_, xPos + slot.f_40220_ + 16, yPos + slot.f_40221_ + 16, colour, colour);
            ItemRenderer renderer = this.getItemRenderer();
            renderer.f_115093_ += 200.0f;
            renderer.m_115123_(output, xPos + slot.f_40220_, yPos + slot.f_40221_);
            renderer.f_115093_ -= 200.0f;
        }
    }

    public boolean onKeyPressed(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        if (!consumed && glfwKeyCode == 340) {
            this.isShiftDown = true;
            return true;
        }
        return false;
    }

    public boolean onKeyReleased(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        if (glfwKeyCode == 340) {
            this.isShiftDown = false;
            return true;
        }
        return false;
    }
}

