/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.core.inventory.container.SimpleDataSlot;
import mrtjp.projectred.expansion.init.ExpansionMenus;
import mrtjp.projectred.expansion.inventory.container.BaseMachineContainer;
import mrtjp.projectred.expansion.item.RecipePlanItem;
import mrtjp.projectred.expansion.tile.AutoCrafterTile;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AutoCrafterContainer
extends BaseMachineContainer {
    public static final ICCLContainerFactory<AutoCrafterContainer> FACTORY = (windowId, playerInv, packet) -> {
        BlockEntity tile = playerInv.f_35978_.f_19853_.m_7702_(packet.readPos());
        if (!(tile instanceof AutoCrafterTile)) {
            return null;
        }
        return new AutoCrafterContainer(playerInv, (AutoCrafterTile)tile, windowId);
    };
    private final Inventory playerInventory;
    private final AutoCrafterTile tile;
    private int planSlot;

    public AutoCrafterContainer(Inventory inventory, AutoCrafterTile tile, int windowId) {
        super((MenuType)ExpansionMenus.AUTO_CRAFTER_CONTAINER.get(), windowId, tile);
        this.playerInventory = inventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)inventory, (int)8, (int)130, x$0 -> this.m_38897_((Slot)x$0));
        this.addAutoCrafterInventory();
        this.m_38895_((DataSlot)new SimpleDataSlot(tile::getPlanSlot, value -> {
            this.planSlot = value;
        }));
    }

    private void addAutoCrafterInventory() {
        InventoryLib.addInventory((Container)this.tile.getStorageInventory(), (int)0, (int)8, (int)80, (int)9, (int)2, x$0 -> this.m_38897_((Slot)x$0));
        InventoryLib.addInventory((Container)this.tile.getPlanInventory(), (int)0, (int)44, (int)22, (int)3, (int)3, PlanSlot::new, x$0 -> this.m_38897_((Slot)x$0));
    }

    public boolean m_6875_(Player player) {
        return !this.tile.m_58901_();
    }

    public AutoCrafterTile getAutoCrafterTile() {
        return this.tile;
    }

    public ItemStack getPlanOutput() {
        ItemStack planStack = this.tile.getPlanInventory().m_8020_(this.planSlot);
        return RecipePlanItem.loadPlanOutput(planStack);
    }

    public int getPlanSlot() {
        return this.planSlot;
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack originalStack = stack.m_41777_();
        if (this.isPlanSlots(slotIndex) ? !this.moveToEntireInventory(stack, false) && !this.moveToStorage(stack, false) : (this.isStorage(slotIndex) ? (stack.m_41720_() instanceof RecipePlanItem ? !this.moveToPlanSlots(stack, false) && !this.moveToEntireInventory(stack, false) : !this.moveToEntireInventory(stack, false)) : (this.isPlayerInventory(slotIndex) || this.isHotbar(slotIndex)) && (stack.m_41720_() instanceof RecipePlanItem ? !this.moveToPlanSlots(stack, false) && !this.moveToStorage(stack, false) : (this.isPlayerInventory(slotIndex) ? !this.moveToStorage(stack, false) && !this.moveToHotbar(stack, false) : !this.moveToStorage(stack, false) && !this.moveToPlayerInventory(stack, false))))) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == originalStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return originalStack;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isStorage(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 54;
    }

    private boolean isPlanSlots(int slotIndex) {
        return slotIndex >= 54 && slotIndex < 63;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 36, reverse);
    }

    private boolean moveToStorage(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 36, 54, reverse);
    }

    private boolean moveToPlanSlots(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 54, 63, reverse);
    }

    private static class PlanSlot
    extends Slot {
        public PlanSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return RecipePlanItem.hasRecipeInside(stack);
        }

        public int m_6641_() {
            return 1;
        }
    }
}

