/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.core.inventory.container.BasePoweredTileContainer;
import mrtjp.projectred.core.inventory.container.SimpleDataSlot;
import mrtjp.projectred.core.tile.BasePoweredTile;
import mrtjp.projectred.expansion.init.ExpansionMenus;
import mrtjp.projectred.expansion.item.IChargable;
import mrtjp.projectred.expansion.item.IRechargableBattery;
import mrtjp.projectred.expansion.tile.BatteryBoxTile;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BatteryBoxContainer
extends BasePoweredTileContainer {
    public static final ICCLContainerFactory<BatteryBoxContainer> FACTORY = (windowId, inventory, packet) -> {
        BlockEntity tile = inventory.f_35978_.f_19853_.m_7702_(packet.readPos());
        if (!(tile instanceof BatteryBoxTile)) {
            return null;
        }
        return new BatteryBoxContainer(inventory, (BatteryBoxTile)tile, windowId);
    };
    private final Inventory playerInventory;
    private final BatteryBoxTile tile;
    protected int powerStored = 0;

    public BatteryBoxContainer(Inventory inventory, BatteryBoxTile tile, int windowId) {
        super((MenuType)ExpansionMenus.BATTERY_BOX_CONTAINER.get(), windowId, (BasePoweredTile)tile);
        this.playerInventory = inventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)inventory, (int)8, (int)89, x$0 -> this.m_38897_((Slot)x$0));
        this.addBatteryBoxInventory();
        this.m_38895_((DataSlot)new SimpleDataSlot(tile::getPowerStored, value -> {
            this.powerStored = value;
        }));
    }

    private void addBatteryBoxInventory() {
        this.m_38897_(new BatterySlot(this.tile.getInventory(), 0, 80, 31));
        this.m_38897_(new BatterySlot(this.tile.getInventory(), 1, 80, 53));
    }

    public boolean m_6875_(Player player) {
        return !this.tile.m_58901_();
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack originalStack = stack.m_41777_();
        if (this.isStorage(slotIndex)) {
            if (!this.moveToEntireInventory(stack, true)) {
                return ItemStack.f_41583_;
            }
        } else if (stack.m_41720_() instanceof IChargable) {
            boolean itemHasPower = ((IChargable)stack.m_41720_()).getStoredPower(stack) > 0;
            boolean tileHasSpace = this.tile.getPowerStored() < this.tile.getMaxStorage();
            if (!this.moveToStorage(stack, itemHasPower && tileHasSpace)) {
                return ItemStack.f_41583_;
            }
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == originalStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return originalStack;
    }

    public int getPowerStoredScaled(int scale) {
        return Math.min(scale, scale * this.powerStored / this.tile.getMaxStorage());
    }

    public boolean isPowerStorageFull() {
        return this.powerStored == this.tile.getMaxStorage();
    }

    public boolean isStorageCharging() {
        return this.condCharge > this.tile.getConductorUpperChargeTarget() && this.powerStored < this.tile.getMaxStorage();
    }

    public boolean isStorageDischarging() {
        return this.condCharge < this.tile.getConductorLowerChargeTarget() && this.powerStored > 0;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isStorage(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 38;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 36, reverse);
    }

    private boolean moveToStorage(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 36, 38, reverse);
    }

    private static class BatterySlot
    extends Slot {
        public BatterySlot(Container inventory, int slot, int x, int y) {
            super(inventory, slot, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_41720_() instanceof IRechargableBattery;
        }
    }
}

