/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.expansion.init.ExpansionMenus;
import mrtjp.projectred.expansion.item.RecipePlanItem;
import mrtjp.projectred.expansion.tile.ProjectBenchTile;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ProjectBenchContainer
extends AbstractContainerMenu {
    public static final ICCLContainerFactory<ProjectBenchContainer> FACTORY = (windowId, playerInv, packet) -> {
        BlockEntity tile = playerInv.f_35978_.f_19853_.m_7702_(packet.readPos());
        if (!(tile instanceof ProjectBenchTile)) {
            return null;
        }
        return new ProjectBenchContainer(playerInv, (ProjectBenchTile)tile, windowId);
    };
    private final ProjectBenchTile tile;
    private final Inventory playerInventory;

    public ProjectBenchContainer(Inventory playerInventory, ProjectBenchTile tile, int windowId) {
        super((MenuType)ExpansionMenus.PROJECT_BENCH_CONTAINER.get(), windowId);
        this.playerInventory = playerInventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)playerInventory, (int)8, (int)126, x$0 -> this.m_38897_((Slot)x$0));
        this.addProjectBenchInventory();
    }

    private void addProjectBenchInventory() {
        InventoryLib.addInventory((Container)this.tile.getStorageInventory(), (int)0, (int)8, (int)76, (int)9, (int)2, x$0 -> this.m_38897_((Slot)x$0));
        InventoryLib.addInventory((Container)this.tile.getCraftingGridInventory(), (int)0, (int)48, (int)18, (int)3, (int)3, x$0 -> this.m_38897_((Slot)x$0));
        this.m_38897_((Slot)new ProjectBenchCraftingSlot(143, 36));
        this.m_38897_(new Slot((Container)this.tile.getPlanInventory(), 0, 17, 36){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof RecipePlanItem;
            }

            public int m_6641_() {
                return 1;
            }
        });
    }

    public ProjectBenchTile getProjectBenchTile() {
        return this.tile;
    }

    public boolean m_6875_(Player player) {
        return !this.tile.m_58901_();
    }

    protected void addPlayerInventory(Inventory playerInventory, int x, int y) {
        this.addInventory((Container)playerInventory, 9, x, y, 9, 3);
        this.addInventory((Container)playerInventory, 0, x, y + 58, 9, 1);
    }

    protected void addInventory(Container inventory, int i, int x, int y, int columns, int rows) {
        for (int c = 0; c < columns; ++c) {
            for (int r = 0; r < rows; ++r) {
                this.m_38897_(new Slot(inventory, i + (r * columns + c), x + c * 18, y + r * 18));
            }
        }
    }

    public void transferAllFromGrid() {
        for (int i = 0; i < 9; ++i) {
            int craftingGridSlot = i + 54;
            if (!this.m_38853_(craftingGridSlot).m_6657_()) continue;
            this.m_7648_(this.playerInventory.f_35978_, craftingGridSlot);
        }
        this.m_38946_();
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack originalStack = stack.m_41777_();
        if (this.isCraftingGrid(slotIndex)) {
            if (!this.moveToStorage(stack, false) && !this.moveToEntireInventory(stack, false)) {
                return ItemStack.f_41583_;
            }
        } else if (this.isStorage(slotIndex)) {
            if (stack.m_41720_() instanceof RecipePlanItem) {
                if (!this.m_38853_(64).m_7993_().m_41619_()) {
                    this.m_7648_(player, 64);
                }
                if (!this.moveToPlanSlot(stack, false) && !this.moveToEntireInventory(stack, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.moveToEntireInventory(stack, false)) {
                return ItemStack.f_41583_;
            }
        } else if (this.isPlanSlot(slotIndex)) {
            if (!this.moveToStorage(stack, true) && !this.moveToEntireInventory(stack, false)) {
                return ItemStack.f_41583_;
            }
        } else if (this.isResultSlot(slotIndex)) {
            if (!slot.m_8010_(player)) {
                return ItemStack.f_41583_;
            }
            if (!this.moveToEntireInventory(stack, true) && !this.moveToStorage(stack, true)) {
                return ItemStack.f_41583_;
            }
        } else if (this.isPlayerInventory(slotIndex) || this.isHotbar(slotIndex)) {
            if (stack.m_41720_() instanceof RecipePlanItem) {
                if (!this.m_38853_(64).m_7993_().m_41619_()) {
                    this.m_7648_(player, 64);
                }
                if (!this.moveToPlanSlot(stack, false) && !this.moveToStorage(stack, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.isPlayerInventory(slotIndex) ? !this.moveToStorage(stack, false) && !this.moveToHotbar(stack, false) : !this.moveToPlayerInventory(stack, false)) {
                return ItemStack.f_41583_;
            }
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == originalStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return originalStack;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.tile.getCraftingHelper().getCraftResultInventory();
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isStorage(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 54;
    }

    private boolean isCraftingGrid(int slotIndex) {
        return slotIndex >= 54 && slotIndex < 63;
    }

    private boolean isResultSlot(int slotIndex) {
        return slotIndex == 63;
    }

    private boolean isPlanSlot(int slotIndex) {
        return slotIndex == 64;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 36, reverse);
    }

    private boolean moveToStorage(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 36, 54, reverse);
    }

    private boolean moveToCraftingGrid(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 54, 63, reverse);
    }

    private boolean moveToPlanSlot(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 64, 65, reverse);
    }

    private class ProjectBenchCraftingSlot
    extends ResultSlot {
        public ProjectBenchCraftingSlot(int x, int y) {
            super(ProjectBenchContainer.this.playerInventory.f_35978_, ProjectBenchContainer.this.tile.getCraftingHelper().getCraftingInventory(), (Container)ProjectBenchContainer.this.tile.getCraftingHelper().getCraftResultInventory(), 0, x, y);
        }

        public boolean m_8010_(Player player) {
            return ProjectBenchContainer.this.tile.getCraftingHelper().canTake();
        }

        public void m_142406_(Player player, ItemStack stack) {
            this.m_5845_(stack);
            ProjectBenchContainer.this.tile.getCraftingHelper().onCraftedByPlayer(player, !ProjectBenchContainer.this.tile.isPlanRecipe());
            ProjectBenchContainer.this.tile.updateRecipeIfNeeded();
        }
    }
}

