/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.item;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mrtjp.projectred.expansion.ProjectRedExpansion;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class RecipePlanItem
extends Item {
    public RecipePlanItem() {
        super(new Item.Properties().m_41491_((CreativeModeTab)ProjectRedExpansion.EXPANSION_GROUP));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (RecipePlanItem.hasRecipeInside(stack)) {
            ItemStack output = RecipePlanItem.loadPlanOutput(stack);
            tooltip.add((Component)Component.m_237115_((String)"projectred-expansion.tooltip.plan_result").m_130946_(": " + output.m_41611_().getString()).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static boolean hasRecipeInside(ItemStack stack) {
        return stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128441_("planInputs") && stack.m_41783_().m_128441_("planOutput");
    }

    public static void savePlan(ItemStack stack, ItemStack[] inputs, ItemStack output) {
        CompoundTag inputsNBT = new CompoundTag();
        for (int i = 0; i < 9; ++i) {
            ItemStack input = inputs[i];
            if (input.m_41619_()) continue;
            if (input.m_41763_()) {
                input = input.m_41777_();
                input.m_41721_(0);
            }
            CompoundTag itemStackNBT = new CompoundTag();
            input.m_41739_(itemStackNBT);
            inputsNBT.m_128365_("input_" + i, (Tag)itemStackNBT);
        }
        CompoundTag outputNBT = new CompoundTag();
        output.m_41739_(outputNBT);
        stack.m_41784_().m_128365_("planInputs", (Tag)inputsNBT);
        stack.m_41784_().m_128365_("planOutput", (Tag)outputNBT);
    }

    public static void loadPlanInputsToGrid(Container craftingGrid, ItemStack stack) {
        if (!RecipePlanItem.hasRecipeInside(stack)) {
            return;
        }
        ItemStack[] inputs = RecipePlanItem.loadPlanInputs(stack);
        if (inputs.length != craftingGrid.m_6643_()) {
            return;
        }
        for (int i = 0; i < inputs.length; ++i) {
            craftingGrid.m_6836_(i, inputs[i]);
        }
    }

    public static ItemStack[] loadPlanInputs(ItemStack stack) {
        Object[] inputs = new ItemStack[9];
        if (!RecipePlanItem.hasRecipeInside(stack)) {
            Arrays.fill(inputs, ItemStack.f_41583_);
            return inputs;
        }
        assert (stack.m_41783_() != null);
        CompoundTag inputsNBT = stack.m_41783_().m_128469_("planInputs");
        for (int i = 0; i < 9; ++i) {
            String id = "input_" + i;
            inputs[i] = inputsNBT.m_128441_(id) ? ItemStack.m_41712_((CompoundTag)inputsNBT.m_128469_(id)) : ItemStack.f_41583_;
        }
        return inputs;
    }

    public static ItemStack loadPlanOutput(ItemStack stack) {
        if (!RecipePlanItem.hasRecipeInside(stack)) {
            return ItemStack.f_41583_;
        }
        assert (stack.m_41783_() != null);
        return ItemStack.m_41712_((CompoundTag)stack.m_41783_().m_128469_("planOutput"));
    }
}

