/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.core.tile.ProjectRedTile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BaseDeviceTile
extends ProjectRedTile {
    protected int side = 0;
    protected boolean powered = false;
    protected boolean active = false;
    private long schedTick = -1L;

    public BaseDeviceTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.side = (Integer)state.m_61143_((Property)ProjectRedBlock.SIDE);
    }

    public void saveToNBT(CompoundTag tag) {
        tag.m_128356_("schedTick", this.schedTick);
        tag.m_128344_("side", (byte)this.side);
        tag.m_128379_("powered", this.powered);
        tag.m_128379_("active", this.active);
    }

    public void loadFromNBT(CompoundTag tag) {
        this.schedTick = tag.m_128454_("schedTick");
        this.side = tag.m_128445_("side");
        this.powered = tag.m_128471_("powered");
        this.active = tag.m_128471_("active");
    }

    public void writeDesc(MCDataOutput out) {
    }

    public void readDesc(MCDataInput in) {
    }

    public void tick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.schedTick >= 0L && this.m_58904_().m_46467_() >= this.schedTick) {
            this.schedTick = -1L;
            this.onScheduledTick();
            this.m_6596_();
        }
    }

    protected void onScheduledTick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (!this.powered) {
            this.active = false;
            this.pushBlockState();
            this.onDeactivated();
            this.m_6596_();
        }
    }

    protected boolean isTickScheduled() {
        return this.schedTick >= 0L;
    }

    protected void scheduleTick(int ticks) {
        long targetTime = this.m_58904_().m_46467_() + (long)ticks;
        if (this.schedTick > 0L && this.schedTick < targetTime) {
            return;
        }
        this.schedTick = targetTime;
        this.m_6596_();
    }

    public void onNeighborBlockChanged(BlockPos neighborPos) {
        super.onNeighborBlockChanged(neighborPos);
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.m_58904_().m_46753_(this.m_58899_())) {
            if (!this.powered) {
                this.powered = true;
                if (!this.active) {
                    this.active = true;
                    this.pushBlockState();
                    this.onActivated();
                }
                this.m_6596_();
            }
        } else {
            if (this.active && !this.isTickScheduled()) {
                this.scheduleTick(4);
            }
            this.powered = false;
            this.m_6596_();
        }
    }

    public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        Item item = held.m_41720_();
        if (item instanceof IScrewdriver) {
            IScrewdriver screwdriver = (IScrewdriver)item;
            if (screwdriver.canUse(player, held)) {
                if (!this.f_58857_.f_46443_) {
                    this.side = (this.side + 1) % 6;
                    screwdriver.damageScrewdriver(player, held);
                    this.pushBlockState();
                    this.m_6596_();
                }
                return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public BlockState storeBlockState(BlockState defaultState) {
        return (BlockState)((BlockState)super.storeBlockState(defaultState).m_61124_((Property)ProjectRedBlock.SIDE, (Comparable)Integer.valueOf(this.side))).m_61124_((Property)ProjectRedBlock.ACTIVE, (Comparable)Boolean.valueOf(this.active));
    }

    protected abstract void onActivated();

    protected abstract void onDeactivated();
}

