/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrtjp.projectred.core.inventory.BaseInventory;
import mrtjp.projectred.expansion.ProjectRedExpansion;
import mrtjp.projectred.expansion.block.BatteryBoxBlock;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.inventory.container.BatteryBoxContainer;
import mrtjp.projectred.expansion.item.IChargable;
import mrtjp.projectred.expansion.item.IRechargableBattery;
import mrtjp.projectred.expansion.tile.LowLoadPoweredTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class BatteryBoxTile
extends LowLoadPoweredTile {
    public static final String TAG_KEY_POWER_STORED = "power_stored";
    public static final String TAG_KEY_CHARGE_LEVEL_STATE = "charge_level";
    private final BatteryBoxInventory inventory = new BatteryBoxInventory();
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    private int powerStored = 0;

    public BatteryBoxTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExpansionBlocks.BATTERY_BOX_TILE.get(), pos, state);
        this.inventory.m_19164_(c -> this.m_6596_());
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        super.saveToNBT(tag);
        tag.m_128405_("storage", this.powerStored);
        this.inventory.saveTo(tag, "inventory");
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        this.powerStored = tag.m_128451_("storage");
        this.inventory.loadFrom(tag, "inventory");
    }

    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
    }

    public void readDesc(MCDataInput in) {
        super.readDesc(in);
    }

    public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.m_58904_().f_46443_) {
            ServerUtils.openContainer((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new BatteryBoxContainer(inv, this, id), (Component)this.m_58900_().m_60734_().m_49954_()), p -> p.writePos(this.m_58899_()));
        }
        return InteractionResult.m_19078_((boolean)this.m_58904_().f_46443_);
    }

    public void onBlockPlaced(@Nullable LivingEntity player, ItemStack item) {
        super.onBlockPlaced(player, item);
        if (!this.getBlockLevel().f_46443_ && item.m_41782_() && Objects.requireNonNull(item.m_41783_()).m_128441_(TAG_KEY_POWER_STORED)) {
            this.powerStored = item.m_41783_().m_128451_(TAG_KEY_POWER_STORED);
            this.pushBlockState();
        }
    }

    public void onBlockRemoved() {
        super.onBlockRemoved();
        BatteryBoxTile.dropInventory((Container)this.inventory, (Level)this.m_58904_(), (Vector3)Vector3.fromBlockPos((BlockPos)this.m_58899_()));
    }

    public ItemStack createStackWithStoredPower() {
        ItemStack stack = new ItemStack((ItemLike)ExpansionBlocks.BATTERY_BOX_BLOCK.get(), 1);
        if (this.powerStored > 0) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_(TAG_KEY_POWER_STORED, this.powerStored);
            tag.m_128405_(TAG_KEY_CHARGE_LEVEL_STATE, this.getPowerStoredScaled(8));
        }
        return stack;
    }

    @Override
    public void tick() {
        int newPowerLevel;
        int prevPowerLevel;
        super.tick();
        if (this.m_58904_().f_46443_) {
            return;
        }
        boolean changed = false;
        if (this.getConductorCharge() > this.getConductorUpperChargeTarget() && this.powerStored < this.getMaxStorage()) {
            n = Math.min(this.getConductorCharge() - this.getConductorUpperChargeTarget(), this.getConductorChargeSpeed()) / 10;
            n = Math.min(n, this.getMaxStorage() - this.powerStored);
            this.conductor.applyPower((double)(n * -1000));
            this.powerStored += n;
            if (n != 0) {
                changed = true;
            }
        } else if (this.getConductorCharge() < this.getConductorLowerChargeTarget() && this.powerStored > 0) {
            n = Math.min(this.getConductorLowerChargeTarget() - this.getConductorCharge(), this.getConductorChargeSpeed()) / 10;
            n = Math.min(n, this.powerStored);
            this.conductor.applyPower((double)(n * 1000));
            this.powerStored -= n;
            if (n != 0) {
                changed = true;
            }
        }
        changed |= this.tryChargeBattery();
        changed |= this.tryDischargeBattery();
        if (this.powerStored < 0) {
            ProjectRedExpansion.LOGGER.warn("Power stored is negative! BatteryBoxTile @{}", (Object)this.m_58899_());
            this.powerStored = 0;
        }
        if ((prevPowerLevel = ((Integer)this.m_58900_().m_61143_((Property)BatteryBoxBlock.CHARGE_LEVEL)).intValue()) != (newPowerLevel = this.getPowerStoredScaled(8))) {
            this.pushBlockState();
        }
        if (changed) {
            this.m_6596_();
        }
    }

    public int getMaxStorage() {
        return 8000;
    }

    public int getConductorUpperChargeTarget() {
        return 900;
    }

    public int getConductorLowerChargeTarget() {
        return 800;
    }

    protected int getConductorChargeSpeed() {
        return 100;
    }

    protected int getBatteryChargeSpeed() {
        return 25;
    }

    protected int getPowerStoredScaled(int i) {
        return Math.min(i, i * this.powerStored / this.getMaxStorage());
    }

    public BlockState storeBlockState(BlockState defaultState) {
        return (BlockState)super.storeBlockState(defaultState).m_61124_((Property)BatteryBoxBlock.CHARGE_LEVEL, (Comparable)Integer.valueOf(this.getPowerStoredScaled(8)));
    }

    private boolean tryChargeBattery() {
        ItemStack stack = this.inventory.m_8020_(0);
        if (!stack.m_41619_() && stack.m_41720_() instanceof IChargable) {
            int toAdd = Math.min(this.powerStored, this.getBatteryChargeSpeed());
            Tuple<ItemStack, Integer> result = ((IChargable)stack.m_41720_()).addPower(stack, toAdd);
            this.inventory.m_6836_(0, (ItemStack)result.m_14418_());
            this.powerStored -= ((Integer)result.m_14419_()).intValue();
            return (Integer)result.m_14419_() != 0;
        }
        return false;
    }

    private boolean tryDischargeBattery() {
        ItemStack stack = this.inventory.m_8020_(1);
        if (!stack.m_41619_() && stack.m_41720_() instanceof IChargable) {
            int toDraw = Math.min(this.getMaxStorage() - this.powerStored, this.getBatteryChargeSpeed());
            Tuple<ItemStack, Integer> result = ((IChargable)stack.m_41720_()).drawPower(stack, toDraw);
            this.inventory.m_6836_(1, (ItemStack)result.m_14418_());
            this.powerStored += ((Integer)result.m_14419_()).intValue();
            return (Integer)result.m_14419_() != 0;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return side == Direction.UP ? this.handlers[0].cast() : this.handlers[1].cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public Container getInventory() {
        return this.inventory;
    }

    public int getPowerStored() {
        return this.powerStored;
    }

    private static class BatteryBoxInventory
    extends BaseInventory
    implements WorldlyContainer {
        private static final int[] TOP_SLOTS = new int[]{0};
        private static final int[] BOTTOM_SLOTS = new int[]{1};

        public BatteryBoxInventory() {
            super(2);
        }

        public int m_6893_() {
            return 1;
        }

        public boolean m_7013_(int slot, ItemStack stack) {
            return stack.m_41720_() instanceof IRechargableBattery;
        }

        public int[] m_7071_(Direction direction) {
            return direction == Direction.UP ? TOP_SLOTS : BOTTOM_SLOTS;
        }

        public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction direction) {
            return true;
        }

        public boolean m_7157_(int slot, ItemStack stack, Direction direction) {
            return true;
        }
    }
}

