/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.core.inventory.BaseInventory;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.inventory.container.ChargingBenchContainer;
import mrtjp.projectred.expansion.item.IChargable;
import mrtjp.projectred.expansion.tile.LowLoadPoweredTile;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class ChargingBenchTile
extends LowLoadPoweredTile {
    private final ChargingBenchInventory inventory = new ChargingBenchInventory();
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    private boolean isCharged = false;
    private int chargeSlot = 0;
    private int powerStored = 0;

    public ChargingBenchTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExpansionBlocks.CHARGING_BENCH_TILE.get(), pos, state);
        this.inventory.m_19164_(c -> this.m_6596_());
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        super.saveToNBT(tag);
        tag.m_128405_("storage", this.powerStored);
        tag.m_128344_("chargeSlot", (byte)this.chargeSlot);
        this.inventory.saveTo(tag, "inventory");
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        this.powerStored = tag.m_128451_("storage");
        this.chargeSlot = tag.m_128445_("chargeSlot") & 0xFF;
        this.inventory.loadFrom(tag, "inventory");
    }

    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
    }

    public void readDesc(MCDataInput in) {
        super.readDesc(in);
    }

    public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.m_58904_().f_46443_) {
            ServerUtils.openContainer((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new ChargingBenchContainer(inv, this, id), (Component)this.m_58900_().m_60734_().m_49954_()), p -> p.writePos(this.m_58899_()));
        }
        return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
    }

    public void onBlockRemoved() {
        super.onBlockRemoved();
        ChargingBenchTile.dropInventory((Container)this.inventory, (Level)this.m_58904_(), (Vector3)Vector3.fromBlockPos((BlockPos)this.m_58899_()));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.m_58904_().f_46443_) {
            return;
        }
        this.isCharged = this.canConductorWork();
        boolean changed = false;
        if (this.getConductorCharge() > this.getConductorUpperChargeTarget() && this.powerStored < this.getMaxStorage()) {
            int n = Math.min(this.getConductorCharge() - this.getConductorUpperChargeTarget(), this.getConductorChargeSpeed()) / 10;
            n = Math.min(n, this.getMaxStorage() - this.powerStored);
            this.conductor.applyPower((double)(n * -10));
            this.powerStored += n;
            if (n != 0) {
                changed = true;
            }
        }
        changed |= this.tryChargeItemInSlot(this.chargeSlot);
        changed |= this.tryDropDownItemInSlot(this.chargeSlot);
        this.chargeSlot = (this.chargeSlot + 1) % 8;
        BlockState state = this.m_58900_();
        if (this.isCharged != (Boolean)state.m_61143_((Property)ProjectRedBlock.CHARGED)) {
            this.pushBlockState();
        }
        if (changed) {
            this.m_6596_();
        }
    }

    public int getMaxStorage() {
        return 8000;
    }

    public int getConductorUpperChargeTarget() {
        return 600;
    }

    protected int getConductorChargeSpeed() {
        return 100;
    }

    protected int getChargeSpeed() {
        return 15;
    }

    protected int getPowerStoredScaled(int i) {
        return Math.min(i, i * this.powerStored / this.getMaxStorage());
    }

    public BlockState storeBlockState(BlockState defaultState) {
        return (BlockState)super.storeBlockState(defaultState).m_61124_((Property)ProjectRedBlock.CHARGED, (Comparable)Boolean.valueOf(this.isCharged));
    }

    private boolean tryChargeItemInSlot(int i) {
        ItemStack stack = this.inventory.m_8020_(i);
        if (!stack.m_41619_() && stack.m_41720_() instanceof IChargable) {
            int toAdd = Math.min(this.powerStored, this.getChargeSpeed());
            Tuple<ItemStack, Integer> result = ((IChargable)stack.m_41720_()).addPower(stack, toAdd);
            this.inventory.m_6836_(i, (ItemStack)result.m_14418_());
            this.powerStored -= ((Integer)result.m_14419_()).intValue();
            return (Integer)result.m_14419_() != 0;
        }
        return false;
    }

    private boolean tryDropDownItemInSlot(int i) {
        ItemStack stack = this.inventory.m_8020_(i);
        if (!stack.m_41619_() && stack.m_41720_() instanceof IChargable && ((IChargable)stack.m_41720_()).isFullyCharged(stack)) {
            InventoryLib.injectItemStack((Container)this.inventory, (ItemStack)stack, (int)8, (int)16, (boolean)false);
            this.inventory.m_6836_(i, stack.m_41619_() ? ItemStack.f_41583_ : stack);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return side == Direction.UP ? this.handlers[0].cast() : this.handlers[1].cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public Container getInventory() {
        return this.inventory;
    }

    public int getPowerStored() {
        return this.powerStored;
    }

    private static class ChargingBenchInventory
    extends BaseInventory
    implements WorldlyContainer {
        private static final int[] TOP_SLOTS = new int[8];
        private static final int[] BOTTOM_SLOTS = new int[8];

        public ChargingBenchInventory() {
            super(16);
        }

        public int m_6893_() {
            return 1;
        }

        public boolean m_7013_(int slot, ItemStack stack) {
            return stack.m_41720_() instanceof IChargable;
        }

        public int[] m_7071_(Direction direction) {
            return direction == Direction.UP ? TOP_SLOTS : BOTTOM_SLOTS;
        }

        public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction direction) {
            return true;
        }

        public boolean m_7157_(int slot, ItemStack stack, Direction direction) {
            return true;
        }

        static {
            for (int i = 0; i < 8; ++i) {
                ChargingBenchInventory.TOP_SLOTS[i] = i;
                ChargingBenchInventory.BOTTOM_SLOTS[i] = i + 8;
            }
        }
    }
}

