/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.multipart.api.tile.RedstoneConnector;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.tile.BaseDeviceTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FireStarterTile
extends BaseDeviceTile
implements RedstoneConnector {
    public FireStarterTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExpansionBlocks.FIRE_STARTER_TILE.get(), pos, state);
    }

    @Override
    protected void onActivated() {
        BlockPos pos = this.m_58899_().m_121945_(Direction.values()[this.side ^ 1]);
        this.emulateFlintAndSteel(pos);
    }

    private boolean emulateFlintAndSteel(BlockPos pos) {
        BlockState state = this.m_58904_().m_8055_(pos);
        if (CampfireBlock.m_51321_((BlockState)state)) {
            FireStarterTile.playFlintAndSteelSound(this.m_58904_(), pos);
            this.m_58904_().m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
            return true;
        }
        if (FireBlock.m_49255_((Level)this.m_58904_(), (BlockPos)pos, (Direction)Direction.NORTH)) {
            FireStarterTile.playFlintAndSteelSound(this.m_58904_(), pos);
            this.m_58904_().m_7731_(pos, FireBlock.m_49245_((BlockGetter)this.m_58904_(), (BlockPos)pos), 11);
            return true;
        }
        return false;
    }

    private static void playFlintAndSteelSound(Level level, BlockPos pos) {
        level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
    }

    @Override
    protected void onDeactivated() {
        BlockPos pos = this.m_58899_().m_121945_(Direction.values()[this.side ^ 1]);
        BlockState state = this.m_58904_().m_8055_(pos);
        if (CampfireBlock.m_51319_((BlockState)state)) {
            this.m_58904_().m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 11);
            return;
        }
        if (state.m_60713_(Blocks.f_50083_) || state.m_60713_(Blocks.f_50084_) || state.m_60713_(Blocks.f_50142_)) {
            this.m_58904_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        }
    }

    public boolean isFireSource(int side) {
        return this.active && this.side == (side ^ 1);
    }

    public int getConnectionMask(int side) {
        return (side ^ 1) == this.side ? 0 : 31;
    }

    public int weakPowerLevel(int side, int mask) {
        return 0;
    }
}

